/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.runners;

import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedRunner
extends BlockJUnit4ClassRunner {
    private static final String PREFIX_KEY = "ClassLoaderRunner_TestMethodName_";
    private static final String NO_NAME = "null";

    public NamedRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        NamedRunner.storeTestMethodName(method.getName());
        super.runChild(method, notifier);
        NamedRunner.removeTestMethodName();
    }

    public static String getTestMethodName() {
        return NamedRunner.retrieveTestMethodName();
    }

    private static String retrieveTestMethodName() {
        String result = null;
        String storedName = System.getProperty(NamedRunner.getKey());
        if (!NO_NAME.equals(storedName)) {
            result = storedName;
        }
        return result;
    }

    private static void removeTestMethodName() {
        System.setProperty(NamedRunner.getKey(), NO_NAME);
    }

    private static void storeTestMethodName(String name) {
        System.setProperty(NamedRunner.getKey(), name);
    }

    private static String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PREFIX_KEY).append(Thread.currentThread().getName());
        return buffer.toString();
    }
}

