/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeBuilder.class);
    private List<ThemeImpl> availableThemes = new ArrayList<ThemeImpl>();
    private TobagoConfigImpl tobagoConfig;

    public ThemeBuilder(TobagoConfigImpl tobagoConfig) {
        this.tobagoConfig = tobagoConfig;
    }

    public void resolveThemes() {
        HashMap<String, ThemeImpl> map = new HashMap<String, ThemeImpl>();
        for (ThemeImpl theme : this.availableThemes) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Theme from XML files: {} ", (Object)theme.getName());
            }
            map.put(theme.getName(), theme);
        }
        for (ThemeImpl theme : this.availableThemes) {
            String fallbackName = theme.getFallbackName();
            ThemeImpl fallback = (ThemeImpl)map.get(fallbackName);
            theme.setFallback(fallback);
        }
        for (ThemeImpl theme : this.availableThemes) {
            theme.resolveFallbacks();
        }
        for (ThemeImpl theme : this.availableThemes) {
            theme.resolveRendererConfig(this.tobagoConfig.getRenderersConfig());
        }
        HashMap<String, ThemeImpl> result = new HashMap<String, ThemeImpl>();
        for (ThemeImpl theme : this.availableThemes) {
            result.put(theme.getName(), theme);
        }
        for (ThemeImpl theme : this.availableThemes) {
            theme.resolveResources();
        }
        for (ThemeImpl theme : this.availableThemes) {
            theme.init();
        }
        this.tobagoConfig.setAvailableThemes(Collections.unmodifiableMap(result));
    }

    public void addTheme(ThemeImpl theme) {
        this.availableThemes.add(theme);
    }
}

