/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Classes {
    private static final Logger LOG = LoggerFactory.getLogger(Classes.class);
    private static final MultiKeyMap CACHE = new MultiKeyMap();
    private final String stringValue;

    public static Classes create(UIComponent component) {
        return Classes.create(component, true, null, null, false);
    }

    public static Classes create(UIComponent component, String sub) {
        return Classes.create(component, true, sub, null, false);
    }

    public static Classes create(UIComponent component, Markup explicit) {
        return Classes.create(component, false, null, explicit, false);
    }

    public static Classes create(UIComponent component, String sub, Markup explicit) {
        return Classes.create(component, false, sub, explicit, false);
    }

    private static synchronized Classes create(UIComponent component, boolean markupFromComponent, String sub, Markup explicit, boolean ignoreCheck) {
        Markup markup;
        String rendererName = StringUtils.uncapitalize(component.getRendererType());
        Classes value = (Classes)CACHE.get((Object)rendererName, (Object)(markup = markupFromComponent ? ((SupportsMarkup)component).getCurrentMarkup() : explicit), (Object)sub);
        if (value == null) {
            value = new Classes(rendererName, markup, sub, ignoreCheck);
            CACHE.put((Object)rendererName, (Object)markup, (Object)sub, (Object)value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Element added (size={}) to cache (renderName='{}', markup='{}', sub='{}')", new Object[]{CACHE.size(), rendererName, markup, sub});
            }
        }
        return value;
    }

    private Classes(String rendererName, Markup markup, String sub, boolean ignoreMarkupCheck) {
        assert (sub == null || StringUtils.isAlphanumeric(sub)) : "Invalid sub element name: '" + sub + "'";
        StringBuilder builder = new StringBuilder(markup != null ? 80 : 32);
        builder.append("tobago-");
        builder.append(rendererName);
        if (sub != null) {
            builder.append('-');
            builder.append(sub);
        }
        if (markup != null) {
            Theme theme = ClientProperties.getInstance(FacesContext.getCurrentInstance()).getTheme();
            for (String markupString : markup) {
                if (ignoreMarkupCheck || theme.getRenderersConfig().isMarkupSupported(rendererName, markupString)) {
                    builder.append(' ');
                    builder.append("tobago-");
                    builder.append(rendererName);
                    if (sub != null) {
                        builder.append('-');
                        builder.append(sub);
                    }
                    builder.append("-markup-");
                    builder.append(markupString);
                    continue;
                }
                if ("none".equals(markupString)) {
                    Deprecation.LOG.warn("Markup 'none' is deprecated, please use a NULL pointer instead.");
                    continue;
                }
                LOG.warn("Ignoring unknown markup='" + markupString + "' for rendererName='" + rendererName + "'");
            }
        }
        this.stringValue = builder.toString();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @Deprecated
    public static String requiredWorkaround(UIComponent component) {
        String rendererName = StringUtils.uncapitalize(component.getRendererType());
        return "tobago-" + rendererName + "-markup-required";
    }

    @Deprecated
    public static Classes createWorkaround(String rendererName, String sub, Markup explicit) {
        return new Classes(rendererName, explicit, sub, false);
    }

    @Deprecated
    public static Classes createWorkaround(String rendererName, Markup explicit) {
        return new Classes(rendererName, explicit, null, false);
    }
}

