/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyShuttle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyShuttleRenderer
extends SelectManyRendererBase {
    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        Integer size;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        AbstractUISelectManyShuttle select = (AbstractUISelectManyShuttle)component;
        String clientId = select.getClientId(facesContext);
        Markup markup = select.getMarkup();
        writer.startElement(HtmlElements.DIV);
        if (select.isLabelLayoutSkip()) {
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        }
        writer.writeClassAttribute((CssItem)TobagoClass.SELECT_MANY_SHUTTLE, TobagoClass.SELECT_MANY_SHUTTLE.createMarkup(markup), new CssItem[]{select.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        boolean hasLabel = select.hasLabel();
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, (UIComponent)select);
        boolean disabled = !items.iterator().hasNext() || select.isDisabled();
        boolean readonly = select.isReadonly();
        String unselectedLabel = select.getUnselectedLabel();
        if (unselectedLabel != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.SELECT_MANY_SHUTTLE__UNSELECTED_LABEL);
            writer.write(unselectedLabel);
            writer.endElement(HtmlElements.DIV);
        }
        size = Math.max((size = select.getSize()) != null ? size.intValue() : items.size(), 2);
        writer.startElement(HtmlElements.SELECT);
        String unselectedClientId = clientId + "::" + "unselected";
        writer.writeIdAttribute(unselectedClientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeClassAttribute(TobagoClass.SELECT_MANY_SHUTTLE__UNSELECTED, BootstrapClass.FORM_CONTROL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        Object[] values = select.getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)select);
        HtmlRendererUtils.renderSelectItems((UIInput)select, TobagoClass.SELECT_MANY_SHUTTLE__OPTION, items, values, submittedValues, false, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.SELECT_MANY_SHUTTLE__TOOL_BAR, BootstrapClass.BTN_GROUP_VERTICAL);
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_DOUBLE_RIGHT, "addAll", TobagoClass.SELECT_MANY_SHUTTLE__ADD_ALL);
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_RIGHT, "add", TobagoClass.SELECT_MANY_SHUTTLE__ADD);
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_LEFT, "remove", TobagoClass.SELECT_MANY_SHUTTLE__REMOVE);
        this.createButton(facesContext, component, writer, disabled | readonly, Icons.ANGLE_DOUBLE_LEFT, "removeAll", TobagoClass.SELECT_MANY_SHUTTLE__REMOVE_ALL);
        writer.endElement(HtmlElements.DIV);
        String selectedLabel = select.getSelectedLabel();
        if (selectedLabel != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(TobagoClass.SELECT_MANY_SHUTTLE__SELECTED_LABEL);
            writer.write(selectedLabel);
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.SELECT);
        String selectedClientId = clientId + "::" + "selected";
        writer.writeIdAttribute(selectedClientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeClassAttribute(TobagoClass.SELECT_MANY_SHUTTLE__SELECTED, BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity((UIComponent)select)), BootstrapClass.FORM_CONTROL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        HtmlRendererUtils.renderSelectItems((UIInput)select, TobagoClass.SELECT_MANY_SHUTTLE__OPTION, items, values, submittedValues, true, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
        writer.startElement(HtmlElements.SELECT);
        writer.writeClassAttribute(TobagoClass.SELECT_MANY_SHUTTLE__HIDDEN);
        String hiddenClientId = clientId + "::" + "hidden";
        writer.writeIdAttribute(hiddenClientId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, select.isRequired());
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        HtmlRendererUtils.renderSelectItems((UIInput)select, TobagoClass.SELECT_MANY_SHUTTLE__OPTION, items, values, submittedValues, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    private void createButton(FacesContext context, UIComponent component, TobagoResponseWriter writer, boolean disabled, Icons icon, String sub, TobagoClass cssClass) throws IOException {
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(cssClass, BootstrapClass.BTN, BootstrapClass.BTN_SECONDARY);
        writer.writeIdAttribute(component.getClientId(context) + "::" + sub);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(Icons.FA, icon);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.BUTTON);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        return component.getClientId(facesContext) + "::" + "unselected";
    }
}

