/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIObject;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ObjectRenderer<T extends AbstractUIObject>
extends RendererBase<T> {
    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        writer.startElement(HtmlElements.IFRAME);
        writer.writeAttribute(HtmlAttributes.FRAMEBORDER, "0", false);
        String clientId = component.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        String name = ((AbstractUIObject)component).getName();
        if (name == null) {
            name = clientId;
        }
        writer.writeNameAttribute(name);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute(HtmlAttributes.SRC, ((AbstractUIObject)component).getSrc(), true);
        writer.writeClassAttribute(TobagoClass.OBJECT, component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        String sandbox = ((AbstractUIObject)component).getSandbox();
        if (sandbox != null) {
            writer.writeAttribute(HtmlAttributes.SANDBOX, sandbox, false);
        }
        writer.writeText(ResourceUtils.getString(facesContext, "object.noframe"));
        writer.writeText(" ");
        if (((AbstractUIObject)component).getSrc() != null) {
            writer.writeText(((AbstractUIObject)component).getSrc());
        }
        writer.endElement(HtmlElements.IFRAME);
    }
}

