/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.updateactionlistener;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentConfig;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.convert.Converter;
import javax.faces.event.ActionListener;
import javax.faces.webapp.UIComponentTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.updateactionlistener.UpdateActionListener;

public class UpdateActionListenerTagHandler
extends TagHandler {
    private static Log logger = LogFactory.getLog(UpdateActionListenerTagHandler.class);
    private TagAttribute converterAttr;
    private TagAttribute propertyAttr;
    private TagAttribute valueAttr = this.getRequiredAttribute("value");

    public UpdateActionListenerTagHandler(ComponentConfig config) {
        this((TagConfig)config);
    }

    public UpdateActionListenerTagHandler(TagConfig config) {
        super(config);
        this.propertyAttr = this.getRequiredAttribute("property");
        this.converterAttr = this.getAttribute("converter");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        String value;
        logger.debug((Object)("Apply called. Component: " + parent));
        ActionSource actionSource = (ActionSource)parent;
        if (this.sourceHasProperty(actionSource)) {
            return;
        }
        UpdateActionListener al = new UpdateActionListener();
        Application app = ctx.getFacesContext().getApplication();
        if (this.converterAttr != null) {
            Converter converter = app.createConverter(this.converterAttr.getValue(ctx));
            al.setConverter(converter);
        }
        if (UIComponentTag.isValueReference((String)(value = this.valueAttr.getValue()))) {
            al.setValueBinding(app.createValueBinding(this.valueAttr.getValue()));
        } else {
            al.setValue(value);
        }
        al.setPropertyBinding(app.createValueBinding(this.propertyAttr.getValue()));
        actionSource.addActionListener((ActionListener)al);
    }

    private boolean sourceHasProperty(ActionSource source) {
        ActionListener[] listeners = source.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            UpdateActionListener al;
            ActionListener listener = listeners[i];
            if (!(listener instanceof UpdateActionListener) || !(al = (UpdateActionListener)listener).getPropertyBinding().getExpressionString().equals(this.propertyAttr.getValue())) continue;
            logger.debug((Object)("Action listener already has a listener for " + this.propertyAttr.getValue()));
            return true;
        }
        logger.debug((Object)("Action listener for property is not present. Property: " + this.propertyAttr.getValue()));
        return false;
    }
}

