/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;

public class PathLength {
    private Shape path = null;
    private Vector segments = null;
    private float pathLength = 0.0f;
    private boolean initialised = false;

    public PathLength(Shape shape) {
        this.setPath(shape);
    }

    public Shape getPath() {
        return this.path;
    }

    public void setPath(Shape shape) {
        this.path = shape;
        this.initialised = false;
    }

    public float lengthOfPath() {
        if (!this.initialised) {
            this.initialise();
        }
        return this.pathLength;
    }

    protected void initialise() {
        this.pathLength = 0.0f;
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(this.path.getPathIterator(new AffineTransform()), 0.01f);
        this.segments = new Vector(20);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray = new float[6];
        this.segments.add(new PathSegment(0, 0.0f, 0.0f, 0.0f));
        while (!flatteningPathIterator.isDone()) {
            int n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    this.segments.add(new PathSegment(n, fArray[0], fArray[1], this.pathLength));
                    f3 = fArray[0];
                    f4 = fArray[1];
                    f = f3;
                    f2 = f4;
                    break;
                }
                case 1: {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f3, f4, fArray[0], fArray[1]));
                    this.segments.add(new PathSegment(n, fArray[0], fArray[1], this.pathLength));
                    f3 = fArray[0];
                    f4 = fArray[1];
                    break;
                }
                case 4: {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f3, f4, f, f2));
                    this.segments.add(new PathSegment(1, f, f2, this.pathLength));
                    f3 = f;
                    f4 = f2;
                    break;
                }
                default: {
                    System.out.println("Bad path segment types");
                }
            }
            flatteningPathIterator.next();
        }
        this.initialised = true;
    }

    public Point2D pointAtLength(float f) {
        int n = this.findUpperIndex(f);
        if (n == -1) {
            return null;
        }
        PathSegment pathSegment = (PathSegment)this.segments.elementAt(n);
        if (n == 0) {
            return new Point2D.Float(pathSegment.getX(), pathSegment.getY());
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.elementAt(n - 1);
        float f2 = f - pathSegment2.getLength();
        double d = Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
        float f3 = (float)((double)pathSegment2.getX() + (double)f2 * Math.cos(d));
        float f4 = (float)((double)pathSegment2.getY() + (double)f2 * Math.sin(d));
        return new Point2D.Float(f3, f4);
    }

    public float angleAtLength(float f) {
        int n = this.findUpperIndex(f);
        if (n == -1) {
            return 0.0f;
        }
        PathSegment pathSegment = (PathSegment)this.segments.elementAt(n);
        if (n == 0) {
            n = 1;
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.elementAt(n - 1);
        float f2 = (float)Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
        return f2;
    }

    public int findUpperIndex(float f) {
        PathSegment pathSegment;
        if (!this.initialised) {
            this.initialise();
        }
        if (f < 0.0f) {
            return -1;
        }
        if (f > this.pathLength) {
            return -1;
        }
        int n = 0;
        int n2 = this.segments.size() - 1;
        while (n != n2) {
            int n3 = n + n2 >> 1;
            PathSegment pathSegment2 = (PathSegment)this.segments.elementAt(n3);
            if (pathSegment2.getLength() >= f) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        while ((pathSegment = (PathSegment)this.segments.elementAt(n2)).getSegType() == 0 && n2 != this.segments.size() - 1) {
            ++n2;
        }
        int n4 = -1;
        int n5 = 0;
        int n6 = this.segments.size();
        while (n4 <= 0 && n5 < n6) {
            PathSegment pathSegment3 = (PathSegment)this.segments.elementAt(n5);
            if (pathSegment3.getLength() >= f && pathSegment3.getSegType() != 0) {
                n4 = n5;
            }
            ++n5;
        }
        if (n2 != n4) {
            System.err.println("UB: " + n2 + " UI: " + n4);
        }
        return n4;
    }

    public static void main(String[] stringArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 100.0f);
        generalPath.lineTo(200.0f, 150.0f);
        generalPath.closePath();
        PathLength pathLength = new PathLength(generalPath);
        System.out.println("New Path Length created");
        System.out.println("Path Length = " + pathLength.lengthOfPath());
        System.out.println("Point at 0 = " + pathLength.pointAtLength(0.0f));
        System.out.println("Point at 10 = " + pathLength.pointAtLength(10.0f));
        System.out.println("Point at 20 = " + pathLength.pointAtLength(20.0f));
        System.out.println("Point at 300 = " + pathLength.pointAtLength(300.0f));
        System.out.println("Point at 3000 = " + pathLength.pointAtLength(3000.0f));
        generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 100.0f);
        generalPath.lineTo(200.0f, 150.0f);
        generalPath.quadTo(450.0f, 525.0f, 400.0f, 250.0f);
        generalPath.closePath();
        pathLength = new PathLength(generalPath);
        System.out.println("Path Length = " + pathLength.lengthOfPath());
        System.out.println("Point at 0 = " + pathLength.pointAtLength(0.0f));
        System.out.println("Point at 10 = " + pathLength.pointAtLength(10.0f));
        System.out.println("Point at 20 = " + pathLength.pointAtLength(20.0f));
        System.out.println("Point at 300 = " + pathLength.pointAtLength(300.0f));
        generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 100.0f);
        generalPath.lineTo(200.0f, 150.0f);
        generalPath.quadTo(450.0f, 525.0f, 400.0f, 250.0f);
        generalPath.lineTo(300.0f, 200.0f);
        generalPath.closePath();
        pathLength = new PathLength(generalPath);
        System.out.println("Path Length = " + pathLength.lengthOfPath());
        System.out.println("Point at 3000 = " + pathLength.pointAtLength(3000.0f));
        System.out.println("Point at 300 = " + pathLength.pointAtLength(300.0f));
        System.out.println("Point at 10 = " + pathLength.pointAtLength(10.0f));
        System.out.println("Point at 0 = " + pathLength.pointAtLength(0.0f));
    }

    protected class PathSegment {
        int segType;
        float X;
        float Y;
        float length;

        public PathSegment(int n, float f, float f2, float f3) {
            this.setSegType(n);
            this.setX(f);
            this.setY(f2);
            this.setLength(f3);
        }

        public int getSegType() {
            return this.segType;
        }

        public void setSegType(int n) {
            this.segType = n;
        }

        public float getX() {
            return this.X;
        }

        public void setX(float f) {
            this.X = f;
        }

        public float getY() {
            return this.Y;
        }

        public void setY(float f) {
            this.Y = f;
        }

        public float getLength() {
            return this.length;
        }

        public void setLength(float f) {
            this.length = f;
        }
    }
}

