/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.config.upload.FileUploadConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.context.external.PortletRequestParameterMap;
import org.apache.myfaces.trinidadinternal.context.external.PortletRequestParameterValuesMap;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;
import org.apache.myfaces.trinidadinternal.webapp.wrappers.ActionRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortletUploadedExternalContext
extends ExternalContextDecorator {
    private ExternalContext _externalContext;
    private PortletRequest _wrappedRequest;
    private Map<String, String> _requestParameterMap;
    private Map<String, String[]> _requestParameterValuesMap;
    private Iterator<String> _requestParameterNames;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PortletUploadedExternalContext.class);

    PortletUploadedExternalContext(ExternalContext externalContext, Map<String, String[]> extractedParams) {
        this._externalContext = externalContext;
        FileUploadConfiguratorImpl.apply(externalContext);
        HashMap<String, String[]> params = new HashMap<String, String[]>(externalContext.getRequestParameterValuesMap());
        params.putAll(extractedParams);
        this._wrappedRequest = new PortletUploadRequestWrapper((ActionRequest)this._externalContext.getRequest(), (ActionResponse)this._externalContext.getResponse(), params);
    }

    public Object getRequest() {
        return this._wrappedRequest;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new PortletRequestParameterMap(this._wrappedRequest);
        }
        return this._requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        if (this._requestParameterNames == null) {
            this._requestParameterNames = this._requestParameterMap != null ? this._requestParameterMap.keySet().iterator() : this.getRequestParameterValuesMap().keySet().iterator();
        }
        return this._requestParameterNames;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new PortletRequestParameterValuesMap(this._wrappedRequest);
        }
        return this._requestParameterValuesMap;
    }

    protected ExternalContext getExternalContext() {
        return this._externalContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortletUploadRequestWrapper
    extends ActionRequestWrapper {
        private Map<String, String[]> _extractedAndDecodedParams;
        private Map<String, String[]> _extractedParams;
        private ActionResponse _response;
        private static final String _WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";

        public PortletUploadRequestWrapper(ActionRequest request, ActionResponse response, Map<String, String[]> params) {
            super(request);
            this._response = response;
            Map origionalMap = super.getParameterMap();
            this._extractedParams = new HashMap<String, String[]>(origionalMap);
            this._extractedParams.putAll(params);
            response.setRenderParameters(this._extractedParams);
        }

        @Override
        public String getContentType() {
            return _WWW_FORM_URLENCODED_TYPE;
        }

        @Override
        public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
            super.setCharacterEncoding(encoding);
            if (_LOG.isFine()) {
                _LOG.fine("Switching encoding of wrapper to " + encoding);
            }
            this._extractedAndDecodedParams = new HashMap<String, String[]>(this._extractedParams.size());
            byte[] buffer = new byte[256];
            for (Map.Entry<String, String[]> entry : this._extractedParams.entrySet()) {
                String key = entry.getKey();
                key = CaboHttpUtils.decodeRequestParameter(key, encoding, buffer);
                String[] oldValue = entry.getValue();
                int length = oldValue.length;
                String[] newValue = new String[length];
                for (int i = 0; i < length; ++i) {
                    newValue[i] = CaboHttpUtils.decodeRequestParameter(oldValue[i], encoding, buffer);
                    if (!_LOG.isFinest()) continue;
                    _LOG.finest("Parameter " + key + ":" + newValue[i]);
                }
                this._extractedAndDecodedParams.put(key, newValue);
                this._response.setRenderParameters(this._extractedAndDecodedParams);
            }
            UploadedFiles.setCharacterEncoding(this, encoding);
        }

        @Override
        public String getParameter(String param) {
            String[] value = this._getParameterValues(param);
            if (value == null) {
                return null;
            }
            return value[0];
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            Map<String, String[]> map = this._getMap();
            return Collections.unmodifiableMap(map);
        }

        @Override
        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this._getMap().keySet());
        }

        @Override
        public String[] getParameterValues(String param) {
            String[] value = this._getParameterValues(param);
            if (value == null) {
                return null;
            }
            return (String[])value.clone();
        }

        private String[] _getParameterValues(String param) {
            return this._getMap().get(param);
        }

        private Map<String, String[]> _getMap() {
            if (this._extractedAndDecodedParams != null) {
                return this._extractedAndDecodedParams;
            }
            return this._extractedParams;
        }
    }
}

