/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context.external;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidadinternal.context.external.AbstractAttributeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletCookieMap
extends AbstractAttributeMap<String, Object> {
    final HttpServletRequest _httpServletRequest;
    private static final Cookie[] EMPTY_ARRAY = new Cookie[0];

    ServletCookieMap(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    @Override
    public boolean containsKey(Object key) {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        if (cookies == null) {
            return false;
        }
        for (Cookie element : cookies) {
            if (!element.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Cookie[] cookies = this._httpServletRequest.getCookies();
        if (cookies == null) {
            return false;
        }
        for (Cookie element : cookies) {
            if (!findValue.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        return cookies == null || cookies.length == 0;
    }

    @Override
    public int size() {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        return cookies == null ? 0 : cookies.length;
    }

    @Override
    protected Object getAttribute(Object key) {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie element : cookies) {
            if (!element.getName().equals(key)) continue;
            return element;
        }
        return null;
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        Cookie[] cookies = this._httpServletRequest.getCookies();
        if (cookies == null) {
            return new CookieNameEnumeration(EMPTY_ARRAY);
        }
        return new CookieNameEnumeration(cookies);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieNameEnumeration
    implements Enumeration<String> {
        private final Cookie[] _cookies;
        private int _index;
        private final int _length;

        public CookieNameEnumeration(Cookie[] cookies) {
            this._cookies = cookies;
            this._length = cookies.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this._index < this._length;
        }

        @Override
        public String nextElement() {
            return this._cookies[this._index++].getName();
        }
    }
}

