/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

final class StringArrayPropertyTagRule
extends MetaRule {
    public static final MetaRule Instance = new StringArrayPropertyTagRule();
    private static final Class<? extends String[]> _STRING_ARRAY_TYPE = new String[0].getClass();

    StringArrayPropertyTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m;
        if (meta.getPropertyType(name) == _STRING_ARRAY_TYPE && attribute.isLiteral() && (m = meta.getWriteMethod(name)) != null) {
            return new LiteralPropertyMetadata(m, attribute);
        }
        return null;
    }

    private static String[] _coerceToStringArray(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str);
        while (tokens.hasMoreTokens()) {
            list.add(tokens.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private static class LiteralPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Object[] _params;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute) {
            this._method = method;
            this._attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (this._params == null) {
                String[] strArray = StringArrayPropertyTagRule._coerceToStringArray(this._attribute.getValue());
                this._params = new Object[]{strArray};
            }
            try {
                this._method.invoke(instance, this._params);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

