/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml.beans;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.xml.beans.BeanDef;
import org.apache.myfaces.trinidadinternal.share.xml.beans.IntrospectionPropertyDef;
import org.apache.myfaces.trinidadinternal.share.xml.beans.PropertyDef;
import org.apache.myfaces.trinidadinternal.util.JavaIntrospector;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionBeanDef
extends BeanDef {
    private final String _className;
    private final String _defaultProperty;
    private Class<?> _class;
    private Map<String, PropertyDef> _defs;

    public IntrospectionBeanDef(String className) {
        this(className, null);
    }

    public IntrospectionBeanDef(String className, String defaultProperty) {
        this._className = className;
        this._defaultProperty = defaultProperty;
    }

    @Override
    public PropertyDef getPropertyDef(String name) {
        Map<String, PropertyDef> defs = this._getPropertyDefs();
        if (defs != null) {
            return defs.get(name);
        }
        return null;
    }

    @Override
    public PropertyDef getPropertyDef(String namespace, String name) {
        if ("".equals(namespace)) {
            return this.getPropertyDef(name);
        }
        return null;
    }

    @Override
    public Object createBean(String namespaceURI, String localName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cls = this._getClass();
        return cls.newInstance();
    }

    @Override
    public Object finishBean(Object bean) {
        return bean;
    }

    @Override
    public PropertyDef getElementPropertyDef(String namespace, String name, Attributes attrs) {
        return this.getPropertyDef(namespace, name);
    }

    @Override
    public PropertyDef getDefaultPropertyDef() {
        if (this._defaultProperty == null) {
            return null;
        }
        return this.getPropertyDef(this._defaultProperty);
    }

    @Override
    public boolean isInlineChildProperty(String namespace, String name, PropertyDef def) {
        return false;
    }

    protected synchronized void loadProperties() {
        if (this._defs == null) {
            try {
                Class<?> objClass = this._getClass();
                BeanInfo info = JavaIntrospector.getBeanInfo(objClass);
                PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
                int length = descriptors != null ? descriptors.length : 0;
                HashMap<String, PropertyDef> defs = new HashMap<String, PropertyDef>(Math.max(length, 1));
                this._defs = defs;
                for (int i = 0; i < length; ++i) {
                    PropertyDescriptor property = descriptors[i];
                    String name = property.getName();
                    if (name == null || property.getWriteMethod() == null) continue;
                    this.addProperty(property);
                }
            }
            catch (Exception e) {
                this._defs = new HashMap<String, PropertyDef>(1);
            }
        }
    }

    protected void addProperty(PropertyDescriptor descriptor) {
        this._defs.put(descriptor.getName(), this.createPropertyDef(descriptor));
    }

    protected PropertyDef createPropertyDef(PropertyDescriptor descriptor) {
        return new IntrospectionPropertyDef(descriptor);
    }

    private Map<String, PropertyDef> _getPropertyDefs() {
        this.loadProperties();
        return this._defs;
    }

    private Class<?> _getClass() throws ClassNotFoundException {
        if (this._class == null) {
            this._class = ClassLoaderUtils.loadClass((String)this._className);
        }
        return this._class;
    }
}

