/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidadinternal.io.XMLEscapes;

public class XmlResponseWriter
extends ResponseWriter {
    private final Writer _out;
    private final String _encoding;
    private boolean _closeStart;
    private int _cdataCount;
    private final ArrayList<String> _elements = new ArrayList(20);

    public XmlResponseWriter(Writer writer, String encoding) {
        this._out = writer;
        this._encoding = encoding;
        this._cdataCount = 0;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public String getContentType() {
        return "text/xml";
    }

    public void startDocument() throws IOException {
        this._out.write("<?xml version=\"1.0\" ?>\n");
    }

    public void startCDATA() throws IOException {
        this.closeStartIfNecessary();
        ++this._cdataCount;
        if (this._cdataCount == 1) {
            this._out.write("<![CDATA[");
        }
    }

    public void endCDATA() throws IOException {
        if (this._cdataCount == 1) {
            this._out.write("]]>");
        }
        --this._cdataCount;
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.closeStartIfNecessary();
        Map passThroughAttributes = component != null ? component.getPassThroughAttributes(false) : null;
        name = this._processPassThroughAttributes(name, passThroughAttributes);
        this._pushElement(name);
        Writer out = this._out;
        out.write(60);
        out.write(name);
        this._closeStart = true;
        this._writePassThroughAttributes(passThroughAttributes);
    }

    private String _processPassThroughAttributes(String name, Map<String, Object> passThroughAttributes) {
        if (passThroughAttributes != null) {
            String elementName;
            Object value = passThroughAttributes.get("elementName");
            if (value instanceof ValueExpression) {
                value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            if (value != null && !name.equals(elementName = value.toString())) {
                name = elementName;
            }
        }
        return name;
    }

    private void _writePassThroughAttributes(Map<String, Object> passThroughAttributes) throws IOException {
        if (passThroughAttributes != null) {
            for (Map.Entry<String, Object> entry : passThroughAttributes.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if ("elementName".equals(key)) continue;
                if (value instanceof ValueExpression) {
                    value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
                }
                if (value == null) continue;
                this.writeAttribute(key, value, null);
            }
        }
    }

    public void writeAttribute(String name, Object value, String attrName) throws IOException {
        if (value == null) {
            return;
        }
        Writer out = this._out;
        out.write(32);
        out.write(name);
        out.write("=\"");
        XMLEscapes.writeAttribute(out, value.toString());
        out.write("\"");
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this.closeStartIfNecessary();
            Writer out = this._out;
            out.write("<!-- ");
            out.write(comment.toString());
            out.write(" -->");
        }
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        if (text != null) {
            this.closeStartIfNecessary();
            XMLEscapes.writeText(this._out, text, offset, length);
        }
    }

    public void writeText(Object text, String attrName) throws IOException {
        if (text != null) {
            this.closeStartIfNecessary();
            XMLEscapes.writeText(this._out, text.toString());
        }
    }

    public void writeURIAttribute(String name, Object value, String attrName) throws IOException {
        this.writeAttribute(name, value, attrName);
    }

    public void endElement(String name) throws IOException {
        name = this._popElement();
        Writer out = this._out;
        if (this._closeStart) {
            out.write("/>");
            this._closeStart = false;
        } else {
            out.write("</");
            out.write(name);
            out.write(">");
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new XmlResponseWriter(writer, this.getCharacterEncoding());
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(cbuf, off, len);
    }

    public void write(char[] cbuf) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(cbuf);
    }

    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(c);
    }

    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(str, off, len);
    }

    public void close() throws IOException {
        this._out.close();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    protected void closeStartIfNecessary() throws IOException {
        if (this._closeStart) {
            Writer out = this._out;
            out.write(62);
            this._closeStart = false;
        }
    }

    private String _popElement() {
        int size = this._elements.size();
        if (size == 0) {
            return null;
        }
        return this._elements.remove(size - 1);
    }

    private void _pushElement(String name) {
        this._elements.add(name);
    }
}

