/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import static org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils
        .addWindowContextIdHolderComponent;

import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import java.io.IOException;

/**
 * Adds
 * {@link WindowContextIdHolderComponent}
 * to the tree before the call of {@link #startDocument}
 */
public class InterceptedResponseWriter extends ResponseWriterWrapper
{
    private ResponseWriter wrapped;

    /**
     * Constructor for wrapping the given {@link ResponseWriter}
     * @param wrapped response-writer which should be wrapped
     */
    public InterceptedResponseWriter(ResponseWriter wrapped)
    {
        this.wrapped = wrapped;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void startDocument()
            throws IOException
    {
        addWindowContextIdHolderComponent();

        wrapped.startDocument();
    }

    /**
     * {@inheritDoc}
     */
    protected ResponseWriter getWrapped()
    {
        return this.wrapped;
    }
}
