/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.application;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletContext;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.annotation.PortletNamingContainer;
import javax.portlet.faces.component.PortletNamingContainerUIViewRoot;
import org.apache.myfaces.portlet.faces.util.QueryString;

public class PortletViewHandlerImpl
extends ViewHandlerWrapper {
    private ViewHandler mDelegate;
    private Bridge.BridgeRenderPolicy mRenderPolicy = null;

    public PortletViewHandlerImpl(ViewHandler handler) {
        this.mDelegate = handler;
    }

    protected ViewHandler getWrapped() {
        return this.mDelegate;
    }

    public String getActionURL(FacesContext context, String viewId) {
        int qsLoc;
        if (BridgeUtil.isPortletRequest()) {
            if (viewId.startsWith("/#")) {
                viewId = viewId.substring(1);
            }
            if (!viewId.startsWith("#") || (viewId = (String)context.getApplication().evaluateExpressionGet(context, viewId, String.class)) == null) {
                // empty if block
            }
        }
        if ((qsLoc = viewId.indexOf(63)) < 0) {
            qsLoc = viewId.length();
        }
        String actionURL = super.getActionURL(context, viewId.substring(0, qsLoc));
        if (qsLoc < viewId.length()) {
            int aLoc = actionURL.indexOf(63);
            if (aLoc < 0) {
                actionURL = actionURL.concat(viewId.substring(qsLoc));
            } else if (viewId.length() > qsLoc + 1) {
                actionURL = actionURL + "&" + viewId.substring(qsLoc + 1);
            }
        }
        return actionURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        if (BridgeUtil.isPortletRequest()) {
            if (viewId.startsWith("/#")) {
                viewId = viewId.substring(1);
            }
            if (!viewId.startsWith("#") || (viewId = (String)facesContext.getApplication().evaluateExpressionGet(facesContext, viewId, String.class)) == null) {
                // empty if block
            }
        }
        UIViewRoot viewRoot = null;
        int qsLoc = viewId.indexOf(63);
        if (qsLoc < 0) {
            qsLoc = viewId.length();
        }
        if ((viewRoot = super.createView(facesContext, viewId.substring(0, qsLoc))).getClass() == UIViewRoot.class && UIViewRoot.class.getAnnotation(PortletNamingContainer.class) == null) {
            String prior = this.setUIViewRootComponent(facesContext);
            try {
                viewRoot = super.createView(facesContext, viewId.substring(0, qsLoc));
            }
            finally {
                if (prior != null) {
                    this.resetUIViewRootComponent(facesContext, prior);
                }
            }
        }
        if (qsLoc < viewId.length()) {
            viewRoot.getAttributes().put("org.apache.myfaces.portlet.faces.viewIdQueryString", viewId.substring(qsLoc));
        }
        return viewRoot;
    }

    private String setUIViewRootComponent(FacesContext context) {
        Application app = context.getApplication();
        UIComponent root = app.createComponent("javax.faces.ViewRoot");
        if (root == null || root.getClass() == UIViewRoot.class && root.getClass().getAnnotation(PortletNamingContainer.class) == null) {
            app.addComponent("javax.faces.ViewRoot", PortletNamingContainerUIViewRoot.class.getName());
            return UIViewRoot.class.getName();
        }
        return null;
    }

    private void resetUIViewRootComponent(FacesContext context, String componentClassName) {
        if (componentClassName != null) {
            context.getApplication().addComponent("javax.faces.ViewRoot", componentClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        RenderResponse renderResponse;
        block21: {
            Object content;
            ExternalContext extContext;
            block20: {
                if (!BridgeUtil.isPortletRequest()) {
                    super.renderView(context, viewToRender);
                    return;
                }
                extContext = context.getExternalContext();
                renderResponse = (RenderResponse)extContext.getResponse();
                if (this.mRenderPolicy == null) {
                    PortletContext pCtx = (PortletContext)context.getExternalContext().getContext();
                    String policy = pCtx.getInitParameter("javax.portlet.faces.RENDER_POLICY");
                    this.mRenderPolicy = policy != null ? Bridge.BridgeRenderPolicy.valueOf((String)policy) : Bridge.BridgeRenderPolicy.DEFAULT;
                }
                if (this.mRenderPolicy == Bridge.BridgeRenderPolicy.ALWAYS_DELEGATE) {
                    super.renderView(context, viewToRender);
                    return;
                }
                if (this.mRenderPolicy == Bridge.BridgeRenderPolicy.DEFAULT) {
                    try {
                        super.renderView(context, viewToRender);
                        return;
                    }
                    catch (Throwable t) {
                        if (renderResponse.equals(extContext.getResponse())) break block20;
                        extContext.setResponse((Object)renderResponse);
                    }
                }
            }
            if (!viewToRender.isRendered()) {
                return;
            }
            try {
                extContext.getRequestMap().put("javax.portlet.faces.RenderContentAfterView", Boolean.TRUE);
                extContext.getRequestMap().remove("javax.servlet.include.servlet_path");
                extContext.dispatch(viewToRender.getViewId());
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            QueryString redirectParams = (QueryString)context.getExternalContext().getRequestMap().get("org.apache.myfaces.portlet.faces.redirectViewParams");
            if (redirectParams != null) {
                return;
            }
            RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderFactory.getRenderKit(context, viewToRender.getRenderKitId());
            ResponseWriter oldWriter = context.getResponseWriter();
            StringBuilderWriter strWriter = new StringBuilderWriter(context, 4096);
            ResponseWriter newWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)strWriter) : renderKit.createResponseWriter((Writer)strWriter, null, renderResponse.getCharacterEncoding());
            context.setResponseWriter(newWriter);
            newWriter.startDocument();
            this.doRenderView(context, viewToRender);
            newWriter.endDocument();
            redirectParams = (QueryString)context.getExternalContext().getRequestMap().get("org.apache.myfaces.portlet.faces.redirectViewParams");
            if (redirectParams != null) {
                return;
            }
            Writer renderResponseWriter = null;
            try {
                renderResponseWriter = renderResponse.getWriter();
            }
            catch (IllegalStateException ise) {
                renderResponseWriter = new BufferedWriter(new OutputStreamWriter(renderResponse.getPortletOutputStream(), renderResponse.getCharacterEncoding()));
            }
            ResponseWriter responseWriter = null != oldWriter ? oldWriter.cloneWithWriter(renderResponseWriter) : newWriter.cloneWithWriter(renderResponseWriter);
            context.setResponseWriter(responseWriter);
            strWriter.write((Writer)responseWriter);
            renderResponseWriter.flush();
            if (null != oldWriter) {
                context.setResponseWriter(oldWriter);
            }
            if ((content = extContext.getRequestMap().get("javax.portlet.faces.AfterViewContent")) != null) {
                try {
                    if (content instanceof char[]) {
                        renderResponse.getWriter().write(new String((char[])content));
                        break block21;
                    }
                    if (content instanceof byte[]) {
                        renderResponse.getWriter().write(new String((byte[])content));
                        break block21;
                    }
                    throw new IOException("PortletViewHandlerImpl: invalidAFTER_VIEW_CONTENT buffer type");
                }
                finally {
                    extContext.getRequestMap().remove("javax.portlet.faces.AfterViewContent");
                }
            }
        }
        renderResponse.flushBuffer();
    }

    private void doRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        viewToRender.encodeAll(context);
    }

    private static final class StringBuilderWriter
    extends Writer {
        private StringBuilder mBuilder;
        private FacesContext mContext;
        private static final String RI_SAVESTATE_FIELD_MARKER = "~com.sun.faces.saveStateFieldMarker~";
        private static final String MYFACES_SAVESTATE_FIELD_MARKER = "<!--@@JSF_FORM_STATE_MARKER@@-->";
        private static String sSaveStateFieldMarker = null;

        public StringBuilderWriter(FacesContext context, int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.mBuilder = new StringBuilder(initialCapacity);
            this.mContext = context;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.mBuilder.append(cbuf, off, len);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void write(String str) {
            this.mBuilder.append(str);
        }

        public void write(String str, int off, int len) {
            this.write(str.substring(off, off + len));
        }

        public StringBuilder getBuffer() {
            return this.mBuilder;
        }

        public String toString() {
            return this.mBuilder.toString();
        }

        public void write(Writer writer) throws IOException {
            if (sSaveStateFieldMarker == null) {
                sSaveStateFieldMarker = this.determineSaveStateFieldMarker();
            }
            int pos = 0;
            StateManager stateManager = this.mContext.getApplication().getStateManager();
            Object stateToWrite = stateManager.saveView(this.mContext);
            if (sSaveStateFieldMarker != null) {
                int markLen = sSaveStateFieldMarker.length();
                int tildeIdx = this.mBuilder.indexOf(sSaveStateFieldMarker);
                while (tildeIdx > 0) {
                    writer.write(this.mBuilder.substring(pos, tildeIdx));
                    stateManager.writeState(this.mContext, stateToWrite);
                    pos = tildeIdx + markLen;
                    tildeIdx = this.mBuilder.indexOf(sSaveStateFieldMarker, pos);
                }
            }
            writer.write(this.mBuilder.substring(pos));
        }

        private String determineSaveStateFieldMarker() throws IOException {
            String marker = ((PortletContext)FacesContext.getCurrentInstance().getExternalContext().getContext()).getInitParameter("javax.portlet.faces.SAVESTATE_FIELD_MARKER");
            if (this.isMarker(marker)) {
                return marker;
            }
            if (this.isMarker(RI_SAVESTATE_FIELD_MARKER)) {
                return RI_SAVESTATE_FIELD_MARKER;
            }
            if (this.isMarker(MYFACES_SAVESTATE_FIELD_MARKER)) {
                return MYFACES_SAVESTATE_FIELD_MARKER;
            }
            this.mContext.getExternalContext().log("Unable to locate a SAVESTATE_FIELD_MARKER in response.  This could be because your Faces environment doesn't write such a marker or because the bridge doesn't know the marker in use.  If the later, configure the appropriate application init parameter javax.portlet.faces.SAVESTATE_FIELD_MARKER.");
            return null;
        }

        private boolean isMarker(String marker) {
            return marker != null && this.mBuilder.indexOf(marker) >= 0;
        }
    }
}

