/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.controller.status.StorageStatus;

public class NodeStatus
implements Cloneable {
    private long createdAtInMs;
    private long freeHeap;
    private long usedHeap;
    private long heapUtilization;
    private long freeNonHeap;
    private long usedNonHeap;
    private long openFileHandlers;
    private double processorLoadAverage;
    private long totalThreads;
    private long eventDrivenThreads;
    private long timerDrivenThreads;
    private long flowFileRepositoryFreeSpace;
    private long flowFileRepositoryUsedSpace;
    private List<StorageStatus> contentRepositories = new ArrayList<StorageStatus>();
    private List<StorageStatus> provenanceRepositories = new ArrayList<StorageStatus>();

    public long getCreatedAtInMs() {
        return this.createdAtInMs;
    }

    public void setCreatedAtInMs(long createdAtInMs) {
        this.createdAtInMs = createdAtInMs;
    }

    public long getFreeHeap() {
        return this.freeHeap;
    }

    public void setFreeHeap(long freeHeap) {
        this.freeHeap = freeHeap;
    }

    public long getUsedHeap() {
        return this.usedHeap;
    }

    public void setUsedHeap(long usedHeap) {
        this.usedHeap = usedHeap;
    }

    public long getHeapUtilization() {
        return this.heapUtilization;
    }

    public void setHeapUtilization(long heapUtilization) {
        this.heapUtilization = heapUtilization;
    }

    public long getFreeNonHeap() {
        return this.freeNonHeap;
    }

    public void setFreeNonHeap(long freeNonHeap) {
        this.freeNonHeap = freeNonHeap;
    }

    public long getUsedNonHeap() {
        return this.usedNonHeap;
    }

    public void setUsedNonHeap(long usedNonHeap) {
        this.usedNonHeap = usedNonHeap;
    }

    public long getOpenFileHandlers() {
        return this.openFileHandlers;
    }

    public void setOpenFileHandlers(long openFileHandlers) {
        this.openFileHandlers = openFileHandlers;
    }

    public double getProcessorLoadAverage() {
        return this.processorLoadAverage;
    }

    public void setProcessorLoadAverage(double processorLoadAverage) {
        this.processorLoadAverage = processorLoadAverage;
    }

    public long getTotalThreads() {
        return this.totalThreads;
    }

    public void setTotalThreads(long totalThreads) {
        this.totalThreads = totalThreads;
    }

    public long getEventDrivenThreads() {
        return this.eventDrivenThreads;
    }

    public void setEventDrivenThreads(long eventDrivenThreads) {
        this.eventDrivenThreads = eventDrivenThreads;
    }

    public long getTimerDrivenThreads() {
        return this.timerDrivenThreads;
    }

    public void setTimerDrivenThreads(long timerDrivenThreads) {
        this.timerDrivenThreads = timerDrivenThreads;
    }

    public long getFlowFileRepositoryFreeSpace() {
        return this.flowFileRepositoryFreeSpace;
    }

    public void setFlowFileRepositoryFreeSpace(long flowFileRepositoryFreeSpace) {
        this.flowFileRepositoryFreeSpace = flowFileRepositoryFreeSpace;
    }

    public long getFlowFileRepositoryUsedSpace() {
        return this.flowFileRepositoryUsedSpace;
    }

    public void setFlowFileRepositoryUsedSpace(long flowFileRepositoryUsedSpace) {
        this.flowFileRepositoryUsedSpace = flowFileRepositoryUsedSpace;
    }

    public List<StorageStatus> getContentRepositories() {
        return this.contentRepositories;
    }

    public void setContentRepositories(List<StorageStatus> contentRepositories) {
        this.contentRepositories = new ArrayList<StorageStatus>();
        this.contentRepositories.addAll(contentRepositories);
    }

    public List<StorageStatus> getProvenanceRepositories() {
        return this.provenanceRepositories;
    }

    public void setProvenanceRepositories(List<StorageStatus> provenanceRepositories) {
        this.provenanceRepositories = new ArrayList<StorageStatus>();
        this.provenanceRepositories.addAll(provenanceRepositories);
    }

    protected NodeStatus clone() {
        NodeStatus clonedObj = new NodeStatus();
        clonedObj.createdAtInMs = this.createdAtInMs;
        clonedObj.freeHeap = this.freeHeap;
        clonedObj.usedHeap = this.usedHeap;
        clonedObj.heapUtilization = this.heapUtilization;
        clonedObj.freeNonHeap = this.freeNonHeap;
        clonedObj.usedNonHeap = this.usedNonHeap;
        clonedObj.openFileHandlers = this.openFileHandlers;
        clonedObj.processorLoadAverage = this.processorLoadAverage;
        clonedObj.totalThreads = this.totalThreads;
        clonedObj.eventDrivenThreads = this.eventDrivenThreads;
        clonedObj.timerDrivenThreads = this.timerDrivenThreads;
        clonedObj.flowFileRepositoryFreeSpace = this.flowFileRepositoryFreeSpace;
        clonedObj.flowFileRepositoryUsedSpace = this.flowFileRepositoryUsedSpace;
        ArrayList<StorageStatus> clonedContentRepositories = new ArrayList<StorageStatus>();
        this.contentRepositories.stream().map(r -> r.clone()).forEach(r -> clonedContentRepositories.add((StorageStatus)r));
        clonedObj.contentRepositories = clonedContentRepositories;
        ArrayList<StorageStatus> clonedProvenanceRepositories = new ArrayList<StorageStatus>();
        this.provenanceRepositories.stream().map(r -> r.clone()).forEach(r -> clonedProvenanceRepositories.add((StorageStatus)r));
        clonedObj.provenanceRepositories = clonedProvenanceRepositories;
        return clonedObj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NodeStatus{");
        sb.append("createdAtInMs=").append(this.createdAtInMs);
        sb.append(", freeHeap=").append(this.freeHeap);
        sb.append(", usedHeap=").append(this.usedHeap);
        sb.append(", heapUtilization=").append(this.heapUtilization);
        sb.append(", freeNonHeap=").append(this.freeNonHeap);
        sb.append(", usedNonHeap=").append(this.usedNonHeap);
        sb.append(", openFileHandlers=").append(this.openFileHandlers);
        sb.append(", processorLoadAverage=").append(this.processorLoadAverage);
        sb.append(", totalThreads=").append(this.totalThreads);
        sb.append(", eventDrivenThreads=").append(this.eventDrivenThreads);
        sb.append(", timerDrivenThreads=").append(this.timerDrivenThreads);
        sb.append(", flowFileRepositoryFreeSpace=").append(this.flowFileRepositoryFreeSpace);
        sb.append(", flowFileRepositoryUsedSpace=").append(this.flowFileRepositoryUsedSpace);
        sb.append(", contentRepositories=").append(this.contentRepositories);
        sb.append(", provenanceRepositories=").append(this.provenanceRepositories);
        sb.append('}');
        return sb.toString();
    }
}

