/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage;

import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.history.storage.BufferedEntryWriter;
import org.apache.nifi.controller.status.history.storage.StatusStorage;

public class BufferedWriterForStatusStorage<T>
implements BufferedEntryWriter<Pair<Instant, T>> {
    private final BlockingQueue<Pair<Instant, T>> queue = new LinkedBlockingQueue<Pair<Instant, T>>();
    private final StatusStorage<T> statusStorage;
    private final int batchSize;

    public BufferedWriterForStatusStorage(StatusStorage<T> statusStorage, int batchSize) {
        this.statusStorage = statusStorage;
        this.batchSize = batchSize;
    }

    @Override
    public void collect(Pair<Instant, T> entryToStore) {
        this.queue.add(entryToStore);
    }

    @Override
    public void flush() {
        ArrayList entries = new ArrayList(this.batchSize);
        this.queue.drainTo(entries, this.batchSize);
        if (!entries.isEmpty()) {
            this.statusStorage.store(entries);
        }
    }
}

