/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.util.Objects;
import org.apache.nifi.bundle.Bundle;

public class ExtensionDefinition {
    private final String implementationClassName;
    private final Bundle bundle;
    private final Class<?> extensionType;

    public ExtensionDefinition(String implementationClassName, Bundle bundle, Class<?> extensionType) {
        this.implementationClassName = implementationClassName;
        this.bundle = bundle;
        this.extensionType = extensionType;
    }

    public String getImplementationClassName() {
        return this.implementationClassName;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Class<?> getExtensionType() {
        return this.extensionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionDefinition that = (ExtensionDefinition)o;
        return Objects.equals(this.implementationClassName, that.implementationClassName) && Objects.equals(this.bundle, that.bundle) && Objects.equals(this.extensionType, that.extensionType);
    }

    public int hashCode() {
        return Objects.hash(this.implementationClassName, this.bundle, this.extensionType);
    }

    public String toString() {
        return "ExtensionDefinition[type=" + this.extensionType.getSimpleName() + ", implementation=" + this.implementationClassName + ", bundle=" + this.bundle + "]";
    }
}

