/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.UuidFunction;

public class FirstUuidGroupByFunction
extends UuidFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public FirstUuidGroupByFunction(Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putLong128(this.valueIndex, this.arg.getLong128Lo(record), this.arg.getLong128Hi(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getLong128Hi(Record rec) {
        return rec.getLong128Hi(this.valueIndex);
    }

    @Override
    public long getLong128Lo(Record rec) {
        return rec.getLong128Lo(this.valueIndex);
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(19);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong128(this.valueIndex, Long.MIN_VALUE, Long.MIN_VALUE);
    }
}

