/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.network.SuspendEvent;
import io.questdb.std.ThreadLocal;

public class QueryPausedException
extends Exception {
    private static final ThreadLocal<QueryPausedException> tlException = new ThreadLocal<QueryPausedException>(QueryPausedException::new);
    private SuspendEvent event;

    public static QueryPausedException instance(SuspendEvent event, SqlExecutionCircuitBreaker circuitBreaker) {
        long timeout;
        QueryPausedException ex = tlException.get();
        SqlExecutionCircuitBreakerConfiguration circuitBreakerConfiguration = circuitBreaker.getConfiguration();
        if (circuitBreakerConfiguration != null && (timeout = circuitBreakerConfiguration.getTimeout()) != Long.MAX_VALUE) {
            long deadline = circuitBreakerConfiguration.getClock().getTicks() + timeout;
            event.setDeadline(deadline);
        }
        ex.event = event;
        return ex;
    }

    public SuspendEvent getEvent() {
        return this.event;
    }
}

