/*
 * Decompiled with CFR 0.152.
 */
package v21.h2.expression.function;

import v21.h2.engine.SessionLocal;
import v21.h2.expression.Expression;
import v21.h2.expression.TypedValueExpression;
import v21.h2.expression.function.Function1;
import v21.h2.message.DbException;
import v21.h2.util.MathUtils;
import v21.h2.value.TypeInfo;
import v21.h2.value.Value;
import v21.h2.value.ValueArray;
import v21.h2.value.ValueInteger;
import v21.h2.value.ValueNull;

public final class CardinalityExpression
extends Function1 {
    private final boolean max;

    public CardinalityExpression(Expression expression, boolean bl) {
        super(expression);
        this.max = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value getValue(SessionLocal sessionLocal) {
        int n;
        if (this.max) {
            TypeInfo typeInfo = this.arg.getType();
            if (typeInfo.getValueType() != 40) throw DbException.getInvalidValueException("array", this.arg.getValue(sessionLocal).getTraceSQL());
            n = MathUtils.convertLongToInt(typeInfo.getPrecision());
            return ValueInteger.get(n);
        } else {
            Value value = this.arg.getValue(sessionLocal);
            if (value == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            if (value.getValueType() != 40) {
                throw DbException.getInvalidValueException("array", value.getTraceSQL());
            }
            n = ((ValueArray)value).getList().length;
        }
        return ValueInteger.get(n);
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.arg = this.arg.optimize(sessionLocal);
        this.type = TypeInfo.TYPE_INTEGER;
        if (this.arg.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(sessionLocal), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return this.max ? "ARRAY_MAX_CARDINALITY" : "CARDINALITY";
    }
}

