/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;

public class ClusterDiagnosticTask
implements DiagnosticTask {
    private final FlowController flowController;

    public ClusterDiagnosticTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        if (!this.flowController.isClustered()) {
            details.add("This instance is not clustered");
            return new StandardDiagnosticsDumpElement("Cluster Details", details);
        }
        ClusterCoordinator clusterCoordinator = this.flowController.getClusterCoordinator();
        for (NodeConnectionStatus status : clusterCoordinator.getConnectionStatuses()) {
            StringBuilder sb = new StringBuilder();
            NodeIdentifier nodeId = status.getNodeIdentifier();
            sb.append(nodeId.getFullDescription());
            NodeConnectionState state = status.getState();
            sb.append("; State = ").append(state);
            if (state == NodeConnectionState.OFFLOADED || state == NodeConnectionState.OFFLOADING) {
                sb.append("; Offload Code = ").append(status.getOffloadCode()).append("; Reason = ").append(status.getReason());
            } else if (state == NodeConnectionState.DISCONNECTED || state == NodeConnectionState.DISCONNECTING) {
                sb.append("; Disconnection Code = ").append(status.getDisconnectCode()).append("; Reason = ").append(status.getReason());
            }
            details.add(sb.toString());
        }
        details.add("Primary Node : " + clusterCoordinator.getPrimaryNode());
        details.add("Coordinator Node : " + clusterCoordinator.getElectedActiveCoordinatorNode());
        details.add("Local Node : " + clusterCoordinator.getLocalNodeIdentifier());
        LeaderElectionManager leaderElectionManager = this.flowController.getLeaderElectionManager();
        if (leaderElectionManager != null) {
            Map<String, Integer> changeCounts = leaderElectionManager.getLeadershipChangeCount(24L, TimeUnit.HOURS);
            changeCounts.forEach((role, count) -> details.add("Leadership for Role <" + role + "> has changed " + count + " times in the last 24 hours."));
            details.add("In the past 5 minutes, the Leader Election service has been polled " + leaderElectionManager.getPollCount() + " times");
            details.add("In the past 5 minutes, the minimum time taken to communicate with the Leader Election service has been " + leaderElectionManager.getMinPollTime(TimeUnit.MILLISECONDS) + " millis");
            details.add("In the past 5 minutes, the maximum time taken to communicate with the Leader Election service has been " + leaderElectionManager.getMaxPollTime(TimeUnit.MILLISECONDS) + " millis");
            details.add("In the past 5 minutes, the average time taken to communicate with the Leader Election service has been " + leaderElectionManager.getAveragePollTime(TimeUnit.MILLISECONDS) + " millis");
        }
        return new StandardDiagnosticsDumpElement("Cluster Details", details);
    }
}

