/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption.configuration.kms;

import org.apache.nifi.security.kms.FileBasedKeyProvider;
import org.apache.nifi.security.kms.KeyStoreKeyProvider;
import org.apache.nifi.security.kms.StaticKeyProvider;

public enum EncryptionKeyProvider {
    FILE_PROPERTIES,
    KEYSTORE,
    NIFI_PROPERTIES;


    public static EncryptionKeyProvider fromImplementationClass(String implementationClass) {
        EncryptionKeyProvider encryptionKeyProvider;
        if (implementationClass.endsWith(FileBasedKeyProvider.class.getSimpleName())) {
            encryptionKeyProvider = FILE_PROPERTIES;
        } else if (implementationClass.endsWith(KeyStoreKeyProvider.class.getSimpleName())) {
            encryptionKeyProvider = KEYSTORE;
        } else if (implementationClass.endsWith(StaticKeyProvider.class.getSimpleName())) {
            encryptionKeyProvider = NIFI_PROPERTIES;
        } else {
            String message = String.format("Key Provider Class [%s] not supported", implementationClass);
            throw new IllegalArgumentException(message);
        }
        return encryptionKeyProvider;
    }
}

