/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.ColumnType;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonParser;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.griffin.SqlKeywords;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.str.AbstractCharSequence;
import java.io.Closeable;

public class TextMetadataParser
implements JsonParser,
Mutable,
Closeable {
    private static final Log LOG = LogFactory.getLog(TextMetadataParser.class);
    private static final int P_INDEX = 6;
    private static final int P_LOCALE = 4;
    private static final int P_NAME = 1;
    private static final int P_PATTERN = 3;
    private static final int P_TYPE = 2;
    private static final int P_UTF8 = 5;
    private static final int S_NEED_ARRAY = 1;
    private static final int S_NEED_OBJECT = 2;
    private static final int S_NEED_PROPERTY = 3;
    private static final CharSequenceIntHashMap propertyNameMap = new CharSequenceIntHashMap();
    private final ObjList<CharSequence> columnNames = new ObjList();
    private final ObjList<TypeAdapter> columnTypes = new ObjList();
    private final ObjectPool<FloatingCharSequence> csPool;
    private final DateFormatFactory dateFormatFactory;
    private final DateLocale dateLocale;
    private final DateLocaleFactory dateLocaleFactory;
    private final TimestampFormatFactory timestampFormatFactory;
    private final TypeManager typeManager;
    private long buf;
    private long bufCapacity = 0L;
    private int bufSize = 0;
    private boolean index = false;
    private CharSequence locale;
    private int localePosition;
    private CharSequence name;
    private CharSequence pattern;
    private int propertyIndex;
    private int state = 1;
    private CharSequence tableName;
    private int type = -1;
    private boolean utf8 = false;

    public TextMetadataParser(TextConfiguration textConfiguration, TypeManager typeManager) {
        this.csPool = new ObjectPool<FloatingCharSequence>(() -> new FloatingCharSequence(), textConfiguration.getMetadataStringPoolCapacity());
        this.dateLocaleFactory = typeManager.getInputFormatConfiguration().getDateLocaleFactory();
        this.dateFormatFactory = typeManager.getInputFormatConfiguration().getDateFormatFactory();
        this.timestampFormatFactory = typeManager.getInputFormatConfiguration().getTimestampFormatFactory();
        this.typeManager = typeManager;
        this.dateLocale = textConfiguration.getDefaultDateLocale();
    }

    @Override
    public void clear() {
        this.bufSize = 0;
        this.state = 1;
        this.columnNames.clear();
        this.columnTypes.clear();
        this.csPool.clear();
        this.clearStage();
    }

    @Override
    public void close() {
        this.clear();
        if (this.bufCapacity > 0L) {
            Unsafe.free(this.buf, this.bufCapacity, 48);
            this.bufCapacity = 0L;
        }
    }

    public ObjList<CharSequence> getColumnNames() {
        return this.columnNames;
    }

    public ObjList<TypeAdapter> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public void onEvent(int code, CharSequence tag, int position) throws JsonException {
        block0 : switch (code) {
            case 3: {
                if (this.state != 1) {
                    throw JsonException.$(position, "Unexpected array");
                }
                this.state = 2;
                break;
            }
            case 1: {
                if (this.state != 2) {
                    throw JsonException.$(position, "Unexpected object");
                }
                this.state = 3;
                break;
            }
            case 5: {
                this.propertyIndex = propertyNameMap.get(tag);
                if (this.propertyIndex != -1) break;
                LOG.info().$("unknown [table=").$(this.tableName).$(", tag=").$(tag).$(']').$();
                break;
            }
            case 6: {
                switch (this.propertyIndex) {
                    case 1: {
                        this.name = this.copy(tag);
                        break block0;
                    }
                    case 2: {
                        this.type = ColumnType.typeOf(tag);
                        if (this.type != -1) break block0;
                        throw JsonException.$(position, "Invalid type");
                    }
                    case 3: {
                        this.pattern = this.copy(tag);
                        break block0;
                    }
                    case 4: {
                        this.locale = this.copy(tag);
                        this.localePosition = position;
                        break block0;
                    }
                    case 5: {
                        this.utf8 = SqlKeywords.isTrueKeyword(tag);
                        break block0;
                    }
                    case 6: {
                        this.index = SqlKeywords.isTrueKeyword(tag);
                        break block0;
                    }
                }
                LOG.info().$("ignoring [table=").$(this.tableName).$(", value=").$(tag).$(']').$();
                break;
            }
            case 2: {
                this.state = 2;
                this.createImportedType(position);
                break;
            }
            case 7: {
                throw JsonException.$(position, "Must be an object");
            }
        }
    }

    private static void checkInputs(int position, CharSequence name, int type) throws JsonException {
        if (name == null) {
            throw JsonException.$(position, "Missing 'name' property");
        }
        if (type == -1) {
            throw JsonException.$(position, "Missing 'type' property");
        }
    }

    private static void strcpyw(CharSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(address + ((long)i << 1), value.charAt(i));
        }
    }

    private void clearStage() {
        this.name = null;
        this.type = -1;
        this.pattern = null;
        this.locale = null;
        this.localePosition = 0;
        this.utf8 = false;
        this.index = false;
    }

    private CharSequence copy(CharSequence tag) {
        int l = tag.length() * 2;
        long n = this.bufSize + l;
        if (n > this.bufCapacity) {
            long ptr = Unsafe.malloc(n * 2L, 48);
            Vect.memcpy(ptr, this.buf, this.bufSize);
            if (this.bufCapacity > 0L) {
                Unsafe.free(this.buf, this.bufCapacity, 48);
            }
            this.buf = ptr;
            this.bufCapacity = n * 2L;
        }
        TextMetadataParser.strcpyw(tag, l / 2, this.buf + (long)this.bufSize);
        CharSequence cs = this.csPool.next().of(this.bufSize, l / 2);
        this.bufSize += l;
        return cs;
    }

    private void createImportedType(int position) throws JsonException {
        TextMetadataParser.checkInputs(position, this.name, this.type);
        this.columnNames.add(this.name);
        switch (ColumnType.tagOf(this.type)) {
            case 7: {
                DateLocale dateLocale;
                DateLocale dateLocale2 = dateLocale = this.locale == null ? this.dateLocale : this.dateLocaleFactory.getLocale(this.locale);
                if (dateLocale == null) {
                    throw JsonException.$(this.localePosition, "Invalid date locale");
                }
                if (this.pattern == null) {
                    throw JsonException.$(0, "DATE format pattern is required");
                }
                this.columnTypes.add(this.typeManager.nextDateAdapter().of(this.dateFormatFactory.get(this.pattern), dateLocale));
                break;
            }
            case 8: {
                DateLocale timestampLocale;
                DateLocale dateLocale = timestampLocale = this.locale == null ? this.dateLocale : this.dateLocaleFactory.getLocale(this.locale);
                if (timestampLocale == null) {
                    throw JsonException.$(this.localePosition, "Invalid timestamp locale");
                }
                if (this.pattern == null) {
                    throw JsonException.$(0, "TIMESTAMP format pattern is required");
                }
                this.columnTypes.add(this.typeManager.nextTimestampAdapter(this.utf8, this.timestampFormatFactory.get(this.pattern), timestampLocale));
                break;
            }
            case 12: {
                this.columnTypes.add(this.typeManager.nextSymbolAdapter(this.index));
                break;
            }
            default: {
                this.columnTypes.add(this.typeManager.getTypeAdapter(this.type));
            }
        }
        this.clearStage();
    }

    void setTableName(CharSequence tableName) {
        this.tableName = tableName;
    }

    static {
        propertyNameMap.put("name", 1);
        propertyNameMap.put("type", 2);
        propertyNameMap.put("pattern", 3);
        propertyNameMap.put("locale", 4);
        propertyNameMap.put("utf8", 5);
        propertyNameMap.put("index", 6);
    }

    private class FloatingCharSequence
    extends AbstractCharSequence
    implements Mutable {
        private int len;
        private int offset;

        private FloatingCharSequence() {
        }

        @Override
        public char charAt(int index) {
            return Unsafe.getUnsafe().getChar(TextMetadataParser.this.buf + (long)this.offset + (long)index * 2L);
        }

        @Override
        public void clear() {
        }

        @Override
        public int length() {
            return this.len;
        }

        CharSequence of(int lo, int len) {
            this.offset = lo;
            this.len = len;
            return this;
        }
    }
}

