/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class NullIfIFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(Ii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new NullIfIFunction(args.getQuick(0), args.getQuick(1).getInt(null));
    }

    private static class NullIfIFunction
    extends IntFunction
    implements UnaryFunction {
        private final int replacement;
        private final Function value;

        public NullIfIFunction(Function value, int replacement) {
            this.value = value;
            this.replacement = replacement;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public int getInt(Record rec) {
            int val = this.value.getInt(rec);
            return val == this.replacement ? Integer.MIN_VALUE : val;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("nullif(").val(this.value).val(',').val(this.replacement).val(')');
        }
    }
}

