/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.AbstractExtensionBundleMetadata;

public class NiFiRegistryExtensionBundleMetadata
extends AbstractExtensionBundleMetadata {
    private static final String SEPARATOR = "::";
    private static final String LOCATION_FORMAT = String.join((CharSequence)"::", "%s", "%s", "%s", "%s.nar");
    private final String bundleIdentifier;

    private NiFiRegistryExtensionBundleMetadata(Builder builder) {
        super(builder.registryIdentifier, builder.group, builder.artifact, builder.version, builder.timestamp);
        this.bundleIdentifier = (String)Validate.notBlank((CharSequence)builder.bundleIdentifier);
    }

    public String getBundleIdentifier() {
        return this.bundleIdentifier;
    }

    public String toLocationString() {
        return String.format(LOCATION_FORMAT, this.getGroup(), this.getArtifact(), this.getVersion(), this.getBundleIdentifier());
    }

    public static Builder fromLocationString(String location) {
        if (StringUtils.isBlank((CharSequence)location)) {
            throw new IllegalArgumentException("Location is null or blank");
        }
        String[] locationParts = location.split(SEPARATOR);
        if (locationParts.length != 4) {
            throw new IllegalArgumentException("Invalid location: " + location);
        }
        return new Builder().group(locationParts[0]).artifact(locationParts[1]).version(locationParts[2]).bundleIdentifier(locationParts[3].replace(".nar", ""));
    }

    public static class Builder {
        private String registryIdentifier;
        private String group;
        private String artifact;
        private String version;
        private String bundleIdentifier;
        private long timestamp;

        public Builder registryIdentifier(String registryIdentifier) {
            this.registryIdentifier = registryIdentifier;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder artifact(String artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder bundleIdentifier(String bundleIdentifier) {
            this.bundleIdentifier = bundleIdentifier;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public NiFiRegistryExtensionBundleMetadata build() {
            return new NiFiRegistryExtensionBundleMetadata(this);
        }
    }
}

