/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached.iterator;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIdArrayIteratorMultiTypeIdPacked
extends NonDisposableEntityIterator {
    private final int[] typeIds;
    private final long[] localIds;
    private int index = 0;
    private int typeId = -1;
    private int typeIndex = 0;
    private int currentBound = 0;

    public EntityIdArrayIteratorMultiTypeIdPacked(@NotNull EntityIterableBase iterable2, int[] typeIds, long[] localIds) {
        super(iterable2);
        this.typeIds = typeIds;
        this.localIds = localIds;
    }

    @Override
    public boolean skip(int number) {
        int index2;
        this.index = index2 = this.index + number;
        if (this.hasNextImpl()) {
            while (index2 > this.currentBound) {
                this.typeId = this.typeIds[this.typeIndex];
                ++this.typeIndex;
                this.currentBound = this.typeIds[this.typeIndex];
                ++this.typeIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public EntityId nextId() {
        int index2;
        if ((index2 = this.index++) >= this.currentBound) {
            this.typeId = this.typeIds[this.typeIndex];
            ++this.typeIndex;
            this.currentBound = this.typeIds[this.typeIndex];
            ++this.typeIndex;
        }
        return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, this.localIds[index2]);
    }

    @Override
    @Nullable
    public EntityId getLast() {
        int typeId;
        int count = this.localIds.length;
        if (count == 0 || (typeId = this.typeIds[this.typeIds.length - 2]) == Integer.MIN_VALUE) {
            return null;
        }
        return new PersistentEntityId(typeId, this.localIds[count - 1]);
    }

    @Override
    @Nullable
    public EntityId nextIdImpl() {
        int index2;
        if ((index2 = this.index++) >= this.currentBound) {
            this.typeId = this.typeIds[this.typeIndex];
            ++this.typeIndex;
            this.currentBound = this.typeIds[this.typeIndex];
            ++this.typeIndex;
        }
        return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, this.localIds[index2]);
    }

    @Override
    protected boolean hasNextImpl() {
        return this.index < this.localIds.length;
    }

    @Override
    protected int getIndex() {
        return this.index;
    }
}

