/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.processing.stream;

import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.XMLStreamReaderProvider;

public class StandardXMLStreamReaderProvider
implements XMLStreamReaderProvider {
    @Override
    public XMLStreamReader getStreamReader(StreamSource streamSource) {
        Objects.requireNonNull(streamSource, "StreamSource required");
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            return inputFactory.createXMLStreamReader(streamSource);
        }
        catch (XMLStreamException e) {
            throw new ProcessingException("Reader creation failed", e);
        }
    }
}

