/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.diagnostics;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name="repositoryUsage")
public class RepositoryUsageDTO
implements Cloneable {
    private String name;
    private String fileStoreHash;
    private String freeSpace;
    private String totalSpace;
    private Long freeSpaceBytes;
    private Long totalSpaceBytes;
    private String utilization;

    @Schema(description="The name of the repository")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="A SHA-256 hash of the File Store name/path that is used to store the repository's data. This information is exposed as a hash in order to avoid exposing potentially sensitive information that is not generally relevant. What is typically relevant is whether or not multiple repositories on the same node are using the same File Store, as this indicates that the repositories are competing for the resources of the backing disk/storage mechanism.")
    public String getFileStoreHash() {
        return this.fileStoreHash;
    }

    public void setFileStoreHash(String fileStore) {
        this.fileStoreHash = fileStore;
    }

    @Schema(description="Amount of free space.")
    public String getFreeSpace() {
        return this.freeSpace;
    }

    public void setFreeSpace(String freeSpace) {
        this.freeSpace = freeSpace;
    }

    @Schema(description="Amount of total space.")
    public String getTotalSpace() {
        return this.totalSpace;
    }

    public void setTotalSpace(String totalSpace) {
        this.totalSpace = totalSpace;
    }

    @Schema(description="Utilization of this storage location.")
    public String getUtilization() {
        return this.utilization;
    }

    public void setUtilization(String utilization) {
        this.utilization = utilization;
    }

    @Schema(description="The number of bytes of free space.")
    public Long getFreeSpaceBytes() {
        return this.freeSpaceBytes;
    }

    public void setFreeSpaceBytes(Long freeSpaceBytes) {
        this.freeSpaceBytes = freeSpaceBytes;
    }

    @Schema(description="The number of bytes of total space.")
    public Long getTotalSpaceBytes() {
        return this.totalSpaceBytes;
    }

    public void setTotalSpaceBytes(Long totalSpaceBytes) {
        this.totalSpaceBytes = totalSpaceBytes;
    }

    public RepositoryUsageDTO clone() {
        RepositoryUsageDTO clone = new RepositoryUsageDTO();
        clone.fileStoreHash = this.fileStoreHash;
        clone.freeSpace = this.freeSpace;
        clone.freeSpaceBytes = this.freeSpaceBytes;
        clone.name = this.name;
        clone.totalSpace = this.totalSpace;
        clone.totalSpaceBytes = this.totalSpaceBytes;
        clone.utilization = this.utilization;
        return clone;
    }
}

