/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.cs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiActivateCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceRunStatusEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class DisableControllerServices
extends AbstractNiFiActivateCommand<ControllerServiceEntity, ControllerServiceRunStatusEntity> {
    public DisableControllerServices() {
        super("disable-services");
    }

    @Override
    public String getDescription() {
        return "Disables all controller services for reporting tasks. Any services that are in use by a running reporting task will fail to be disabled and will need to be stopped first using stop-reporting-tasks. In stand-alone mode this command will not produce all of the output seen in interactive mode unless the --verbose argument is specified.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.CS_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String csId = this.getArg(properties, CommandOption.CS_ID);
        HashSet<ControllerServiceEntity> serviceEntities = new HashSet<ControllerServiceEntity>();
        if (StringUtils.isBlank((CharSequence)csId)) {
            ControllerServicesEntity servicesEntity = client.getFlowClient().getControllerServices();
            serviceEntities.addAll(servicesEntity.getControllerServices());
        } else {
            serviceEntities.add(client.getControllerServicesClient().getControllerService(csId));
        }
        this.activate(client, properties, serviceEntities, "DISABLED");
        return VoidResult.getInstance();
    }

    @Override
    public ControllerServiceRunStatusEntity getRunStatusEntity() {
        return new ControllerServiceRunStatusEntity();
    }

    @Override
    public ControllerServiceEntity activateComponent(NiFiClient client, ControllerServiceEntity serviceEntity, ControllerServiceRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        return client.getControllerServicesClient().activateControllerService(serviceEntity.getId(), runStatusEntity);
    }

    @Override
    public String getDispName(ControllerServiceEntity serviceEntity) {
        return "Controller service \"" + serviceEntity.getComponent().getName() + "\" (id: " + serviceEntity.getId() + ")";
    }
}

