/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.BundleVersionResult;

public class UploadBundle
extends AbstractNiFiRegistryCommand<BundleVersionResult> {
    public UploadBundle() {
        super("upload-bundle", BundleVersionResult.class);
    }

    @Override
    public String getDescription() {
        return "Uploads an extension bundle binary to the specified bucket in the registry.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_TYPE.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_FILE.createOption());
        this.addOption(CommandOption.SKIP_SHA_256.createOption());
    }

    @Override
    public BundleVersionResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        BundleType bundleType;
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        try {
            bundleType = BundleType.fromString((String)this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_TYPE));
        }
        catch (Exception e) {
            throw new NiFiRegistryException("Invalid bundle type, should be one of " + BundleType.NIFI_NAR.toString() + " or " + BundleType.MINIFI_CPP.toString());
        }
        File bundleFile = new File(this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_FILE));
        BundleVersionClient bundleVersionClient = client.getBundleVersionClient();
        boolean skipSha256 = properties.containsKey(CommandOption.SKIP_SHA_256.getLongName());
        String sha256 = null;
        if (!skipSha256) {
            try (FileInputStream inputStream = new FileInputStream(bundleFile);){
                sha256 = Hex.encodeHexString((byte[])DigestUtils.sha256((InputStream)inputStream));
            }
        }
        try (FileInputStream bundleInputStream = new FileInputStream(bundleFile);){
            BundleVersion createdBundleVersion = bundleVersionClient.create(bucketId, bundleType, (InputStream)bundleInputStream, sha256);
            BundleVersionResult bundleVersionResult = new BundleVersionResult(this.getResultType(properties), createdBundleVersion);
            return bundleVersionResult;
        }
    }
}

