/****************************************************************************
 * examples/ft80x/ft80x_bitmaps.c
 *
 *   Copyright (C) 2018 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * Derives from FTDI sample code which appears to have an unrestricted
 * license.  Re-released here under the BSD 3-clause license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include <errno.h>

#include <nuttx/lcd/ft80x.h>

#include "graphics/ft80x.h"
#include "ft80x.h"

#ifndef CONFIG_EXAMPLES_FT80X_EXCLUDE_BITMAPS

/****************************************************************************
 * Private Data
 ****************************************************************************/

/* Raw data array for Lena Face*/

static const uint8_t g_lenaface_bitmap[] =
{
  72, 57, 105, 57, 171, 65, 236, 73, 237, 65, 236, 65, 72, 41, 35, 8, 70,
  49, 44, 139, 80, 188, 243, 204, 148, 213, 182, 164, 120, 173, 24, 198, 55,
  206, 214, 197, 149, 197, 149, 197, 83, 205, 18, 213, 50, 221, 214, 229,
  55, 230, 121, 238, 217, 230, 218, 230, 250, 238, 27, 239, 60, 247, 59, 247,

  87, 238, 237, 203, 198, 121, 164, 48, 198, 40, 43, 90, 147, 172, 110, 139,
  40, 49, 72, 49, 139, 57, 238, 73, 237, 65, 236, 65, 104, 49, 99, 16, 232,
  81, 141, 155, 145, 188, 84, 205, 149, 205, 214, 172, 120, 173, 248, 197,
  88, 206, 214, 197, 117, 197, 84, 197, 19, 205, 18, 213, 83, 221, 245, 229,

  88, 238, 153, 238, 185, 238, 218, 238, 219, 238, 27, 239, 60, 247, 59,
  247, 152, 238, 46, 212, 231, 129, 196, 64, 165, 40, 202, 81, 83, 164, 143,
  139, 231, 48, 8, 49, 74, 57, 46, 82, 237, 73, 12, 66, 235, 57, 70, 57, 108,
  147, 112, 196, 84, 205, 22, 214, 246, 205, 22, 173, 118, 181, 56, 206,

  120, 206, 181, 197, 83, 197, 242, 204, 209, 220, 18, 221, 116, 229, 246,
  229, 88, 230, 153, 238, 185, 238, 250, 238, 250, 238, 28, 239, 92, 247, 60,
  247, 218, 246, 209, 228, 104, 146, 4, 73, 133, 24, 71, 57, 242, 147, 208,
  147, 73, 57, 40, 57, 8, 49, 172, 65, 40, 41, 106, 49, 75, 82, 11, 139,

  15, 180, 209, 204, 147, 213, 22, 214, 88, 206, 87, 173, 151, 181, 247, 197,
  214, 205, 19, 205, 209, 204, 210, 212, 18, 221, 115, 229, 148, 229, 245,
  229, 87, 238, 152, 238, 185, 238, 217, 238, 250, 238, 27, 247, 60, 247, 92,
  247, 59, 247, 147, 229, 11, 171, 70, 89, 132, 32, 230, 40, 144, 139, 207,
  147,

  40, 49, 73, 57, 105, 57, 106, 49, 231, 32, 104, 57, 172, 106, 207, 171, 209,
  196, 50, 205, 115, 213, 246, 205, 121, 206, 248, 189, 150, 181, 84, 189,
  243, 196, 210, 212, 19, 229, 83, 229, 116, 229, 148, 229, 180, 229, 213,
  229, 54, 230, 120, 230, 185, 230, 185, 238, 217, 238, 250, 238, 27, 247, 93,
  255,

  92, 247, 22, 238, 140, 187, 134, 105, 132, 40, 165, 32, 13, 115, 208, 155,
  9, 49, 74, 57, 172, 65, 40, 41, 39, 41, 41, 90, 141, 147, 209, 196, 147,
  213, 83, 213, 84, 205, 246, 205, 186, 214, 23, 198, 210, 180, 238, 171, 173,
  179, 207, 187, 48, 196, 209, 204, 83, 221, 181, 237, 180, 229, 180, 237,

  246, 229, 87, 238, 120, 238, 152, 238, 184, 238, 217, 246, 27, 247, 59, 247,
  250, 246, 147, 229, 11, 163, 69, 89, 131, 32, 165, 40, 140, 98, 207, 147,
  138, 57, 138, 57, 139, 65, 231, 32, 233, 81, 76, 139, 144, 188, 179, 205,
  21, 214, 180, 205, 181, 205, 24, 206, 88, 206, 50, 197, 205, 179, 75, 179,

  12, 179, 11, 163, 234, 162, 109, 171, 80, 196, 51, 221, 116, 229, 147, 237,
  180, 237, 54, 238, 120, 238, 119, 238, 119, 230, 184, 238, 151, 238, 54,
  230, 115, 213, 46, 188, 105, 146, 37, 89, 132, 40, 164, 32, 10, 82, 239,
  147, 13, 74, 171, 57, 8, 41, 38, 41, 234, 130, 80, 180, 115, 205, 53, 222,

  87, 214, 213, 205, 215, 205, 246, 205, 208, 188, 140, 187, 141, 195, 205,
  195, 173, 187, 11, 171, 231, 129, 198, 121, 105, 146, 173, 187, 18, 221, 51,
  229, 147, 237, 245, 237, 87, 230, 87, 238, 119, 238, 245, 237, 17, 205, 237,
  179, 10, 147, 169, 154, 72, 146, 134, 105, 196, 56, 133, 32, 169, 65, 208,
  147,

  38, 41, 6, 41, 197, 24, 41, 90, 14, 164, 50, 205, 21, 222, 120, 214, 153,
  214, 87, 214, 82, 189, 204, 163, 39, 146, 39, 138, 231, 121, 7, 122, 231,
  113, 230, 121, 231, 121, 137, 146, 170, 170, 11, 187, 239, 211, 209, 228,
  51, 229, 213, 237, 120, 238, 152, 246, 87, 238, 209, 204, 43, 163, 198, 113,

  69, 89, 166, 105, 198, 121, 134, 105, 4, 65, 132, 32, 136, 65, 176, 147, 99,
  24, 196, 32, 135, 57, 141, 155, 241, 188, 212, 213, 86, 222, 217, 214, 185,
  214, 17, 181, 10, 139, 134, 97, 228, 80, 5, 81, 195, 64, 70, 81, 232, 89,
  232, 89, 5, 73, 232, 121, 202, 170, 76, 195, 173, 211, 47, 212,

  241, 228, 213, 237, 185, 246, 152, 230, 144, 180, 138, 122, 167, 89, 135,
  89, 135, 81, 5, 73, 36, 73, 5, 73, 196, 56, 164, 32, 71, 65, 143, 147, 132,
  24, 5, 41, 106, 106, 112, 180, 114, 205, 22, 214, 152, 222, 251, 222, 213,
  205, 140, 155, 166, 105, 163, 64, 4, 73, 5, 65, 164, 48, 201, 73,

  112, 123, 83, 148, 10, 98, 232, 121, 136, 170, 43, 203, 108, 203, 238, 219,
  241, 220, 54, 238, 186, 246, 212, 213, 170, 122, 70, 65, 71, 65, 76, 98, 13,
  131, 70, 73, 195, 56, 195, 48, 196, 48, 164, 40, 38, 65, 143, 139, 39, 49,
  201, 73, 110, 147, 242, 196, 181, 205, 119, 214, 186, 214, 87, 206,

  79, 188, 202, 146, 134, 105, 37, 89, 134, 89, 232, 97, 135, 81, 238, 114,
  88, 181, 220, 222, 240, 171, 137, 146, 72, 162, 233, 186, 43, 203, 206, 211,
  242, 228, 119, 238, 184, 238, 177, 180, 8, 98, 103, 65, 43, 90, 112, 139,
  114, 180, 135, 97, 196, 64, 131, 40, 196, 48, 229, 40, 38, 57, 143, 139,

  10, 82, 204, 114, 81, 172, 115, 197, 55, 206, 185, 214, 87, 206, 144, 180,
  43, 179, 76, 187, 235, 162, 105, 138, 8, 130, 204, 138, 14, 131, 115, 156,
  57, 206, 219, 238, 19, 221, 108, 195, 201, 186, 234, 186, 43, 203, 141, 211,
  51, 229, 185, 246, 152, 222, 206, 179, 236, 138, 206, 122, 145, 131, 83,
  164,

  49, 188, 166, 105, 195, 64, 131, 40, 197, 40, 38, 49, 70, 57, 143, 139, 108,
  155, 238, 163, 19, 197, 22, 214, 217, 214, 22, 206, 79, 180, 10, 179, 108,
  195, 206, 203, 238, 203, 141, 187, 12, 171, 235, 170, 78, 179, 16, 188, 211,
  196, 244, 204, 20, 205, 48, 204, 141, 195, 11, 195, 44, 195, 140, 203,

  19, 229, 153, 246, 218, 230, 211, 196, 240, 187, 143, 171, 241, 171, 143,
  163, 105, 138, 101, 105, 5, 81, 228, 64, 229, 48, 39, 57, 38, 57, 111, 139,
  237, 171, 111, 188, 213, 213, 153, 214, 245, 197, 46, 180, 234, 170, 43,
  195, 206, 211, 48, 212, 80, 212, 80, 212, 239, 211, 173, 203, 174, 195, 239,
  195,

  80, 196, 115, 204, 244, 212, 80, 212, 174, 195, 76, 195, 76, 203, 109, 211,
  211, 220, 121, 238, 28, 239, 182, 213, 113, 204, 239, 195, 174, 187, 44,
  163, 72, 138, 7, 130, 133, 113, 227, 72, 196, 48, 39, 57, 6, 49, 79, 131,
  177, 196, 82, 197, 119, 222, 55, 198, 46, 164, 201, 162, 137, 170, 77, 203,

  239, 211, 81, 220, 146, 220, 178, 228, 177, 220, 145, 220, 113, 212, 145,
  212, 211, 212, 211, 212, 243, 212, 113, 212, 239, 203, 141, 203, 108, 203,
  44, 203, 145, 220, 89, 238, 61, 239, 88, 230, 243, 212, 80, 204, 174, 203,
  76, 187, 202, 170, 201, 162, 230, 129, 4, 81, 196, 48, 38, 57, 5, 49, 46,
  123,

  180, 213, 245, 213, 151, 214, 144, 156, 136, 138, 71, 162, 234, 186, 141,
  211, 239, 219, 112, 220, 210, 228, 18, 229, 83, 221, 51, 221, 51, 229, 84,
  229, 84, 229, 117, 221, 20, 221, 113, 212, 239, 203, 173, 203, 108, 211, 76,
  211, 81, 220, 56, 238, 93, 239, 154, 222, 84, 221, 145, 212, 14, 212, 141,
  203,

  44, 195, 11, 187, 39, 138, 36, 89, 229, 56, 37, 65, 229, 48, 13, 123, 184,
  222, 119, 214, 116, 173, 231, 89, 230, 129, 136, 170, 43, 195, 108, 203,
  238, 211, 80, 220, 209, 228, 19, 229, 116, 229, 148, 229, 148, 229, 149,
  229, 117, 229, 148, 221, 18, 221, 112, 220, 47, 220, 238, 203, 108, 211, 44,
  203,

  16, 212, 247, 229, 61, 239, 154, 230, 84, 221, 209, 212, 15, 212, 174, 211,
  76, 195, 75, 195, 71, 146, 69, 81, 197, 56, 70, 73, 196, 48, 204, 114, 215,
  222, 148, 181, 170, 90, 195, 64, 230, 137, 233, 186, 42, 203, 107, 203, 205,
  211, 47, 220, 145, 228, 242, 228, 116, 237, 181, 237, 181, 229, 148, 229,

  148, 229, 82, 229, 242, 228, 111, 212, 47, 220, 238, 211, 140, 211, 75, 203,
  15, 212, 215, 229, 61, 239, 219, 230, 83, 213, 209, 212, 47, 212, 174, 211,
  108, 211, 75, 195, 39, 138, 37, 73, 196, 56, 38, 65, 196, 48, 139, 106, 19,
  157, 239, 123, 229, 40, 5, 73, 7, 138, 201, 178, 42, 203, 107, 211,

  173, 211, 14, 220, 112, 220, 208, 228, 18, 229, 148, 229, 148, 229, 147,
  229, 115, 229, 50, 221, 208, 220, 79, 220, 13, 212, 173, 211, 107, 203, 75,
  203, 206, 211, 150, 229, 28, 239, 251, 230, 83, 213, 177, 212, 48, 212, 206,
  211, 108, 203, 42, 195, 231, 121, 229, 72, 196, 40, 38, 73, 197, 56, 74,
  106,

  170, 82, 232, 65, 164, 40, 37, 81, 230, 137, 169, 178, 43, 203, 108, 211,
  141, 211, 238, 219, 80, 220, 145, 228, 242, 228, 82, 237, 84, 229, 115, 229,
  82, 229, 17, 229, 175, 220, 13, 212, 173, 211, 140, 203, 75, 203, 10, 203,
  174, 211, 85, 221, 219, 238, 60, 239, 83, 213, 177, 212, 79, 212, 207, 211,

  140, 203, 234, 178, 167, 105, 229, 56, 229, 48, 102, 73, 196, 56, 9, 90,
  163, 24, 164, 32, 228, 48, 101, 89, 230, 137, 168, 178, 42, 203, 107, 203,
  140, 211, 237, 219, 80, 220, 112, 220, 209, 228, 241, 228, 50, 229, 50, 229,
  50, 229, 241, 228, 143, 220, 237, 211, 139, 203, 107, 203, 75, 203, 9, 203,

  140, 203, 243, 220, 154, 230, 61, 239, 84, 221, 145, 212, 47, 212, 238, 211,
  108, 203, 169, 170, 101, 89, 229, 48, 38, 57, 134, 81, 196, 56, 200, 81, 34,
  16, 132, 24, 69, 65, 133, 105, 230, 137, 135, 170, 10, 195, 75, 211, 108,
  211, 205, 219, 14, 220, 79, 220, 111, 220, 144, 220, 209, 228, 241, 220,

  241, 228, 176, 228, 47, 220, 171, 203, 75, 203, 75, 203, 75, 203, 11, 195,
  140, 211, 178, 220, 89, 238, 125, 247, 116, 221, 145, 220, 47, 212, 206,
  211, 108, 195, 72, 138, 6, 65, 197, 40, 37, 65, 134, 89, 195, 48, 103, 73,
  66, 24, 164, 40, 102, 81, 167, 113, 230, 137, 135, 170, 10, 195, 75, 203,

  108, 211, 173, 211, 238, 219, 47, 220, 79, 228, 111, 220, 144, 220, 177,
  220, 209, 220, 144, 220, 14, 212, 75, 195, 43, 203, 108, 211, 172, 211, 107,
  211, 107, 211, 145, 220, 56, 238, 92, 239, 84, 221, 112, 212, 14, 212, 173,
  203, 43, 179, 168, 97, 197, 40, 197, 32, 37, 57, 133, 81, 195, 56, 38, 65,

  99, 32, 196, 40, 135, 73, 231, 121, 6, 146, 135, 178, 9, 195, 42, 203, 75,
  211, 173, 219, 206, 219, 47, 220, 79, 220, 79, 220, 144, 228, 177, 220, 208,
  220, 176, 220, 14, 212, 108, 195, 42, 195, 42, 187, 202, 170, 201, 186, 201,
  194, 204, 211, 83, 229, 120, 230, 242, 212, 79, 212, 238, 211, 140, 195,

  170, 154, 37, 65, 197, 32, 229, 48, 37, 65, 69, 81, 228, 64, 228, 56, 99,
  32, 196, 48, 199, 81, 39, 130, 39, 154, 136, 186, 9, 203, 42, 203, 107, 211,
  140, 211, 238, 219, 15, 220, 46, 220, 47, 220, 112, 220, 144, 220, 176, 220,
  176, 228, 79, 220, 204, 211, 75, 203, 234, 194, 169, 170, 200, 186,

  201, 186, 238, 203, 51, 221, 214, 229, 209, 212, 48, 204, 239, 203, 76, 179,
  40, 114, 197, 32, 198, 32, 6, 49, 69, 73, 133, 81, 4, 65, 196, 40, 99, 32,
  228, 48, 232, 81, 105, 130, 103, 154, 168, 186, 9, 203, 42, 203, 74, 211,
  140, 219, 205, 219, 238, 219, 14, 212, 47, 220, 111, 220, 144, 220,

  176, 220, 177, 228, 111, 220, 14, 212, 172, 211, 75, 203, 75, 203, 140, 203,
  238, 195, 211, 212, 149, 221, 148, 221, 177, 212, 16, 212, 205, 195, 235,
  154, 102, 81, 165, 32, 230, 32, 38, 57, 134, 81, 166, 89, 37, 73, 164, 48,
  131, 40, 229, 48, 200, 81, 137, 130, 104, 154, 200, 178, 41, 203, 42, 203,

  75, 203, 140, 211, 205, 219, 237, 219, 238, 219, 15, 220, 80, 228, 112, 228,
  144, 220, 145, 220, 144, 220, 111, 220, 47, 220, 14, 220, 112, 220, 83, 229,
  181, 221, 88, 230, 120, 222, 115, 221, 112, 204, 15, 204, 109, 179, 106,
  122, 230, 40, 198, 24, 6, 41, 103, 57, 166, 81, 166, 89, 69, 73, 196, 56,

  164, 40, 5, 49, 200, 81, 170, 130, 136, 154, 200, 186, 42, 203, 74, 203, 74,
  211, 140, 211, 173, 211, 205, 219, 205, 219, 238, 211, 46, 220, 79, 220, 80,
  220, 111, 220, 112, 220, 79, 212, 79, 212, 144, 220, 82, 221, 121, 230, 121,
  230, 185, 238, 152, 230, 83, 221, 48, 204, 15, 204, 12, 163, 168, 81,

  165, 32, 197, 32, 6, 49, 103, 65, 134, 89, 101, 89, 69, 81, 196, 56, 164,
  48, 229, 56, 102, 73, 106, 122, 104, 146, 168, 178, 9, 203, 74, 211, 107,
  203, 140, 219, 172, 211, 204, 219, 205, 219, 204, 211, 205, 219, 238, 219,
  14, 220, 79, 220, 79, 220, 79, 212, 112, 220, 176, 220, 50, 221, 87, 230,

  120, 238, 88, 230, 247, 229, 242, 212, 15, 204, 174, 195, 139, 130, 38, 49,
  165, 24, 198, 32, 38, 49, 102, 65, 166, 89, 133, 89, 69, 73, 196, 48, 228,
  56, 5, 57, 69, 73, 73, 114, 39, 138, 103, 170, 233, 202, 74, 211, 74, 211,
  107, 211, 140, 219, 173, 219, 205, 219, 205, 219, 140, 211, 107, 195,

  75, 195, 172, 203, 204, 211, 173, 211, 204, 203, 204, 211, 237, 211, 177,
  228, 209, 220, 209, 212, 112, 204, 239, 203, 239, 203, 76, 171, 233, 97,
  197, 32, 198, 32, 230, 40, 38, 49, 102, 73, 166, 89, 166, 89, 101, 81, 228,
  56, 37, 65, 5, 65, 37, 65, 40, 106, 230, 121, 70, 154, 232, 194, 74, 203,

  42, 203, 106, 211, 139, 211, 172, 219, 237, 219, 12, 220, 106, 203, 232,
  186, 167, 178, 233, 194, 10, 195, 42, 203, 9, 195, 234, 194, 11, 195, 141,
  211, 173, 211, 108, 195, 11, 187, 76, 187, 206, 195, 170, 122, 102, 65, 197,
  24, 197, 40, 229, 48, 37, 57, 134, 81, 167, 97, 166, 89, 102, 81, 229, 56,

  37, 73, 37, 65, 37, 57, 232, 97, 198, 105, 38, 138, 168, 186, 9, 195, 10,
  203, 42, 203, 74, 211, 172, 211, 237, 211, 45, 220, 172, 211, 42, 195, 168,
  194, 104, 186, 136, 194, 201, 202, 12, 203, 77, 203, 143, 203, 17, 220, 18,
  212, 176, 211, 110, 195, 206, 203, 108, 171, 168, 81, 229, 40, 197, 32,

  197, 32, 229, 40, 37, 65, 134, 81, 198, 97, 133, 89, 134, 81, 37, 65, 69,
  73, 69, 73, 37, 65, 166, 89, 165, 97, 230, 121, 136, 162, 233, 186, 233,
  194, 9, 195, 75, 203, 108, 203, 204, 211, 237, 211, 14, 220, 204, 219, 75,
  211, 9, 211, 233, 210, 43, 227, 142, 227, 50, 228, 180, 236, 245, 236,

  147, 220, 82, 212, 16, 204, 14, 196, 105, 114, 5, 49, 197, 32, 229, 40, 196,
  40, 228, 48, 5, 57, 101, 81, 230, 97, 166, 97, 102, 81, 70, 65, 70, 65, 70,
  65, 70, 65, 166, 81, 133, 81, 198, 105, 38, 146, 167, 178, 200, 178, 233,
  194, 42, 195, 75, 203, 172, 211, 206, 211, 238, 219, 204, 219,

  140, 211, 74, 203, 42, 211, 10, 211, 43, 211, 109, 211, 174, 219, 143, 211,
  240, 219, 48, 220, 15, 204, 75, 163, 135, 73, 197, 40, 197, 32, 229, 48,
  228, 48, 229, 48, 5, 57, 134, 81, 231, 97, 199, 97, 102, 81, 69, 73, 69, 65,
  37, 65, 38, 65, 102, 73, 102, 73, 134, 97, 197, 121, 70, 154,

  136, 170, 201, 186, 9, 195, 75, 195, 108, 211, 173, 211, 205, 211, 206, 211,
  173, 211, 140, 211, 108, 211, 140, 203, 140, 211, 141, 211, 141, 211, 173,
  211, 240, 211, 47, 204, 141, 179, 7, 106, 5, 49, 197, 32, 229, 32, 5, 49, 5,
  49, 229, 56, 4, 57, 102, 81, 7, 106, 230, 97, 100, 89, 101, 81,

  37, 65, 37, 65, 5, 57, 37, 65, 69, 73, 69, 73, 133, 97, 197, 129, 38, 154,
  135, 170, 233, 186, 42, 195, 107, 203, 173, 203, 173, 211, 205, 203, 238,
  211, 238, 211, 14, 212, 47, 212, 111, 220, 144, 220, 112, 220, 144, 220,
  144, 220, 14, 196, 202, 146, 37, 65, 164, 32, 197, 24, 5, 41, 38, 57,

  37, 57, 4, 49, 5, 57, 134, 89, 7, 106, 199, 105, 133, 89, 134, 81, 36, 65,
  36, 65, 5, 65, 4, 57, 37, 65, 36, 65, 36, 81, 36, 89, 165, 113, 38, 154,
  135, 170, 10, 195, 107, 195, 140, 203, 174, 211, 238, 211, 15, 212, 80, 220,
  177, 212, 210, 220, 19, 221, 84, 229, 51, 229, 242, 220,

  177, 220, 173, 179, 41, 114, 196, 40, 196, 32, 229, 32, 38, 41, 70, 57, 69,
  57, 228, 48, 4, 65, 199, 89, 72, 114, 231, 97, 198, 97, 134, 89, 228, 48, 4,
  57, 4, 65, 5, 57, 37, 65, 37, 65, 69, 73, 36, 65, 195, 72, 68, 97, 229, 145,
  168, 170, 43, 195, 108, 203, 173, 211, 14, 212,

  47, 212, 112, 220, 211, 220, 19, 229, 51, 221, 51, 229, 52, 229, 243, 220,
  177, 212, 76, 155, 167, 89, 228, 40, 6, 33, 39, 33, 70, 41, 38, 57, 5, 57,
  196, 48, 37, 65, 231, 97, 73, 114, 231, 105, 166, 97, 198, 97, 229, 40, 228,
  48, 5, 57, 37, 57, 38, 65, 38, 65, 70, 73, 101, 81,

  228, 64, 4, 73, 101, 97, 197, 129, 71, 146, 169, 162, 43, 179, 141, 195,
  205, 203, 47, 212, 113, 212, 210, 220, 19, 221, 18, 221, 209, 220, 144, 212,
  47, 204, 202, 146, 102, 73, 197, 32, 39, 33, 39, 41, 71, 49, 70, 57, 4, 49,
  228, 48, 70, 65, 8, 98, 104, 114, 7, 98, 231, 105, 230, 97,
};

/****************************************************************************
 * Public Data
 ****************************************************************************/

/* Header of Lena's face bitmap containing properties of the bitmap */

const struct ft80x_bitmaphdr_s g_lenaface_bmhdr =
{
  FT80X_FORMAT_RGB565, /* format */
  40,                  /* width */
  40,                  /* height */
  2 * 40,              /* stride */
  0,                   /* offset */
  g_lenaface_bitmap    /* data */
};

#endif /* CONFIG_EXAMPLES_FT80X_EXCLUDE_BITMAPS */
