/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_sans22x29b.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __LIBS_LIBNX_NXFONTS_NXFONTS_SANS22X29B_H
#define __LIBS_LIBNX_NXFONTS_NXFONTS_SANS22X29B_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

/* Font ID */

#define NXFONT_ID         FONTID_SANS22X29B

/* Ranges of 7-bit and 8-bit fonts */

#define NXFONT_MIN7BIT    33
#define NXFONT_MAX7BIT    126

#define NXFONT_MIN8BIT    161
#define NXFONT_MAX8BIT    255

/* Maximum height and width of any glyph in the set */

#define NXFONT_MAXHEIGHT  29
#define NXFONT_MAXWIDTH   22

/* The width of a space */

#define NXFONT_SPACEWIDTH 5

/* exclam (33) */
#define NXFONT_METRICS_33 {1, 3, 14, 1, 8, 0}
#define NXFONT_BITMAP_33 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xc0, 0xc0, 0x0, 0xe0, 0xe0, 0xe0}

/* quotedbl (34) */
#define NXFONT_METRICS_34 {1, 5, 5, 1, 8, 0}
#define NXFONT_BITMAP_34 {0xd8, 0xd8, 0xd8, 0xd8, 0x90}

/* numbersign (35) */
#define NXFONT_METRICS_35 {2, 11, 13, 0, 9, 0}
#define NXFONT_BITMAP_35 {0xd, 0x80, 0xd, 0x80, 0xd, 0x80, 0x7f, 0xe0, 0x7f, 0xe0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0x36, 0x0, 0x36, 0x0, 0x36, 0x0}

/* dollar (36) */
#define NXFONT_METRICS_36 {2, 10, 16, 0, 8, 0}
#define NXFONT_BITMAP_36 {0x4, 0x0, 0x3f, 0x0, 0x7f, 0x80, 0xe5, 0x80, 0xe4, 0x0, 0xe4, 0x0, 0x7c, 0x0, 0x3f, 0x0, 0xf, 0x80, 0x9, 0xc0, 0xe9, 0xc0, 0xe9, 0xc0, 0x7f, 0x80, 0x3f, 0x0, 0x8, 0x0, 0x8, 0x0}

/* percent (37) */
#define NXFONT_METRICS_37 {2, 13, 13, 1, 9, 0}
#define NXFONT_BITMAP_37 {0x78, 0x60, 0xfc, 0x60, 0xcc, 0xc0, 0xcc, 0x80, 0xfd, 0x80, 0x7b, 0x0, 0x2, 0x0, 0x6, 0xf0, 0xd, 0xf8, 0x9, 0x98, 0x19, 0x98, 0x31, 0xf8, 0x30, 0xf0}

/* ampersand (38) */
#define NXFONT_METRICS_38 {2, 13, 14, 1, 8, 0}
#define NXFONT_BITMAP_38 {0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0x61, 0x80, 0x73, 0x0, 0x3e, 0x0, 0x1c, 0x60, 0x7e, 0x60, 0xe7, 0xe0, 0xc3, 0xc0, 0xc1, 0xc0, 0xe3, 0xe0, 0x7f, 0x70, 0x3e, 0x38}

/* quotesingle (39) */
#define NXFONT_METRICS_39 {1, 2, 5, 1, 8, 0}
#define NXFONT_BITMAP_39 {0xc0, 0xc0, 0xc0, 0xc0, 0x80}

/* parenleft (40) */
#define NXFONT_METRICS_40 {1, 6, 18, 1, 8, 0}
#define NXFONT_BITMAP_40 {0x1c, 0x38, 0x30, 0x70, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x70, 0x30, 0x38, 0x1c}

/* parenright (41) */
#define NXFONT_METRICS_41 {1, 6, 18, 0, 8, 0}
#define NXFONT_BITMAP_41 {0xe0, 0x70, 0x30, 0x38, 0x18, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x18, 0x38, 0x30, 0x70, 0xe0}

/* asterisk (42) */
#define NXFONT_METRICS_42 {1, 7, 6, 1, 8, 0}
#define NXFONT_BITMAP_42 {0x10, 0xd6, 0x7c, 0x38, 0x6c, 0x44}

/* plus (43) */
#define NXFONT_METRICS_43 {1, 8, 8, 1, 13, 0}
#define NXFONT_BITMAP_43 {0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18}

/* comma (44) */
#define NXFONT_METRICS_44 {1, 3, 6, 1, 19, 0}
#define NXFONT_BITMAP_44 {0xe0, 0xe0, 0xe0, 0x60, 0xc0, 0x80}

/* hyphen (45) */
#define NXFONT_METRICS_45 {1, 5, 3, 0, 15, 0}
#define NXFONT_BITMAP_45 {0xf8, 0xf8, 0xf8}

/* period (46) */
#define NXFONT_METRICS_46 {1, 3, 3, 1, 19, 0}
#define NXFONT_BITMAP_46 {0xe0, 0xe0, 0xe0}

/* slash (47) */
#define NXFONT_METRICS_47 {1, 5, 14, 0, 8, 0}
#define NXFONT_BITMAP_47 {0x18, 0x18, 0x18, 0x38, 0x30, 0x30, 0x30, 0x70, 0x60, 0x60, 0xe0, 0xc0, 0xc0, 0xc0}

/* zero (48) */
#define NXFONT_METRICS_48 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_48 {0x1c, 0x0, 0x7f, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x7f, 0x0, 0x1c, 0x0}

/* one (49) */
#define NXFONT_METRICS_49 {1, 6, 13, 1, 9, 0}
#define NXFONT_BITMAP_49 {0x1c, 0x3c, 0xfc, 0xfc, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c, 0x1c}

/* two (50) */
#define NXFONT_METRICS_50 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_50 {0x3e, 0x0, 0x7f, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x1f, 0x0, 0x3e, 0x0, 0x78, 0x0, 0x70, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* three (51) */
#define NXFONT_METRICS_51 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_51 {0x3e, 0x0, 0x7f, 0x0, 0xe7, 0x0, 0xe3, 0x0, 0x7, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0x7, 0x80, 0x3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* four (52) */
#define NXFONT_METRICS_52 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_52 {0x7, 0x0, 0xf, 0x0, 0x1f, 0x0, 0x3f, 0x0, 0x37, 0x0, 0x77, 0x0, 0x67, 0x0, 0xe7, 0x0, 0xff, 0x80, 0xff, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0}

/* five (53) */
#define NXFONT_METRICS_53 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_53 {0xff, 0x0, 0xff, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xfe, 0x0, 0xff, 0x0, 0xe7, 0x80, 0x3, 0x80, 0x3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x0, 0x7e, 0x0}

/* six (54) */
#define NXFONT_METRICS_54 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_54 {0x3f, 0x0, 0x7f, 0x80, 0x71, 0x80, 0xe0, 0x0, 0xee, 0x0, 0xff, 0x0, 0xf3, 0x80, 0xe1, 0x80, 0xe1, 0x80, 0xe1, 0x80, 0xf3, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* seven (55) */
#define NXFONT_METRICS_55 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_55 {0xff, 0x80, 0xff, 0x80, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x38, 0x0, 0x70, 0x0, 0x70, 0x0, 0x70, 0x0}

/* eight (56) */
#define NXFONT_METRICS_56 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_56 {0x3e, 0x0, 0x7f, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x7f, 0x0, 0x3e, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* nine (57) */
#define NXFONT_METRICS_57 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_57 {0x3e, 0x0, 0x7f, 0x0, 0xe7, 0x80, 0xc3, 0x80, 0xc3, 0x80, 0xc3, 0x80, 0xe7, 0x80, 0x7f, 0x80, 0x3b, 0x80, 0x3, 0x80, 0xc7, 0x0, 0xff, 0x0, 0x7e, 0x0}

/* colon (58) */
#define NXFONT_METRICS_58 {1, 3, 10, 1, 12, 0}
#define NXFONT_BITMAP_58 {0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0}

/* semicolon (59) */
#define NXFONT_METRICS_59 {1, 3, 13, 1, 12, 0}
#define NXFONT_BITMAP_59 {0xe0, 0xe0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xe0, 0xe0, 0x60, 0xc0, 0x80}

/* less (60) */
#define NXFONT_METRICS_60 {2, 9, 9, 1, 13, 0}
#define NXFONT_BITMAP_60 {0x3, 0x80, 0xf, 0x80, 0x3e, 0x0, 0x78, 0x0, 0xe0, 0x0, 0x78, 0x0, 0x3e, 0x0, 0xf, 0x80, 0x3, 0x80}

/* equal (61) */
#define NXFONT_METRICS_61 {2, 9, 5, 1, 14, 0}
#define NXFONT_BITMAP_61 {0xff, 0x80, 0xff, 0x80, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* greater (62) */
#define NXFONT_METRICS_62 {2, 9, 9, 1, 13, 0}
#define NXFONT_BITMAP_62 {0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0, 0xf, 0x0, 0x3, 0x80, 0xf, 0x0, 0x3e, 0x0, 0xf8, 0x0, 0xe0, 0x0}

/* question (63) */
#define NXFONT_METRICS_63 {1, 8, 14, 1, 8, 0}
#define NXFONT_BITMAP_63 {0x7e, 0xff, 0xe7, 0xe7, 0xe, 0x1e, 0x1c, 0x38, 0x38, 0x38, 0x0, 0x38, 0x38, 0x38}

/* at (64) */
#define NXFONT_METRICS_64 {2, 16, 17, 1, 8, 0}
#define NXFONT_BITMAP_64 {0x7, 0xf0, 0x1f, 0xfc, 0x3c, 0x1e, 0x70, 0x6, 0x63, 0xb7, 0xe7, 0xf3, 0xc6, 0x63, 0xcc, 0x63, 0xcc, 0xc3, 0xcc, 0xc6, 0xcc, 0xc6, 0xef, 0xfc, 0xe7, 0xb8, 0x70, 0x0, 0x3c, 0x0, 0x1f, 0xf0, 0x7, 0xf0}

/* A (65) */
#define NXFONT_METRICS_65 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_65 {0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* B (66) */
#define NXFONT_METRICS_66 {2, 11, 14, 2, 8, 0}
#define NXFONT_BITMAP_66 {0xfe, 0x0, 0xff, 0x80, 0xe3, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe3, 0x80, 0xff, 0x80, 0xff, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xff, 0xc0, 0xff, 0x0}

/* C (67) */
#define NXFONT_METRICS_67 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_67 {0xf, 0x80, 0x3f, 0xe0, 0x78, 0xe0, 0x70, 0x70, 0xf0, 0x70, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x78, 0xe0, 0x3f, 0xe0, 0xf, 0x80}

/* D (68) */
#define NXFONT_METRICS_68 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_68 {0xff, 0x0, 0xff, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0xe0, 0xe1, 0xe0, 0xff, 0xc0, 0xff, 0x0}

/* E (69) */
#define NXFONT_METRICS_69 {2, 10, 14, 2, 8, 0}
#define NXFONT_BITMAP_69 {0xff, 0xc0, 0xff, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* F (70) */
#define NXFONT_METRICS_70 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_70 {0xff, 0xc0, 0xff, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* G (71) */
#define NXFONT_METRICS_71 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_71 {0xf, 0x80, 0x3f, 0xe0, 0x78, 0xe0, 0x70, 0x70, 0xf0, 0x70, 0xe0, 0x0, 0xe0, 0x0, 0xe3, 0xf0, 0xe3, 0xf0, 0xf0, 0x70, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xf0, 0x1f, 0xb0}

/* H (72) */
#define NXFONT_METRICS_72 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_72 {0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* I (73) */
#define NXFONT_METRICS_73 {1, 3, 14, 1, 8, 0}
#define NXFONT_BITMAP_73 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* J (74) */
#define NXFONT_METRICS_74 {2, 9, 14, 0, 8, 0}
#define NXFONT_BITMAP_74 {0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0x3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xf7, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* K (75) */
#define NXFONT_METRICS_75 {2, 13, 14, 1, 8, 0}
#define NXFONT_BITMAP_75 {0xe0, 0xf0, 0xe1, 0xe0, 0xe3, 0xc0, 0xe7, 0x80, 0xef, 0x0, 0xfe, 0x0, 0xfc, 0x0, 0xfe, 0x0, 0xef, 0x0, 0xe7, 0x80, 0xe3, 0xc0, 0xe1, 0xe0, 0xe0, 0xf0, 0xe0, 0x78}

/* L (76) */
#define NXFONT_METRICS_76 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_76 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* M (77) */
#define NXFONT_METRICS_77 {2, 14, 14, 1, 8, 0}
#define NXFONT_BITMAP_77 {0xe0, 0x1c, 0xe0, 0x1c, 0xf0, 0x3c, 0xf0, 0x3c, 0xf8, 0x7c, 0xf8, 0x7c, 0xf8, 0x7c, 0xec, 0xdc, 0xec, 0xdc, 0xec, 0xdc, 0xe7, 0x9c, 0xe7, 0x9c, 0xe3, 0x1c, 0xe3, 0x1c}

/* N (78) */
#define NXFONT_METRICS_78 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_78 {0xe0, 0x70, 0xf0, 0x70, 0xf0, 0x70, 0xf8, 0x70, 0xfc, 0x70, 0xec, 0x70, 0xee, 0x70, 0xe6, 0x70, 0xe7, 0x70, 0xe3, 0x70, 0xe1, 0xf0, 0xe1, 0xf0, 0xe0, 0xf0, 0xe0, 0x70}

/* O (79) */
#define NXFONT_METRICS_79 {2, 13, 14, 1, 8, 0}
#define NXFONT_BITMAP_79 {0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* P (80) */
#define NXFONT_METRICS_80 {2, 11, 14, 1, 8, 0}
#define NXFONT_BITMAP_80 {0xff, 0x0, 0xff, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xff, 0xc0, 0xff, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* Q (81) */
#define NXFONT_METRICS_81 {2, 13, 15, 1, 8, 0}
#define NXFONT_BITMAP_81 {0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf3, 0x78, 0x73, 0xf0, 0x79, 0xf0, 0x3f, 0xe0, 0xf, 0xf0, 0x0, 0x30}

/* R (82) */
#define NXFONT_METRICS_82 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_82 {0xff, 0x0, 0xff, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xff, 0xc0, 0xff, 0x80, 0xe1, 0xc0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0}

/* S (83) */
#define NXFONT_METRICS_83 {2, 11, 14, 1, 8, 0}
#define NXFONT_BITMAP_83 {0x3f, 0x80, 0x7f, 0xc0, 0xf1, 0xe0, 0xe0, 0xe0, 0xf0, 0x0, 0x7e, 0x0, 0x3f, 0x80, 0xf, 0xc0, 0x1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf1, 0xe0, 0x7f, 0xc0, 0x3f, 0x80}

/* T (84) */
#define NXFONT_METRICS_84 {2, 11, 14, 0, 8, 0}
#define NXFONT_BITMAP_84 {0xff, 0xe0, 0xff, 0xe0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0, 0xe, 0x0}

/* U (85) */
#define NXFONT_METRICS_85 {2, 12, 14, 1, 8, 0}
#define NXFONT_BITMAP_85 {0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* V (86) */
#define NXFONT_METRICS_86 {2, 13, 14, 0, 8, 0}
#define NXFONT_BITMAP_86 {0xe0, 0x38, 0xe0, 0x38, 0x70, 0x70, 0x70, 0x70, 0x30, 0x60, 0x38, 0xe0, 0x38, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0xd, 0x80, 0xf, 0x80, 0xf, 0x80, 0x7, 0x0, 0x7, 0x0}

/* W (87) */
#define NXFONT_METRICS_87 {2, 15, 14, 1, 8, 0}
#define NXFONT_BITMAP_87 {0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x76, 0xdc, 0x36, 0xd8, 0x36, 0xd8, 0x3e, 0xf8, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70}

/* X (88) */
#define NXFONT_METRICS_88 {2, 12, 14, 0, 8, 0}
#define NXFONT_BITMAP_88 {0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x79, 0xe0, 0x19, 0x80, 0x1f, 0x80, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x70, 0xe0, 0x70, 0xe0, 0xe0, 0x70, 0xe0, 0x70}

/* Y (89) */
#define NXFONT_METRICS_89 {2, 13, 14, 0, 8, 0}
#define NXFONT_BITMAP_89 {0xe0, 0x38, 0xe0, 0x38, 0x70, 0x70, 0x38, 0xe0, 0x38, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0xf, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0}

/* Z (90) */
#define NXFONT_METRICS_90 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_90 {0xff, 0xc0, 0xff, 0xc0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* bracketleft (91) */
#define NXFONT_METRICS_91 {1, 5, 18, 1, 8, 0}
#define NXFONT_BITMAP_91 {0xf8, 0xf8, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf8, 0xf8}

/* backslash (92) */
#define NXFONT_METRICS_92 {1, 5, 14, 0, 8, 0}
#define NXFONT_BITMAP_92 {0xc0, 0xc0, 0xc0, 0xe0, 0x60, 0x60, 0x60, 0x70, 0x30, 0x30, 0x38, 0x18, 0x18, 0x18}

/* bracketright (93) */
#define NXFONT_METRICS_93 {1, 5, 18, 0, 8, 0}
#define NXFONT_BITMAP_93 {0xf8, 0xf8, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf8}

/* asciicircum (94) */
#define NXFONT_METRICS_94 {2, 10, 7, 0, 9, 0}
#define NXFONT_BITMAP_94 {0xc, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x33, 0x0, 0x73, 0x80, 0x61, 0x80, 0xe1, 0xc0}

/* underscore (95) */
#define NXFONT_METRICS_95 {2, 10, 2, 0, 24, 0}
#define NXFONT_BITMAP_95 {0xff, 0xc0, 0xff, 0xc0}

/* grave (96) */
#define NXFONT_METRICS_96 {1, 5, 3, 0, 8, 0}
#define NXFONT_BITMAP_96 {0xe0, 0x70, 0x38}

/* a (97) */
#define NXFONT_METRICS_97 {2, 10, 10, 1, 12, 0}
#define NXFONT_BITMAP_97 {0x3e, 0x0, 0x7f, 0x0, 0x63, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* b (98) */
#define NXFONT_METRICS_98 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_98 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x0, 0xff, 0x80, 0xf3, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xf3, 0x80, 0xff, 0x80, 0xef, 0x0}

/* c (99) */
#define NXFONT_METRICS_99 {2, 9, 10, 1, 12, 0}
#define NXFONT_BITMAP_99 {0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* d (100) */
#define NXFONT_METRICS_100 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_100 {0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x3d, 0xc0, 0x7f, 0xc0, 0x73, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0xc0, 0x7f, 0xc0, 0x3d, 0xc0}

/* e (101) */
#define NXFONT_METRICS_101 {2, 9, 10, 1, 12, 0}
#define NXFONT_BITMAP_101 {0x1e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0xe1, 0x80, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* f (102) */
#define NXFONT_METRICS_102 {1, 7, 14, 0, 8, 0}
#define NXFONT_BITMAP_102 {0x1e, 0x3e, 0x38, 0x38, 0xfe, 0xfe, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* g (103) */
#define NXFONT_METRICS_103 {2, 10, 14, 1, 12, 0}
#define NXFONT_BITMAP_103 {0x3d, 0xc0, 0x7f, 0xc0, 0x73, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0xc0, 0x7f, 0xc0, 0x3d, 0xc0, 0x1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* h (104) */
#define NXFONT_METRICS_104 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_104 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x0, 0xff, 0x80, 0xf3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80}

/* i (105) */
#define NXFONT_METRICS_105 {1, 3, 14, 1, 8, 0}
#define NXFONT_BITMAP_105 {0xe0, 0xe0, 0xe0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* j (106) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_106 {1, 5, 18, 0, 8, 0}
#define NXFONT_BITMAP_106 {0x38, 0x38, 0x38, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0xf8, 0xf0}

/* k (107) */
#define NXFONT_METRICS_107 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_107 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe7, 0x0, 0xee, 0x0, 0xfc, 0x0, 0xf8, 0x0, 0xf8, 0x0, 0xfc, 0x0, 0xee, 0x0, 0xe7, 0x0, 0xe7, 0x80, 0xe3, 0x80}

/* l (108) */
#define NXFONT_METRICS_108 {1, 3, 14, 1, 8, 0}
#define NXFONT_BITMAP_108 {0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* m (109) */
#define NXFONT_METRICS_109 {2, 15, 10, 1, 12, 0}
#define NXFONT_BITMAP_109 {0xef, 0x3c, 0xff, 0xfe, 0xf3, 0xce, 0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e}

/* n (110) */
#define NXFONT_METRICS_110 {2, 9, 10, 1, 12, 0}
#define NXFONT_BITMAP_110 {0xef, 0x0, 0xff, 0x80, 0xf3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80}

/* o (111) */
#define NXFONT_METRICS_111 {2, 10, 10, 1, 12, 0}
#define NXFONT_BITMAP_111 {0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* p (112) */
#define NXFONT_METRICS_112 {2, 10, 14, 1, 12, 0}
#define NXFONT_BITMAP_112 {0xef, 0x0, 0xff, 0x80, 0xf3, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xf3, 0x80, 0xff, 0x80, 0xef, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* q (113) */
#define NXFONT_METRICS_113 {2, 10, 14, 1, 12, 0}
#define NXFONT_BITMAP_113 {0x3d, 0xc0, 0x7f, 0xc0, 0x73, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0xc0, 0x7f, 0xc0, 0x3d, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0, 0x1, 0xc0}

/* r (114) */
#define NXFONT_METRICS_114 {1, 6, 10, 1, 12, 0}
#define NXFONT_BITMAP_114 {0xec, 0xfc, 0xfc, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* s (115) */
#define NXFONT_METRICS_115 {2, 9, 10, 1, 12, 0}
#define NXFONT_BITMAP_115 {0x3f, 0x0, 0x7f, 0x80, 0xe3, 0x80, 0xe0, 0x0, 0xff, 0x0, 0x3f, 0x80, 0x3, 0x80, 0xe3, 0x80, 0xff, 0x0, 0x7e, 0x0}

/* t (116) */
#define NXFONT_METRICS_116 {1, 6, 13, 0, 9, 0}
#define NXFONT_BITMAP_116 {0x70, 0x70, 0x70, 0xfc, 0xfc, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x7c, 0x3c}

/* u (117) */
#define NXFONT_METRICS_117 {2, 9, 10, 1, 12, 0}
#define NXFONT_BITMAP_117 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x80, 0x7b, 0x80}

/* v (118) */
#define NXFONT_METRICS_118 {2, 9, 10, 0, 12, 0}
#define NXFONT_BITMAP_118 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x77, 0x0, 0x77, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* w (119) */
#define NXFONT_METRICS_119 {2, 15, 10, 0, 12, 0}
#define NXFONT_BITMAP_119 {0xe3, 0x8e, 0xe3, 0x8e, 0xe3, 0x8e, 0x73, 0x9c, 0x77, 0xdc, 0x76, 0xdc, 0x3e, 0xf8, 0x3c, 0x78, 0x1c, 0x70, 0x1c, 0x70}

/* x (120) */
#define NXFONT_METRICS_120 {2, 9, 10, 1, 12, 0}
#define NXFONT_BITMAP_120 {0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x3e, 0x0, 0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0x77, 0x0, 0xe3, 0x80, 0xe3, 0x80}

/* y (121) */
#define NXFONT_METRICS_121 {2, 9, 14, 1, 12, 0}
#define NXFONT_BITMAP_121 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x77, 0x0, 0x77, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x78, 0x0, 0x70, 0x0}

/* z (122) */
#define NXFONT_METRICS_122 {1, 8, 10, 1, 12, 0}
#define NXFONT_BITMAP_122 {0xff, 0xff, 0x7, 0xe, 0x1c, 0x38, 0x70, 0xe0, 0xff, 0xff}

/* braceleft (123) */
#define NXFONT_METRICS_123 {1, 7, 18, 1, 8, 0}
#define NXFONT_BITMAP_123 {0xe, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x70, 0xe0, 0x70, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1c, 0xe}

/* bar (124) */
#define NXFONT_METRICS_124 {1, 2, 18, 1, 8, 0}
#define NXFONT_BITMAP_124 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* braceright (125) */
#define NXFONT_METRICS_125 {1, 7, 18, 0, 8, 0}
#define NXFONT_BITMAP_125 {0xe0, 0x70, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1c, 0xe, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x70, 0xe0}

/* asciitilde (126) */
#define NXFONT_METRICS_126 {2, 9, 3, 1, 15, 0}
#define NXFONT_BITMAP_126 {0x79, 0x80, 0xff, 0x80, 0xcf, 0x0}

/* exclamdown (161) */
#define NXFONT_METRICS_161 {1, 3, 14, 2, 12, 0}
#define NXFONT_BITMAP_161 {0xe0, 0xe0, 0xe0, 0x0, 0x60, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* cent (162) */
#define NXFONT_METRICS_162 {1, 8, 14, 1, 10, 0}
#define NXFONT_BITMAP_162 {0x2, 0x2, 0x3e, 0x7f, 0xe7, 0xc8, 0xc8, 0xd0, 0xd0, 0xe3, 0x7f, 0x7e, 0x40, 0x40}

/* sterling (163) */
#define NXFONT_METRICS_163 {2, 10, 13, 0, 9, 0}
#define NXFONT_BITMAP_163 {0x1f, 0x0, 0x3f, 0xc0, 0x71, 0xc0, 0x70, 0x0, 0x70, 0x0, 0x38, 0x0, 0x7f, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0xc0, 0xff, 0xc0, 0xef, 0x80}

/* currency (164) */
#define NXFONT_METRICS_164 {2, 9, 8, 1, 12, 0}
#define NXFONT_BITMAP_164 {0xc1, 0x80, 0xff, 0x80, 0x77, 0x0, 0x63, 0x0, 0x63, 0x0, 0x77, 0x0, 0xff, 0x80, 0xc1, 0x80}

/* yen (165) */
#define NXFONT_METRICS_165 {2, 9, 13, 0, 9, 0}
#define NXFONT_BITMAP_165 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x77, 0x0, 0x3e, 0x0, 0xff, 0x80, 0x1c, 0x0, 0xff, 0x80, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* brokenbar (166) */
#define NXFONT_METRICS_166 {1, 2, 18, 1, 8, 0}
#define NXFONT_BITMAP_166 {0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x0, 0x0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0}

/* section (167) */
#define NXFONT_METRICS_167 {2, 9, 18, 0, 8, 0}
#define NXFONT_BITMAP_167 {0x3e, 0x0, 0x7f, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xf0, 0x0, 0x7c, 0x0, 0xfe, 0x0, 0xc7, 0x0, 0xc3, 0x80, 0xe1, 0x80, 0x71, 0x80, 0x3f, 0x80, 0xf, 0x0, 0x7, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x7f, 0x0, 0x3e, 0x0}

/* dieresis (168) */
#define NXFONT_METRICS_168 {1, 5, 2, 1, 8, 0}
#define NXFONT_BITMAP_168 {0xd8, 0xd8}

/* copyright (169) */
#define NXFONT_METRICS_169 {2, 14, 14, 1, 8, 0}
#define NXFONT_BITMAP_169 {0xf, 0xc0, 0x38, 0x70, 0x60, 0x18, 0xc7, 0x8c, 0xcf, 0xcc, 0x98, 0xc4, 0x98, 0x4, 0x98, 0x4, 0x98, 0x44, 0xcf, 0xcc, 0xc7, 0x8c, 0x60, 0x18, 0x38, 0x70, 0xf, 0xc0}

/* ordfeminine (170) */
#define NXFONT_METRICS_170 {1, 6, 9, 1, 8, 0}
#define NXFONT_BITMAP_170 {0x78, 0x8c, 0x7c, 0xcc, 0xcc, 0x74, 0x0, 0xfc, 0xfc}

/* guillemotleft (171) */
#define NXFONT_METRICS_171 {2, 10, 8, 0, 13, 0}
#define NXFONT_BITMAP_171 {0x1d, 0xc0, 0x3b, 0x80, 0x77, 0x0, 0xee, 0x0, 0xee, 0x0, 0x77, 0x0, 0x3b, 0x80, 0x1d, 0xc0}

/* logicalnot (172) */
#define NXFONT_METRICS_172 {2, 9, 5, 1, 14, 0}
#define NXFONT_BITMAP_172 {0xff, 0x80, 0xff, 0x80, 0x1, 0x80, 0x1, 0x80, 0x1, 0x80}

/* hyphen (173) */
#define NXFONT_METRICS_173 {1, 5, 3, 0, 15, 0}
#define NXFONT_BITMAP_173 {0xf8, 0xf8, 0xf8}

/* registered (174) */
#define NXFONT_METRICS_174 {2, 13, 14, 1, 8, 0}
#define NXFONT_BITMAP_174 {0xf, 0x80, 0x30, 0x60, 0x60, 0x10, 0x5f, 0x90, 0x99, 0xc8, 0x98, 0xc8, 0x99, 0xc8, 0x9f, 0x8, 0x99, 0x88, 0x99, 0x88, 0x58, 0xd0, 0x60, 0x30, 0x38, 0xe0, 0xf, 0x80}

/* macron (175) */
#define NXFONT_METRICS_175 {1, 5, 2, 1, 8, 0}
#define NXFONT_BITMAP_175 {0xf8, 0xf8}

/* degree (176) */
#define NXFONT_METRICS_176 {1, 6, 6, 0, 9, 0}
#define NXFONT_BITMAP_176 {0x78, 0xfc, 0xcc, 0xcc, 0xfc, 0x78}

/* plusminus (177) */
#define NXFONT_METRICS_177 {2, 9, 9, 1, 13, 0}
#define NXFONT_BITMAP_177 {0x1c, 0x0, 0x1c, 0x0, 0xff, 0x80, 0xff, 0x80, 0x1c, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80}

/* twosuperior (178) */
#define NXFONT_METRICS_178 {1, 6, 8, 0, 9, 0}
#define NXFONT_BITMAP_178 {0x78, 0xfc, 0xcc, 0x1c, 0x78, 0xe0, 0xfc, 0xfc}

/* threesuperior (179) */
#define NXFONT_METRICS_179 {1, 6, 8, 0, 9, 0}
#define NXFONT_BITMAP_179 {0x78, 0xfc, 0xcc, 0x38, 0x3c, 0xcc, 0xfc, 0x78}

/* acute (180) */
#define NXFONT_METRICS_180 {1, 5, 3, 0, 8, 0}
#define NXFONT_BITMAP_180 {0x38, 0x70, 0xe0}

/* mu (181) */
#define NXFONT_METRICS_181 {2, 9, 14, 1, 12, 0}
#define NXFONT_BITMAP_181 {0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x80, 0xfb, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* paragraph (182) */
#define NXFONT_METRICS_182 {2, 9, 18, 0, 8, 0}
#define NXFONT_BITMAP_182 {0x3f, 0x80, 0x7b, 0x0, 0xfb, 0x0, 0xfb, 0x0, 0xfb, 0x0, 0xfb, 0x0, 0xfb, 0x0, 0x7b, 0x0, 0x3b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0, 0x1b, 0x0}

/* periodcentered (183) */
#define NXFONT_METRICS_183 {1, 2, 2, 1, 14, 0}
#define NXFONT_BITMAP_183 {0xc0, 0xc0}

/* cedilla (184) */
#define NXFONT_METRICS_184 {1, 5, 5, 1, 22, 0}
#define NXFONT_BITMAP_184 {0x60, 0x70, 0x18, 0xf8, 0xf0}

/* onesuperior (185) */
#define NXFONT_METRICS_185 {1, 4, 8, 0, 9, 0}
#define NXFONT_BITMAP_185 {0x30, 0xf0, 0xf0, 0x30, 0x30, 0x30, 0x30, 0x30}

/* ordmasculine (186) */
#define NXFONT_METRICS_186 {1, 6, 9, 1, 8, 0}
#define NXFONT_BITMAP_186 {0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x0, 0xfc, 0xfc}

/* guillemotright (187) */
#define NXFONT_METRICS_187 {2, 10, 8, 0, 13, 0}
#define NXFONT_BITMAP_187 {0xee, 0x0, 0x77, 0x0, 0x3b, 0x80, 0x1d, 0xc0, 0x1d, 0xc0, 0x3b, 0x80, 0x77, 0x0, 0xee, 0x0}

/* onequarter (188) */
#define NXFONT_METRICS_188 {2, 14, 13, 0, 9, 0}
#define NXFONT_BITMAP_188 {0x30, 0x60, 0xf0, 0x60, 0xf0, 0xc0, 0x30, 0xc0, 0x31, 0x80, 0x31, 0x98, 0x33, 0x38, 0x36, 0x38, 0x6, 0x78, 0xc, 0xd8, 0xc, 0xfc, 0x18, 0x18, 0x18, 0x18}

/* onehalf (189) */
#define NXFONT_METRICS_189 {2, 15, 13, 0, 9, 0}
#define NXFONT_BITMAP_189 {0x30, 0x60, 0xf0, 0x60, 0xf0, 0xc0, 0x30, 0xc0, 0x31, 0x80, 0x31, 0xbc, 0x33, 0x7e, 0x36, 0x66, 0x6, 0xe, 0xc, 0x3c, 0xc, 0x70, 0x18, 0x7e, 0x18, 0x7e}

/* threequarters (190) */
#define NXFONT_METRICS_190 {2, 14, 13, 0, 9, 0}
#define NXFONT_BITMAP_190 {0x78, 0x30, 0xfc, 0x30, 0xcc, 0x60, 0x38, 0x60, 0x3c, 0xc0, 0xcc, 0xd8, 0xfd, 0xb8, 0x7b, 0x38, 0x3, 0x78, 0x6, 0xd8, 0x6, 0xfc, 0xc, 0x18, 0xc, 0x18}

/* questiondown (191) */
#define NXFONT_METRICS_191 {1, 8, 14, 1, 12, 0}
#define NXFONT_BITMAP_191 {0x1c, 0x1c, 0x1c, 0x0, 0x1c, 0x1c, 0x1c, 0x38, 0x78, 0x70, 0xe7, 0xe7, 0xff, 0x7e}

/* Agrave (192) */
#define NXFONT_METRICS_192 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_192 {0x38, 0x0, 0x1c, 0x0, 0x6, 0x0, 0x0, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* Aacute (193) */
#define NXFONT_METRICS_193 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_193 {0x1, 0xc0, 0x3, 0x80, 0x6, 0x0, 0x0, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* Acircumflex (194) */
#define NXFONT_METRICS_194 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_194 {0x7, 0x0, 0xf, 0x80, 0x1d, 0xc0, 0x0, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* Atilde (195) */
#define NXFONT_METRICS_195 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_195 {0xe, 0x20, 0x1f, 0xc0, 0x23, 0x80, 0x0, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* Adieresis (196) */
#define NXFONT_METRICS_196 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_196 {0x19, 0x80, 0x19, 0x80, 0x19, 0x80, 0x0, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* Aring (197) */
#define NXFONT_METRICS_197 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_197 {0xf, 0x0, 0x19, 0x80, 0x19, 0x80, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0x1f, 0x80, 0x19, 0x80, 0x19, 0x80, 0x39, 0xc0, 0x39, 0xc0, 0x30, 0xc0, 0x70, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70}

/* AE (198) */
#define NXFONT_METRICS_198 {2, 16, 14, 1, 8, 0}
#define NXFONT_BITMAP_198 {0xf, 0xff, 0xf, 0xff, 0x1f, 0x80, 0x1b, 0x80, 0x3b, 0x80, 0x3b, 0x80, 0x33, 0xfe, 0x73, 0xfe, 0x73, 0x80, 0x7f, 0x80, 0xff, 0x80, 0xe3, 0x80, 0xe3, 0xff, 0xe3, 0xff}

/* Ccedilla (199) */
#define NXFONT_METRICS_199 {2, 12, 19, 1, 8, 0}
#define NXFONT_BITMAP_199 {0xf, 0x80, 0x3f, 0xe0, 0x78, 0xe0, 0x70, 0x70, 0xf0, 0x70, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x70, 0x70, 0x70, 0x78, 0xe0, 0x3f, 0xe0, 0xf, 0x80, 0xc, 0x0, 0xe, 0x0, 0x3, 0x0, 0x1f, 0x0, 0x1e, 0x0}

/* Egrave (200) */
#define NXFONT_METRICS_200 {2, 10, 18, 2, 4, 0}
#define NXFONT_BITMAP_200 {0x38, 0x0, 0x1c, 0x0, 0x6, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* Eacute (201) */
#define NXFONT_METRICS_201 {2, 10, 18, 2, 4, 0}
#define NXFONT_BITMAP_201 {0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* Ecircumflex (202) */
#define NXFONT_METRICS_202 {2, 10, 18, 2, 4, 0}
#define NXFONT_BITMAP_202 {0xe, 0x0, 0x1f, 0x0, 0x3b, 0x80, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* Edieresis (203) */
#define NXFONT_METRICS_203 {2, 10, 18, 2, 4, 0}
#define NXFONT_BITMAP_203 {0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0xff, 0xc0, 0xff, 0xc0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0xc0, 0xff, 0xc0}

/* Igrave (204) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_204 {1, 5, 18, 0, 4, 0}
#define NXFONT_BITMAP_204 {0xe0, 0x70, 0x18, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* Iacute (205) */
#define NXFONT_METRICS_205 {1, 5, 18, 1, 4, 0}
#define NXFONT_BITMAP_205 {0x38, 0x70, 0xc0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* Icircumflex (206) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_206 {1, 7, 18, 0, 4, 0}
#define NXFONT_BITMAP_206 {0x38, 0x7c, 0xee, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* Idieresis (207) */
#define NXFONT_METRICS_207 {1, 6, 18, 0, 4, 0}
#define NXFONT_BITMAP_207 {0xcc, 0xcc, 0xcc, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70}

/* Eth (208) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_208 {2, 14, 14, 0, 8, 0}
#define NXFONT_BITMAP_208 {0x3f, 0xc0, 0x3f, 0xf0, 0x38, 0x78, 0x38, 0x38, 0x38, 0x1c, 0x38, 0x1c, 0xff, 0x1c, 0xff, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x38, 0x38, 0x78, 0x3f, 0xf0, 0x3f, 0xc0}

/* Ntilde (209) */
#define NXFONT_METRICS_209 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_209 {0xe, 0x20, 0x1f, 0xc0, 0x23, 0x80, 0x0, 0x0, 0xe0, 0x70, 0xf0, 0x70, 0xf0, 0x70, 0xf8, 0x70, 0xfc, 0x70, 0xec, 0x70, 0xee, 0x70, 0xe6, 0x70, 0xe7, 0x70, 0xe3, 0x70, 0xe1, 0xf0, 0xe1, 0xf0, 0xe0, 0xf0, 0xe0, 0x70}

/* Ograve (210) */
#define NXFONT_METRICS_210 {2, 13, 18, 1, 4, 0}
#define NXFONT_BITMAP_210 {0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x0, 0x0, 0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* Oacute (211) */
#define NXFONT_METRICS_211 {2, 13, 18, 1, 4, 0}
#define NXFONT_BITMAP_211 {0x1, 0xc0, 0x3, 0x80, 0x6, 0x0, 0x0, 0x0, 0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* Ocircumflex (212) */
#define NXFONT_METRICS_212 {2, 13, 18, 1, 4, 0}
#define NXFONT_BITMAP_212 {0x7, 0x0, 0xf, 0x80, 0x1d, 0xc0, 0x0, 0x0, 0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* Otilde (213) */
#define NXFONT_METRICS_213 {2, 13, 18, 1, 4, 0}
#define NXFONT_BITMAP_213 {0x7, 0x10, 0xf, 0xe0, 0x11, 0xc0, 0x0, 0x0, 0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* Odieresis (214) */
#define NXFONT_METRICS_214 {2, 13, 18, 1, 4, 0}
#define NXFONT_BITMAP_214 {0xc, 0xc0, 0xc, 0xc0, 0xc, 0xc0, 0x0, 0x0, 0xf, 0x80, 0x3f, 0xe0, 0x78, 0xf0, 0x70, 0x70, 0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78, 0x70, 0x70, 0x78, 0xf0, 0x3f, 0xe0, 0xf, 0x80}

/* multiply (215) */
#define NXFONT_METRICS_215 {2, 10, 8, 0, 13, 0}
#define NXFONT_BITMAP_215 {0xe1, 0xc0, 0x73, 0x80, 0x3f, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3f, 0x0, 0x73, 0x80, 0xe1, 0xc0}

/* Oslash (216) */
#define NXFONT_METRICS_216 {2, 15, 14, 0, 8, 0}
#define NXFONT_BITMAP_216 {0x7, 0xc6, 0x1f, 0xfc, 0x3c, 0x38, 0x38, 0x78, 0x78, 0xdc, 0x71, 0x9c, 0x71, 0x1c, 0x73, 0x1c, 0x76, 0x1c, 0x7c, 0x3c, 0x38, 0x38, 0x3c, 0x78, 0x7f, 0xf0, 0xc7, 0xc0}

/* Ugrave (217) */
#define NXFONT_METRICS_217 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_217 {0x1c, 0x0, 0xe, 0x0, 0x3, 0x0, 0x0, 0x0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* Uacute (218) */
#define NXFONT_METRICS_218 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_218 {0x1, 0xc0, 0x3, 0x80, 0x6, 0x0, 0x0, 0x0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* Ucircumflex (219) */
#define NXFONT_METRICS_219 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_219 {0x7, 0x0, 0xf, 0x80, 0x1d, 0xc0, 0x0, 0x0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* Udieresis (220) */
#define NXFONT_METRICS_220 {2, 12, 18, 1, 4, 0}
#define NXFONT_BITMAP_220 {0x19, 0x80, 0x19, 0x80, 0x19, 0x80, 0x0, 0x0, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0x70, 0xe0, 0x7f, 0xe0, 0x1f, 0x80}

/* Yacute (221) */
#define NXFONT_METRICS_221 {2, 13, 18, 0, 4, 0}
#define NXFONT_BITMAP_221 {0x1, 0xc0, 0x3, 0x80, 0x6, 0x0, 0x0, 0x0, 0xe0, 0x38, 0xe0, 0x38, 0x70, 0x70, 0x38, 0xe0, 0x38, 0xe0, 0x1d, 0xc0, 0x1d, 0xc0, 0xf, 0x80, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0x7, 0x0}

/* Thorn (222) */
#define NXFONT_METRICS_222 {2, 11, 14, 1, 8, 0}
#define NXFONT_BITMAP_222 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xff, 0x0, 0xff, 0xc0, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe0, 0xff, 0xc0, 0xff, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* germandbls (223) */
#define NXFONT_METRICS_223 {1, 8, 14, 1, 8, 0}
#define NXFONT_BITMAP_223 {0x3c, 0x7e, 0xe7, 0xe7, 0xe7, 0xe7, 0xee, 0xee, 0xe7, 0xe7, 0xe7, 0xe7, 0xef, 0xee}

/* agrave (224) */
#define NXFONT_METRICS_224 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_224 {0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* aacute (225) */
#define NXFONT_METRICS_225 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_225 {0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* acircumflex (226) */
#define NXFONT_METRICS_226 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_226 {0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* atilde (227) */
#define NXFONT_METRICS_227 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_227 {0x3b, 0x0, 0x7f, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* adieresis (228) */
#define NXFONT_METRICS_228 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_228 {0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* aring (229) */
#define NXFONT_METRICS_229 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_229 {0x3c, 0x0, 0x66, 0x0, 0x66, 0x0, 0x3c, 0x0, 0x3e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x80, 0x7b, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xfb, 0x80, 0x7b, 0xc0}

/* ae (230) */
#define NXFONT_METRICS_230 {2, 14, 10, 1, 12, 0}
#define NXFONT_BITMAP_230 {0x3d, 0xf0, 0x7f, 0xf8, 0x67, 0x1c, 0xf, 0x1c, 0x3f, 0xfc, 0x77, 0x0, 0xe7, 0x0, 0xef, 0x9c, 0xff, 0xfc, 0x79, 0xf0}

/* ccedilla (231) */
#define NXFONT_METRICS_231 {2, 9, 15, 1, 12, 0}
#define NXFONT_BITMAP_231 {0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0, 0x18, 0x0, 0x1c, 0x0, 0x6, 0x0, 0x3e, 0x0, 0x3c, 0x0}

/* egrave (232) */
#define NXFONT_METRICS_232 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_232 {0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0xe1, 0x80, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* eacute (233) */
#define NXFONT_METRICS_233 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_233 {0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0xe1, 0x80, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* ecircumflex (234) */
#define NXFONT_METRICS_234 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_234 {0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0xe1, 0x80, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* edieresis (235) */
#define NXFONT_METRICS_235 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_235 {0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x0, 0x73, 0x80, 0xe1, 0x80, 0xff, 0x80, 0xff, 0x80, 0xe0, 0x0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* igrave (236) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_236 {1, 5, 14, 0, 8, 0}
#define NXFONT_BITMAP_236 {0xe0, 0x70, 0x18, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* iacute (237) */
#define NXFONT_METRICS_237 {1, 5, 14, 1, 8, 0}
#define NXFONT_BITMAP_237 {0x38, 0x70, 0xc0, 0x0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0}

/* icircumflex (238) -- NOTE: Xoffset should be -1, not 0. */
#define NXFONT_METRICS_238 {1, 7, 14, 0, 8, 0}
#define NXFONT_BITMAP_238 {0x38, 0x7c, 0xee, 0x0, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38}

/* idieresis (239) */
#define NXFONT_METRICS_239 {1, 5, 14, 0, 8, 0}
#define NXFONT_BITMAP_239 {0xd8, 0xd8, 0xd8, 0x0, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70}

/* eth (240) */
#define NXFONT_METRICS_240 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_240 {0x60, 0x0, 0x37, 0x0, 0x3c, 0x0, 0x66, 0x0, 0x1f, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* ntilde (241) */
#define NXFONT_METRICS_241 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_241 {0x3b, 0x0, 0x7f, 0x0, 0x6e, 0x0, 0x0, 0x0, 0xef, 0x0, 0xff, 0x80, 0xf3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80}

/* ograve (242) */
#define NXFONT_METRICS_242 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_242 {0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* oacute (243) */
#define NXFONT_METRICS_243 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_243 {0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* ocircumflex (244) */
#define NXFONT_METRICS_244 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_244 {0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* otilde (245) */
#define NXFONT_METRICS_245 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_245 {0x3b, 0x0, 0x7f, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* odieresis (246) */
#define NXFONT_METRICS_246 {2, 10, 14, 1, 8, 0}
#define NXFONT_BITMAP_246 {0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7f, 0x80, 0x73, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0x73, 0x80, 0x7f, 0x80, 0x1e, 0x0}

/* divide (247) */
#define NXFONT_METRICS_247 {2, 9, 8, 1, 13, 0}
#define NXFONT_BITMAP_247 {0x1c, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xff, 0x80, 0xff, 0x80, 0x0, 0x0, 0x1c, 0x0, 0x1c, 0x0}

/* oslash (248) */
#define NXFONT_METRICS_248 {2, 12, 10, 0, 12, 0}
#define NXFONT_BITMAP_248 {0xf, 0x30, 0x3f, 0xe0, 0x39, 0xc0, 0x73, 0xe0, 0x77, 0xe0, 0x7e, 0xe0, 0x7c, 0xe0, 0x39, 0xc0, 0x7f, 0xc0, 0xcf, 0x0}

/* ugrave (249) */
#define NXFONT_METRICS_249 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_249 {0x70, 0x0, 0x38, 0x0, 0xc, 0x0, 0x0, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x80, 0x7b, 0x80}

/* uacute (250) */
#define NXFONT_METRICS_250 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_250 {0x3, 0x80, 0x7, 0x0, 0xc, 0x0, 0x0, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x80, 0x7b, 0x80}

/* ucircumflex (251) */
#define NXFONT_METRICS_251 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_251 {0x1c, 0x0, 0x3e, 0x0, 0x77, 0x0, 0x0, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x80, 0x7b, 0x80}

/* udieresis (252) */
#define NXFONT_METRICS_252 {2, 9, 14, 1, 8, 0}
#define NXFONT_BITMAP_252 {0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xe7, 0x80, 0xff, 0x80, 0x7b, 0x80}

/* yacute (253) */
#define NXFONT_METRICS_253 {2, 9, 18, 1, 8, 0}
#define NXFONT_BITMAP_253 {0x7, 0x0, 0xe, 0x0, 0x18, 0x0, 0x0, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x77, 0x0, 0x77, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x78, 0x0, 0x70, 0x0}

/* thorn (254) */
#define NXFONT_METRICS_254 {2, 10, 18, 1, 8, 0}
#define NXFONT_BITMAP_254 {0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xef, 0x0, 0xff, 0x80, 0xf3, 0x80, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xf3, 0x80, 0xff, 0x80, 0xef, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0, 0xe0, 0x0}

/* ydieresis (255) */
#define NXFONT_METRICS_255 {2, 9, 18, 1, 8, 0}
#define NXFONT_BITMAP_255 {0x33, 0x0, 0x33, 0x0, 0x33, 0x0, 0x0, 0x0, 0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0x77, 0x0, 0x77, 0x0, 0x77, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x1c, 0x0, 0x18, 0x0, 0x78, 0x0, 0x70, 0x0}

/****************************************************************************
 * Public Types
 ****************************************************************************/

/****************************************************************************
 * Public Data
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Functions Definitions
 ****************************************************************************/

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __LIBS_LIBNX_NXFONTS_NXFONTS_SANS22X29B_H */
