/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.netty.server.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.netty.server.api.ODataNettyHandler;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ODataHandlerImpl;
import org.apache.olingo.server.core.debug.ServerCoreDebugger;

public class ODataNettyHandlerImpl
implements ODataNettyHandler {
    public static final int COPY_BUFFER_SIZE = 8192;
    private final ODataHandlerImpl handler;
    private final ServerCoreDebugger debugger;
    private static final String CONTEXT_PATH = "contextPath";
    private static final String SPLIT = "split";
    private int split = 0;

    public ODataNettyHandlerImpl(OData odata, ServiceMetadata serviceMetadata) {
        this.debugger = new ServerCoreDebugger(odata);
        this.handler = new ODataHandlerImpl(odata, serviceMetadata, this.debugger);
    }

    private ODataResponse handleException(ODataRequest odRequest, Exception e) {
        ODataResponse resp = new ODataResponse();
        ODataServerError serverError = e instanceof ODataHandlerException ? ODataExceptionHelper.createServerErrorObject((ODataHandlerException)((Object)e), null) : (e instanceof ODataLibraryException ? ODataExceptionHelper.createServerErrorObject((ODataLibraryException)e, null) : ODataExceptionHelper.createServerErrorObject(e));
        this.handler.handleException(odRequest, resp, serverError, e);
        return resp;
    }

    static void convertToHttp(HttpResponse response, ODataResponse odResponse) {
        response.setStatus(HttpResponseStatus.valueOf((int)odResponse.getStatusCode()));
        for (Map.Entry entry : odResponse.getAllHeaders().entrySet()) {
            for (String headerValue : (List)entry.getValue()) {
                response.headers().add((String)entry.getKey(), (Object)headerValue);
            }
        }
        if (odResponse.getContent() != null) {
            ODataNettyHandlerImpl.copyContent(odResponse.getContent(), response);
        } else if (odResponse.getODataContent() != null) {
            ODataNettyHandlerImpl.writeContent(odResponse, response);
        }
    }

    static void writeContent(ODataResponse odataResponse, HttpResponse response) {
        ODataContent res = odataResponse.getODataContent();
        res.write(Channels.newChannel((OutputStream)new ByteBufOutputStream(((HttpContent)response).content())));
    }

    static void copyContent(InputStream inputStream, HttpResponse response) {
        ODataNettyHandlerImpl.copyContent(Channels.newChannel(inputStream), response);
    }

    static void copyContent(ReadableByteChannel input, HttpResponse response) {
        try (WritableByteChannel output = Channels.newChannel((OutputStream)new ByteBufOutputStream(((HttpContent)response).content()));){
            ByteBuffer inBuffer = ByteBuffer.allocate(8192);
            while (input.read(inBuffer) > 0) {
                inBuffer.flip();
                output.write(inBuffer);
                inBuffer.clear();
            }
            ODataNettyHandlerImpl.closeStream(output);
        }
        catch (IOException e) {
            throw new ODataRuntimeException("Error on reading request content", (Exception)e);
        }
        finally {
            ODataNettyHandlerImpl.closeStream(input);
        }
    }

    private static void closeStream(Channel closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ODataRequest fillODataRequest(ODataRequest odRequest, HttpRequest httpRequest, int split, String contextPath) throws ODataLibraryException {
        int requestHandle = this.debugger.startRuntimeMeasurement("ODataHttpHandlerImpl", "fillODataRequest");
        try {
            ByteBuf byteBuf = ((HttpContent)httpRequest).content();
            ByteBufInputStream inputStream = new ByteBufInputStream(byteBuf);
            odRequest.setBody((InputStream)inputStream);
            odRequest.setProtocol(httpRequest.protocolVersion().text());
            odRequest.setMethod(ODataNettyHandlerImpl.extractMethod(httpRequest));
            int innerHandle = this.debugger.startRuntimeMeasurement("ODataNettyHandlerImpl", "copyHeaders");
            ODataNettyHandlerImpl.copyHeaders(odRequest, httpRequest);
            this.debugger.stopRuntimeMeasurement(innerHandle);
            innerHandle = this.debugger.startRuntimeMeasurement("ODataNettyHandlerImpl", "fillUriInformation");
            ODataNettyHandlerImpl.fillUriInformationFromHttpRequest(odRequest, httpRequest, split, contextPath);
            this.debugger.stopRuntimeMeasurement(innerHandle);
            ODataRequest oDataRequest = odRequest;
            return oDataRequest;
        }
        finally {
            this.debugger.stopRuntimeMeasurement(requestHandle);
        }
    }

    static HttpMethod extractMethod(HttpRequest httpRequest) throws ODataLibraryException {
        HttpMethod httpRequestMethod;
        try {
            httpRequestMethod = HttpMethod.valueOf((String)httpRequest.method().name());
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("HTTP method not allowed" + httpRequest.method().name(), e, ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, httpRequest.method().name());
        }
        try {
            if (httpRequestMethod == HttpMethod.POST) {
                String xHttpMethod = httpRequest.headers().get("X-HTTP-Method");
                String xHttpMethodOverride = httpRequest.headers().get("X-HTTP-Method-Override");
                if (xHttpMethod == null && xHttpMethodOverride == null) {
                    return httpRequestMethod;
                }
                if (xHttpMethod == null) {
                    return HttpMethod.valueOf((String)xHttpMethodOverride);
                }
                if (xHttpMethodOverride == null) {
                    return HttpMethod.valueOf((String)xHttpMethod);
                }
                if (!xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
                    throw new ODataHandlerException("Ambiguous X-HTTP-Methods", ODataHandlerException.MessageKeys.AMBIGUOUS_XHTTP_METHOD, xHttpMethod, xHttpMethodOverride);
                }
                return HttpMethod.valueOf((String)xHttpMethod);
            }
            return httpRequestMethod;
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("Invalid HTTP method" + httpRequest.method().name(), e, ODataHandlerException.MessageKeys.INVALID_HTTP_METHOD, httpRequest.method().name());
        }
    }

    static void fillUriInformationFromHttpRequest(ODataRequest odRequest, HttpRequest httpRequest, int split, String contextPath) {
        int index;
        String rawODataPath;
        String rawRequestUri = httpRequest.uri();
        if (rawRequestUri.indexOf("?") != -1) {
            rawRequestUri = rawRequestUri.substring(0, rawRequestUri.indexOf("?"));
        }
        if (!"".equals(contextPath)) {
            int beginIndex = rawRequestUri.indexOf(contextPath) + contextPath.length();
            rawODataPath = rawRequestUri.substring(beginIndex);
        } else {
            rawODataPath = rawRequestUri;
        }
        String rawServiceResolutionUri = null;
        if (split > 0) {
            rawServiceResolutionUri = rawODataPath;
            for (int i = 0; i < split; ++i) {
                index = rawODataPath.indexOf(47, 1);
                if (-1 == index) {
                    rawODataPath = "";
                    break;
                }
                rawODataPath = rawODataPath.substring(index);
            }
            int end = rawServiceResolutionUri.length() - rawODataPath.length();
            rawServiceResolutionUri = rawServiceResolutionUri.substring(0, end);
        }
        String rawBaseUri = rawRequestUri.substring(0, rawRequestUri.length() - rawODataPath.length());
        index = httpRequest.uri().indexOf(63);
        String queryString = null;
        if (index != -1) {
            queryString = httpRequest.uri().substring(index + 1);
        }
        odRequest.setRawQueryPath(queryString);
        odRequest.setRawRequestUri(rawRequestUri + (queryString == null ? "" : "?" + queryString));
        odRequest.setRawODataPath(rawODataPath);
        odRequest.setRawBaseUri(rawBaseUri);
        odRequest.setRawServiceResolutionUri(rawServiceResolutionUri);
    }

    static void copyHeaders(ODataRequest odRequest, HttpRequest req) {
        Set headers = req.headers().names();
        for (String headerName : headers) {
            List headerValues = req.headers().getAll(headerName);
            odRequest.addHeader(headerName, headerValues);
        }
    }

    public void processNettyRequest(HttpRequest request, HttpResponse response, Map<String, String> requestParameters) {
        ODataResponse odResponse;
        ODataRequest odRequest = new ODataRequest();
        Exception exception = null;
        int processMethodHandle = this.debugger.startRuntimeMeasurement("ODataNettyHandlerImpl", "process");
        try {
            this.fillODataRequest(odRequest, request, requestParameters.get(SPLIT) != null ? Integer.parseInt(requestParameters.get(SPLIT)) : this.split, requestParameters.get(CONTEXT_PATH));
            odResponse = this.process(odRequest);
        }
        catch (Exception e) {
            exception = e;
            odResponse = this.handleException(odRequest, e);
        }
        this.debugger.stopRuntimeMeasurement(processMethodHandle);
        ODataNettyHandlerImpl.convertToHttp(response, odResponse);
    }

    public ODataResponse process(ODataRequest request) {
        return this.handler.process(request);
    }

    public void register(Processor processor) {
        this.handler.register(processor);
    }
}

