/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption.expression;

import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceActionImpl;
import org.apache.olingo.server.core.uri.UriResourceImpl;
import org.apache.olingo.server.core.uri.UriResourceTypedImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;

public class MemberImpl
implements Member {
    private final UriInfoResource path;
    private final EdmType startTypeFilter;

    public MemberImpl(UriInfoResource path, EdmType startTypeFilter) {
        this.path = path;
        this.startTypeFilter = startTypeFilter;
    }

    public UriInfoResource getResourcePath() {
        return this.path;
    }

    public EdmType getStartTypeFilter() {
        return this.startTypeFilter;
    }

    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        return (T)visitor.visitMember((Member)this);
    }

    public EdmType getType() {
        UriInfoImpl uriInfo = (UriInfoImpl)this.path;
        UriResourceImpl lastResourcePart = (UriResourceImpl)uriInfo.getLastResourcePart();
        if (lastResourcePart instanceof UriResourceWithKeysImpl) {
            UriResourceWithKeysImpl lastKeyPred = (UriResourceWithKeysImpl)lastResourcePart;
            if (lastKeyPred.getTypeFilterOnEntry() != null) {
                return lastKeyPred.getTypeFilterOnEntry();
            }
            if (lastKeyPred.getTypeFilterOnCollection() != null) {
                return lastKeyPred.getTypeFilterOnCollection();
            }
            return lastKeyPred.getType();
        }
        if (lastResourcePart instanceof UriResourceTypedImpl) {
            UriResourceTypedImpl lastTyped = (UriResourceTypedImpl)lastResourcePart;
            EdmType type = lastTyped.getTypeFilter();
            if (type != null) {
                return type;
            }
            return lastTyped.getType();
        }
        if (lastResourcePart instanceof UriResourceActionImpl) {
            return ((UriResourceActionImpl)lastResourcePart).getType();
        }
        return null;
    }

    public boolean isCollection() {
        UriInfoImpl uriInfo = (UriInfoImpl)this.path;
        UriResource lastResourcePart = uriInfo.getLastResourcePart();
        return lastResourcePart instanceof UriResourcePartTyped ? ((UriResourcePartTyped)lastResourcePart).isCollection() : false;
    }

    public String toString() {
        return this.path.getUriResourceParts().toString() + (this.startTypeFilter == null ? "" : this.startTypeFilter);
    }
}

