/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Constraint;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.ReferenceCounter;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class Column
extends ReferenceCounter {
    public static final int FLAG_UNINSERTABLE = 2;
    public static final int FLAG_UNUPDATABLE = 4;
    public static final int FLAG_DIRECT_INSERT = 8;
    public static final int FLAG_DIRECT_UPDATE = 16;
    public static final int FLAG_FK_INSERT = 32;
    public static final int FLAG_FK_UPDATE = 64;
    public static final int FLAG_PK_JOIN = 128;
    private DBIdentifier _name = DBIdentifier.NULL;
    private Table _table = null;
    private DBIdentifier _tableName = DBIdentifier.NULL;
    private DBIdentifier _schemaName = DBIdentifier.NULL;
    private int _type = 1111;
    private DBIdentifier _typeName = DBIdentifier.NULL;
    private int _javaType = 8;
    private int _size = 0;
    private int _decimals = 0;
    private String _defaultStr = null;
    private Object _default = null;
    private Boolean _notNull = null;
    private boolean _autoAssign = false;
    private boolean _rel = false;
    private boolean _implicitRelation = false;
    private DBIdentifier _target = DBIdentifier.NULL;
    private String _targetField = null;
    private int _flags = 0;
    private QualifiedDBIdentifier _fullPath = null;
    private int _index = 0;
    private boolean _pk = false;
    private VersionStrategy _versionStrategy = null;
    private String _comment = null;
    private boolean _XML = false;
    private boolean _isUni1MFK = false;
    private Set<Constraint> _constraints = new HashSet<Constraint>();

    public Column() {
    }

    public Column(String name, Table table) {
        this(DBIdentifier.newColumn(name), table);
    }

    public Column(DBIdentifier name, Table table) {
        this.setIdentifier(name);
        if (table != null) {
            this.setTableIdentifier(table.getIdentifier());
            this.setSchemaIdentifier(table.getSchemaIdentifier());
        }
        this._table = table;
    }

    void remove() {
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        Schema schema = table.getSchema();
        if (schema != null && schema.getSchemaGroup() != null) {
            Schema[] schemas = schema.getSchemaGroup().getSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                Table[] tabs = schemas[i].getTables();
                for (int j = 0; j < tabs.length; ++j) {
                    ForeignKey[] fks = tabs[j].getForeignKeys();
                    for (int k = 0; k < fks.length; ++k) {
                        int l;
                        Column[] cols = fks[k].getColumns();
                        Column[] pks = fks[k].getPrimaryKeyColumns();
                        for (l = 0; l < cols.length; ++l) {
                            if (!this.equals(cols[l]) && !this.equals(pks[l])) continue;
                            fks[k].removeJoin(cols[l]);
                        }
                        cols = fks[k].getConstantColumns();
                        for (l = 0; l < cols.length; ++l) {
                            if (!this.equals(cols[l])) continue;
                            fks[k].removeJoin(cols[l]);
                        }
                        pks = fks[k].getConstantPrimaryKeyColumns();
                        for (l = 0; l < pks.length; ++l) {
                            if (!this.equals(pks[l])) continue;
                            fks[k].removeJoin(pks[l]);
                        }
                        if (fks[k].getColumns().length != 0 || fks[k].getConstantColumns().length != 0) continue;
                        tabs[j].removeForeignKey(fks[k]);
                    }
                }
            }
        }
        Index[] idxs = table.getIndexes();
        for (int i = 0; i < idxs.length; ++i) {
            if (!idxs[i].removeColumn(this) || idxs[i].getColumns().length != 0) continue;
            table.removeIndex(idxs[i]);
        }
        Unique[] unqs = table.getUniques();
        for (int i = 0; i < unqs.length; ++i) {
            if (!unqs[i].removeColumn(this) || unqs[i].getColumns().length != 0) continue;
            table.removeUnique(unqs[i]);
        }
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && pk.removeColumn(this) && pk.getColumns().length == 0) {
            table.removePrimaryKey();
        }
        this._table = null;
    }

    public Table getTable() {
        return this._table;
    }

    public String getTableName() {
        return this.getTableIdentifier().getName();
    }

    public DBIdentifier getTableIdentifier() {
        return this._tableName == null ? DBIdentifier.NULL : this._tableName;
    }

    public void setTableName(String name) {
        this.setTableIdentifier(DBIdentifier.newTable(name));
    }

    public void setTableIdentifier(DBIdentifier name) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._tableName = name == null ? DBIdentifier.NULL : name;
        this._fullPath = null;
    }

    public void resetTableName(String name) {
        this._tableName = DBIdentifier.newTable(name);
    }

    public void resetTableIdentifier(DBIdentifier table) {
        this._tableName = table == null ? DBIdentifier.NULL : table;
    }

    public String getSchemaName() {
        return this.getSchemaIdentifier().getName();
    }

    public DBIdentifier getSchemaIdentifier() {
        return this._schemaName == null ? DBIdentifier.NULL : this._schemaName;
    }

    public void setSchemaName(String name) {
        this.setSchemaIdentifier(DBIdentifier.newSchema(name));
    }

    public void setSchemaIdentifier(DBIdentifier name) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._schemaName = name == null ? DBIdentifier.NULL : name;
    }

    public String getName() {
        return this.getIdentifier().getName();
    }

    public DBIdentifier getIdentifier() {
        return this._name == null ? DBIdentifier.NULL : this._name;
    }

    public void setName(String name) {
        this.setIdentifier(DBIdentifier.newColumn(name));
    }

    public void setIdentifier(DBIdentifier name) {
        if (this.getTable() != null) {
            throw new IllegalStateException();
        }
        this._name = name == null ? DBIdentifier.NULL : name;
        this._fullPath = null;
    }

    public String getFullName() {
        return this.getFullDBIdentifier().getName();
    }

    public DBIdentifier getFullDBIdentifier() {
        return this.getQualifiedPath().getIdentifier();
    }

    public QualifiedDBIdentifier getQualifiedPath() {
        if (this._fullPath == null) {
            this._fullPath = QualifiedDBIdentifier.newPath(this.getTableIdentifier(), this.getIdentifier());
        }
        return this._fullPath;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int sqlType) {
        this._type = sqlType;
    }

    public String getTypeName() {
        return this.getTypeIdentifier().getName();
    }

    public DBIdentifier getTypeIdentifier() {
        return this._typeName == null ? DBIdentifier.NULL : this._typeName;
    }

    public void setTypeName(String typeName) {
        this.setTypeIdentifier(DBIdentifier.newColumnDefinition(typeName));
    }

    public void setTypeIdentifier(DBIdentifier typeName) {
        this._typeName = typeName == null ? DBIdentifier.NULL : typeName;
    }

    public int getJavaType() {
        return this._javaType;
    }

    public void setJavaType(int type) {
        this._javaType = type;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public int getDecimalDigits() {
        return this._decimals;
    }

    public void setDecimalDigits(int digits) {
        this._decimals = digits;
    }

    public String getDefaultString() {
        return this._defaultStr;
    }

    public void setDefaultString(String def) {
        this._defaultStr = def;
        this._default = null;
    }

    public Object getDefault() {
        if (this._default != null) {
            return this._default;
        }
        if (this._defaultStr == null) {
            return null;
        }
        switch (this._javaType) {
            case 0: 
            case 16: {
                this._default = "true".equals(this._defaultStr) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: 
            case 17: {
                this._default = new Byte(this._defaultStr);
                break;
            }
            case 2: 
            case 18: {
                this._default = Character.valueOf(this._defaultStr.charAt(0));
                break;
            }
            case 3: 
            case 19: {
                this._default = new Double(this._defaultStr);
                break;
            }
            case 4: 
            case 20: {
                this._default = new Float(this._defaultStr);
                break;
            }
            case 5: 
            case 21: {
                this._default = Integer.parseInt(this._defaultStr);
                break;
            }
            case 6: 
            case 22: {
                this._default = Long.parseLong(this._defaultStr);
                break;
            }
            case 10: 
            case 24: {
                this._default = new BigDecimal(this._defaultStr);
                break;
            }
            case 7: 
            case 23: {
                this._default = new Short(this._defaultStr);
                break;
            }
            case 14: {
                this._default = new java.util.Date(this._defaultStr);
                break;
            }
            case 25: {
                this._default = new BigInteger(this._defaultStr);
                break;
            }
            case 1007: {
                this._default = Date.valueOf(this._defaultStr);
                break;
            }
            case 1011: {
                this._default = Timestamp.valueOf(this._defaultStr);
                break;
            }
            case 1010: {
                this._default = Time.valueOf(this._defaultStr);
                break;
            }
            default: {
                this._default = this._defaultStr;
            }
        }
        return this._default;
    }

    public void setDefault(Object def) {
        this._default = def;
        this._defaultStr = def == null ? null : def.toString();
    }

    public boolean isNotNull() {
        return Boolean.TRUE.equals(this._notNull);
    }

    public void setNotNull(boolean notNull) {
        this._notNull = notNull ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isNotNullExplicit() {
        return this._notNull != null;
    }

    public boolean isAutoAssigned() {
        return this._autoAssign;
    }

    public void setAutoAssigned(boolean autoAssign) {
        if (autoAssign != this._autoAssign && this.getTable() != null) {
            this.getTable().changeAutoAssigned(this);
        }
        this._autoAssign = autoAssign;
    }

    public boolean isRelationId() {
        return this._rel;
    }

    public void setRelationId(boolean rel) {
        if (rel != this._rel && this.getTable() != null) {
            this.getTable().changeRelationId(this);
        }
        this._rel = rel;
    }

    public String getTarget() {
        return this.getTargetIdentifier().getName();
    }

    public DBIdentifier getTargetIdentifier() {
        return this._target == null ? DBIdentifier.NULL : this._target;
    }

    public void setTarget(String target) {
        this.setTargetIdentifier(DBIdentifier.newColumn(StringUtils.trimToNull(target)));
    }

    public void setTargetIdentifier(DBIdentifier target) {
        this._target = target == null ? DBIdentifier.NULL : DBIdentifier.trimToNull(target);
    }

    public String getTargetField() {
        return this._targetField;
    }

    public void setTargetField(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        this._targetField = target;
    }

    public boolean getFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    public void setFlag(int flag, boolean on) {
        this._flags = on ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public boolean isPrimaryKey() {
        return this._pk;
    }

    void setPrimaryKey(boolean pk) {
        this._pk = pk;
    }

    public int getIndex() {
        if (this.getTable() != null) {
            this.getTable().indexColumns();
        }
        return this._index;
    }

    void setIndex(int index) {
        this._index = index;
    }

    public boolean isLob() {
        switch (this._type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatible(int type, String typeName, int size, int decimals) {
        if (type == 1111 || this.getType() == 1111) {
            return true;
        }
        switch (this.getType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (type) {
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: 
            case 2004: {
                switch (type) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case 1111: 
                    case 2004: {
                        return true;
                    }
                }
                return false;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 91: 
            case 92: 
            case 93: {
                switch (type) {
                    case -1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2007: {
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
        }
        return type == this.getType();
    }

    public String toString() {
        return this.getIdentifier().getName();
    }

    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        buf.append("Full Name: ").append(this.getFullName()).append("\n");
        buf.append("Type: ").append(Schemas.getJDBCName(this.getType())).append("\n");
        buf.append("Size: ").append(this.getSize()).append("\n");
        buf.append("Default: ").append(this.getDefaultString()).append("\n");
        buf.append("Not Null: ").append(this.isNotNull()).append("\n");
        return buf.toString();
    }

    public boolean equalsColumn(DBDictionary dict, Column col) {
        if (col == this) {
            return true;
        }
        if (col == null) {
            return false;
        }
        if (!this.getQualifiedPath().equals(col.getQualifiedPath())) {
            return false;
        }
        if (!this.isCompatible(col.getType(), col.getTypeIdentifier().getName(), col.getSize(), col.getDecimalDigits())) {
            return dict.getTypeName(this).equals(dict.getTypeName(col));
        }
        return this.getType() != 12 || this.getSize() <= 0 || col.getSize() <= 0 || this.getSize() == col.getSize();
    }

    public void copy(Column from) {
        if (from == null) {
            return;
        }
        if (DBIdentifier.isNull(this.getIdentifier())) {
            this.setIdentifier(from.getIdentifier());
        }
        if (this.getType() == 1111) {
            this.setType(from.getType());
        }
        if (DBIdentifier.isNull(this.getTypeIdentifier())) {
            this.setTypeIdentifier(from.getTypeIdentifier());
        }
        if (this.getJavaType() == 8) {
            this.setJavaType(from.getJavaType());
        }
        if (this.getSize() == 0) {
            this.setSize(from.getSize());
        }
        if (this.getDecimalDigits() == 0) {
            this.setDecimalDigits(from.getDecimalDigits());
        }
        if (this.getDefaultString() == null) {
            this.setDefaultString(from.getDefaultString());
        }
        if (!this.isNotNullExplicit() && from.isNotNullExplicit()) {
            this.setNotNull(from.isNotNull());
        }
        if (!this.isAutoAssigned()) {
            this.setAutoAssigned(from.isAutoAssigned());
        }
        if (!this.isRelationId()) {
            this.setRelationId(from.isRelationId());
        }
        if (!this.isImplicitRelation()) {
            this.setImplicitRelation(from.isRelationId());
        }
        if (DBIdentifier.isNull(this.getTargetIdentifier())) {
            this.setTargetIdentifier(from.getTargetIdentifier());
        }
        if (this.getTargetField() == null) {
            this.setTargetField(from.getTargetField());
        }
        if (this._flags == 0) {
            this._flags = from._flags;
        }
        if (!this.isXML()) {
            this.setXML(from.isXML());
        }
        if (!this.isUni1MFK()) {
            this.setUni1MFK(from.isUni1MFK());
        }
        for (Constraint c : this._constraints) {
            this.addConstraint(c);
        }
    }

    public boolean isXML() {
        return this._XML;
    }

    public void setXML(boolean xml) {
        this._XML = xml;
    }

    public VersionStrategy getVersionStrategy() {
        return this._versionStrategy;
    }

    public void setVersionStrategy(VersionStrategy strategy) {
        this._versionStrategy = strategy;
    }

    public boolean hasComment() {
        return this._comment != null && !this._comment.equalsIgnoreCase(this._name.toString());
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public boolean isImplicitRelation() {
        return this._implicitRelation;
    }

    public void setImplicitRelation(boolean flag) {
        this._implicitRelation |= flag;
    }

    public boolean isUni1MFK() {
        return this._isUni1MFK;
    }

    public void setUni1MFK(boolean isUni1MFK) {
        this._isUni1MFK = isUni1MFK;
    }

    public void addConstraint(Constraint c) {
        this._constraints.add(c);
    }

    public void removeConstraint(Constraint c) {
        this._constraints.remove(c);
    }

    public boolean hasConstraint(Class<? extends Constraint> type) {
        return !this.getConstraints(type).isEmpty();
    }

    public Set<Constraint> getConstraints() {
        return this._constraints;
    }

    public <T extends Constraint> Set<T> getConstraints(Class<T> type) {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (Constraint c : this._constraints) {
            if (c.getClass() != type) continue;
            result.add(c);
        }
        return result;
    }

    public boolean isUniqueConstraint() {
        return this.hasConstraint(Unique.class);
    }

    public boolean isIndex() {
        return this.hasConstraint(Index.class);
    }

    public boolean isForeignKey() {
        return this.hasConstraint(ForeignKey.class);
    }
}

