/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import com.ibm.wsspi.uow.UOWAction;
import java.lang.reflect.Method;
import org.apache.openjpa.ee.RegistryManagedRuntime;

public class WASRegistryManagedRuntime
extends RegistryManagedRuntime {
    private static final int WEBSPHERE_UOW_TYPE_LOCAL_TRANSACTION = 0;
    private final Method getUOWManager;
    private final Method runUnderUOW;

    public WASRegistryManagedRuntime() {
        try {
            Class<?> classUOWManagerFactory = Class.forName("com.ibm.wsspi.uow.UOWManagerFactory");
            this.getUOWManager = classUOWManagerFactory.getMethod("getUOWManager", new Class[0]);
            Class<?> classUOWManager = Class.forName("com.ibm.wsspi.uow.UOWManager");
            this.runUnderUOW = classUOWManager.getMethod("runUnderUOW", Integer.TYPE, Boolean.TYPE, UOWAction.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem while creating WASManagedRuntime", e);
        }
    }

    @Override
    public void doNonTransactionalWork(Runnable runnable) throws RuntimeException, UnsupportedOperationException {
        try {
            Object uowManager = this.getUOWManager.invoke(null, new Object[0]);
            this.runUnderUOW.invoke(uowManager, 0, false, new DelegatingUOWAction(runnable));
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException(e.getMessage(), e);
            throw re;
        }
    }

    class DelegatingUOWAction
    implements UOWAction {
        Runnable _del;

        public DelegatingUOWAction(Runnable delegate) {
            this._del = delegate;
        }

        public void run() throws Exception {
            this._del.run();
        }
    }
}

