/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.EnhancementClassLoader;
import org.apache.openjpa.util.asm.EnhancementProject;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.FieldInsnNode;
import org.apache.xbean.asm9.tree.FieldNode;
import org.apache.xbean.asm9.tree.InsnNode;
import org.apache.xbean.asm9.tree.MethodNode;
import org.apache.xbean.asm9.tree.VarInsnNode;

class InterfaceImplGenerator {
    private static final Localizer _loc = Localizer.forPackage(InterfaceImplGenerator.class);
    private static final String POSTFIX = "openjpaimpl";
    private final MetaDataRepository _repos;
    private final Map<Class<?>, Class<?>> _impls = new WeakHashMap();
    private final EnhancementProject _project = new EnhancementProject();

    public InterfaceImplGenerator(MetaDataRepository repos) {
        this._repos = repos;
    }

    public synchronized Class<?> createImpl(ClassMetaData meta) {
        Class<?> iface = meta.getDescribedType();
        Class<?> impl = this._impls.get(iface);
        if (impl != null) {
            return impl;
        }
        EnhancementProject _enhProject = new EnhancementProject();
        ClassLoader parentLoader = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(iface));
        EnhancementClassLoader loader = new EnhancementClassLoader(this._project, parentLoader);
        ClassNodeTracker bc = this._project.loadClass(this.getClassName(meta), (ClassLoader)loader);
        bc.declareInterface(iface);
        ClassMetaData sup = meta.getPCSuperclassMetaData();
        if (sup != null) {
            bc.getClassNode().superName = Type.getInternalName(sup.getInterfaceImpl());
        }
        FieldMetaData[] fields = meta.getDeclaredFields();
        HashSet<Method> methods = new HashSet<Method>();
        for (FieldMetaData field : fields) {
            this.addField(bc, iface, field, methods);
        }
        this.invalidateNonBeanMethods(bc, iface, methods);
        try {
            meta.setInterfaceImpl(Class.forName(bc.getClassNode().name.replace("/", "."), true, loader));
        }
        catch (Throwable t) {
            throw new InternalException(_loc.get("interface-load", iface, loader), t).setFatal(true);
        }
        byte[] classBytes = AsmHelper.toByteArray(bc);
        ClassNodeTracker bcEnh = _enhProject.loadClass(classBytes, parentLoader);
        PCEnhancer enhancer = new PCEnhancer(this._repos, bcEnh, meta);
        int result = enhancer.run();
        if (result != 8) {
            throw new InternalException(_loc.get("interface-badenhance", iface)).setFatal(true);
        }
        try {
            EnhancementProject finalProject = new EnhancementProject();
            EnhancementClassLoader finalLoader = new EnhancementClassLoader(finalProject, parentLoader);
            byte[] classBytes2 = AsmHelper.toByteArray(enhancer.getPCBytecode());
            finalProject.loadClass(classBytes2, (ClassLoader)finalLoader);
            String pcClassName = enhancer.getPCBytecode().getClassNode().name.replace("/", ".");
            impl = Class.forName(pcClassName, true, finalLoader);
        }
        catch (Throwable t) {
            throw new InternalException(_loc.get("interface-load2", iface, loader), t).setFatal(true);
        }
        this._impls.put(iface, impl);
        return impl;
    }

    private void addField(ClassNodeTracker cnt, Class<?> iface, FieldMetaData fmd, Set<Method> methods) {
        ClassNode classNode = cnt.getClassNode();
        String fieldName = fmd.getName();
        Class type = fmd.getDeclaredType();
        FieldNode field = new FieldNode(2, fieldName, Type.getDescriptor(type), null, null);
        classNode.fields.add(field);
        String getterName = (InterfaceImplGenerator.isGetter(iface, fmd) ? "get" : "is") + StringUtil.capitalize(fieldName);
        MethodNode meth = new MethodNode(1, getterName, Type.getMethodDescriptor(Type.getType(type), new Type[0]), null, null);
        classNode.methods.add(meth);
        meth.instructions.add(new VarInsnNode(25, 0));
        meth.instructions.add(new FieldInsnNode(180, classNode.name, fieldName, Type.getDescriptor(type)));
        meth.instructions.add(new InsnNode(AsmHelper.getReturnInsn(type)));
        methods.add(InterfaceImplGenerator.getMethodSafe(iface, meth.name, null));
        String setterName = "set" + StringUtil.capitalize(fieldName);
        meth = new MethodNode(1, setterName, Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(type)), null, null);
        classNode.methods.add(meth);
        meth.instructions.add(new VarInsnNode(25, 0));
        meth.instructions.add(new VarInsnNode(AsmHelper.getLoadInsn(type), 1));
        meth.instructions.add(new FieldInsnNode(181, classNode.name, fieldName, Type.getDescriptor(type)));
        meth.instructions.add(new InsnNode(177));
        methods.add(InterfaceImplGenerator.getMethodSafe(iface, meth.name, type));
    }

    private void invalidateNonBeanMethods(ClassNodeTracker cnt, Class<?> iface, Set<Method> methods) {
        Method[] meths = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(iface));
        Class unimplementedExceptionType = this._repos.getMetaDataFactory().getDefaults().getUnimplementedExceptionType();
        for (Method method : meths) {
            if (methods.contains(method)) continue;
            MethodNode methodNode = new MethodNode(1, method.getName(), Type.getMethodDescriptor(method), null, null);
            methodNode.instructions.add(AsmHelper.throwException(unimplementedExceptionType));
            cnt.getClassNode().methods.add(methodNode);
        }
    }

    protected final String getClassName(ClassMetaData meta) {
        Class<?> iface = meta.getDescribedType();
        return iface.getName() + "$" + System.identityHashCode(iface) + POSTFIX;
    }

    private static Method getMethodSafe(Class<?> iface, String name, Class<?> arg) {
        try {
            Class[] classArray;
            if (arg == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = arg;
            }
            return AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(iface, name, classArray));
        }
        catch (PrivilegedActionException pae) {
            throw new InternalException(_loc.get("interface-mismatch", name));
        }
    }

    private static boolean isGetter(Class<?> iface, FieldMetaData fmd) {
        if (fmd.getType() != Boolean.TYPE && fmd.getType() != Boolean.class) {
            return true;
        }
        try {
            Method meth = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(iface, "is" + StringUtil.capitalize(fmd.getName()), null));
            return meth == null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return true;
        }
    }

    boolean isImplType(Class<?> cls) {
        return cls.getName().endsWith(POSTFIX) && cls.getName().indexOf(36) != -1;
    }

    public Class<?> toManagedInterface(Class<?> cls) {
        Class<?>[] ifaces;
        for (Class<?> iface : ifaces = cls.getInterfaces()) {
            if (this._impls.get(iface) != cls) continue;
            return iface;
        }
        throw new IllegalArgumentException(cls.getName());
    }
}

