/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Producer;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class DecoratorHandler
implements InterceptorHandler,
Externalizable {
    private InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;
    private List<Decorator<?>> decorators;
    private Map<Decorator<?>, ?> instances;
    private int index;
    private Object target;
    private String passivationId;

    public DecoratorHandler(InterceptorResolutionService.BeanInterceptorInfo interceptorInfo, List<Decorator<?>> decorators, Map<Decorator<?>, ?> instances, int index, Object target, String passivationId) {
        this.interceptorInfo = interceptorInfo;
        this.instances = instances;
        this.decorators = decorators;
        this.index = index;
        this.target = target;
        this.passivationId = passivationId;
    }

    public DecoratorHandler() {
    }

    @Override
    public Object invoke(Method method, Object[] args) {
        InterceptorResolutionService.BusinessMethodInterceptorInfo methodInterceptorInfo = this.interceptorInfo.getBusinessMethodsInfo().get(method);
        LinkedHashMap<Decorator<?>, Method> methodDecorators = methodInterceptorInfo.getMethodDecorators();
        if (methodDecorators != null) {
            for (int i = this.index; i < this.decorators.size(); ++i) {
                Decorator<?> decorator = this.decorators.get(i);
                Method decoratingMethod = methodDecorators.get(decorator);
                if (decoratingMethod == null) continue;
                try {
                    if (!decoratingMethod.isAccessible()) {
                        decoratingMethod.setAccessible(true);
                    }
                    return decoratingMethod.invoke(this.instances.get(decorator), args);
                }
                catch (InvocationTargetException e) {
                    return ExceptionUtil.throwAsRuntimeException(e.getTargetException());
                }
                catch (Exception e) {
                    return ExceptionUtil.throwAsRuntimeException(e);
                }
            }
        }
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            return ExceptionUtil.throwAsRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            return ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeObject(this.target);
        out.writeInt(this.instances.size());
        for (Map.Entry<Decorator<?>, ?> entry : this.instances.entrySet()) {
            Decorator<?> key = entry.getKey();
            DecoratorHandler.serializeDecorator(out, key);
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.decorators.size());
        for (Decorator decorator : this.decorators) {
            DecoratorHandler.serializeDecorator(out, decorator);
        }
        out.writeUTF(this.passivationId);
    }

    Object readResolve() throws ObjectStreamException {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        BeanManagerImpl beanManager = webBeansContext.getBeanManagerImpl();
        Bean bean = beanManager.getPassivationCapableBean(this.passivationId);
        return webBeansContext.getInterceptorDecoratorProxyFactory().createProxyInstance(webBeansContext.getInterceptorDecoratorProxyFactory().getCachedProxyClass(bean), this.target, this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Producer producer;
        this.index = in.readInt();
        this.target = in.readObject();
        int instancesSize = in.readInt();
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        BeanManagerImpl beanManager = webBeansContext.getBeanManagerImpl();
        HashMap tmpInstances = new HashMap();
        for (int i = 0; i < instancesSize; ++i) {
            Decorator bean = (Decorator)beanManager.getPassivationCapableBean(in.readUTF());
            Object value = in.readObject();
            tmpInstances.put(bean, value);
        }
        this.instances = tmpInstances;
        int decoratorsSize = in.readInt();
        this.decorators = new CopyOnWriteArrayList();
        for (int i = 0; i < decoratorsSize; ++i) {
            this.decorators.add((Decorator)beanManager.getPassivationCapableBean(in.readUTF()));
        }
        this.passivationId = in.readUTF();
        Bean bean = beanManager.getPassivationCapableBean(this.passivationId);
        if (bean instanceof OwbBean && (producer = ((OwbBean)bean).getProducer()) instanceof AbstractProducer) {
            this.interceptorInfo = ((AbstractProducer)producer).getInterceptorInfo();
        }
    }

    private static void serializeDecorator(ObjectOutput out, Decorator<?> key) throws IOException {
        String id = WebBeansUtil.getPassivationId(key);
        if (id == null) {
            throw new NotSerializableException(key + " is not serializable");
        }
        out.writeUTF(id);
    }
}

