/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jms.util;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansCreationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.jms.JMSModel;
import org.apache.webbeans.jms.component.JmsBean;
import org.apache.webbeans.jms.util.Closable;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.util.Asserts;

public final class JmsUtil {
    private JmsUtil() {
    }

    public static boolean isJmsResourceClass(Class<?> clazz) {
        Asserts.assertNotNull(clazz, (String)"clazz parameter");
        return ConnectionFactory.class.isAssignableFrom(clazz) || Connection.class.isAssignableFrom(clazz) || Queue.class.isAssignableFrom(clazz) || Topic.class.isAssignableFrom(clazz) || MessageProducer.class.isAssignableFrom(clazz) || MessageConsumer.class.isAssignableFrom(clazz) || Session.class.isAssignableFrom(clazz);
    }

    public static boolean isJmsQueueTypeResource(Class<?> clazz) {
        return QueueConnectionFactory.class.isAssignableFrom(clazz) || QueueConnection.class.isAssignableFrom(clazz) || QueueSender.class.isAssignableFrom(clazz) || QueueReceiver.class.isAssignableFrom(clazz) || QueueSession.class.isAssignableFrom(clazz);
    }

    public static boolean isJmsQueueResource(Class<?> clazz) {
        return Queue.class.isAssignableFrom(clazz);
    }

    public static boolean isJmsTopicResource(Class<?> clazz) {
        return Topic.class.isAssignableFrom(clazz);
    }

    public static boolean isJmsTopicTypeResource(Class<?> clazz) {
        return TopicConnectionFactory.class.isAssignableFrom(clazz) || TopicConnection.class.isAssignableFrom(clazz) || TopicSubscriber.class.isAssignableFrom(clazz) || TopicPublisher.class.isAssignableFrom(clazz) || TopicSession.class.isAssignableFrom(clazz);
    }

    private static JNDIService getJNDIService() {
        JNDIService jndiService = (JNDIService)WebBeansContext.getInstance().getService(JNDIService.class);
        if (jndiService == null) {
            throw new WebBeansCreationException("JNDI service is not available");
        }
        return jndiService;
    }

    public static ConnectionFactory getConnectionFactory() {
        String connectionFactoryJndiName = WebBeansContext.getInstance().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.spi.JNDIService.jmsConnectionFactoryJndi");
        if (connectionFactoryJndiName == null || connectionFactoryJndiName.equals("")) {
            connectionFactoryJndiName = "ConnectionFactory";
        }
        return (ConnectionFactory)JmsUtil.getJNDIService().lookup(connectionFactoryJndiName, ConnectionFactory.class);
    }

    public static <T> T getInstanceFromJndi(JMSModel jmsModel, Class<T> jmsClass) {
        String jndiName = jmsModel.isJndiNameDefined() ? jmsModel.getJndiName() : jmsModel.getMappedName();
        Object instance = JmsUtil.getJNDIService().lookup(jndiName, jmsClass);
        return (T)instance;
    }

    public static Object createNewJmsProxy(JmsBean<?> jmsComponent, Class<?> intf) {
        try {
            Class[] interfaces = new Class[]{Closable.class, Serializable.class, intf};
            throw new WebBeansException("Support got temporarily removed while moving from Javassist to ASM");
        }
        catch (Exception e) {
            throw new WebBeansException((Throwable)e);
        }
    }
}

