<!--
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
-->

# OpenWhisk Core

## Apache 2.0.0
### Branch: [2.0.0](https://github.com/apache/openwhisk/tree/2.0.0)
### Changes
- Upgrade the docker version to 23.0.6 (https://github.com/apache/openwhisk/commit/8af209262c98e07b8cc3cb688d5d48f633f2d006, [@style95](https://github.com/style95))
- Enable the scheduler by default (https://github.com/apache/openwhisk/commit/4fac03aa8b2df4d8074f2af5b1139225e02890ea, [@style95](https://github.com/style95))
- Update the ngrok v3 (https://github.com/apache/openwhisk/commit/5529cc49d31f135dfdac4f2a2072ca46bfd754de, [@style95](https://github.com/style95))
- Update FPC invoker health reporting logic (https://github.com/apache/openwhisk/commit/aea3a8814d4e9ce6f704374d124146be1693f123, [@bdoyle0182](https://github.com/bdoyle0182))
- Change the required_status_checks to strict (https://github.com/apache/openwhisk/commit/e20ab1789ecea04da15dd34bddbc1143607e08cf, [@style95](https://github.com/style95))
- Bump the github_actions group with 1 update (https://github.com/apache/openwhisk/commit/29168859aaab83b821a18f12243f63793cbfe588, [@dependabot[bot]](https://github.com/apps/dependabot))
- Keep GitHub Actions up to date with GitHub's Dependabot (https://github.com/apache/openwhisk/commit/5c876f247982e2896c974f91114e1ce89b7b4c8e, [@cclauss](https://github.com/cclauss))
- Fix typo (https://github.com/apache/openwhisk/commit/3f11fcc361e060326f4341e9e79d14c185eb5771, [@cclauss](https://github.com/cclauss))
- Fix unit test cases (https://github.com/apache/openwhisk/commit/4b5c5d1c7aaebffd6e07db0c4b0d8e79b648bcbb, [@style95](https://github.com/style95))
- Update README.md (https://github.com/apache/openwhisk/commit/6d99fd1c4ae92741994457a367df3384c052ef2d, [@moritzraho](https://github.com/moritzraho))
- Add ability to scale Ephemeral storage along with memory, similar to CPU (https://github.com/apache/openwhisk/commit/b9f16dc68100e41f19a6a78f92c5e27dc5fab177, [@mcdan](https://github.com/mcdan))
- Fixed an issue with missed config keys while iterating through them on Scala 2.13.x (https://github.com/apache/openwhisk/commit/597d61d6eef974b25e5cdc6e1c284f9867429170, [@joni-jones](https://github.com/joni-jones))
- Bump lodash from 4.17.15 to 4.17.21 in /core/routemgmt/getApi (https://github.com/apache/openwhisk/commit/cdde5a79c663796da1af494296cc8afb20dfb9ac, [@dependabot[bot]](https://github.com/apps/dependabot))
- Use max-connection-pool as queue size (https://github.com/apache/openwhisk/commit/ae0c4e0c37a77de4c23ca95dee763b165ce20d18, [@style95](https://github.com/style95))
- fix: message skipping typo (https://github.com/apache/openwhisk/commit/a4f4b2da6f7fed4821775fb79a60b7a5e6f396b4, [@0o001](https://github.com/0o001))
- Memory leak in `akka.actor.LocalActorRef` (https://github.com/apache/openwhisk/commit/6f11d48b216a01b7c6fa3342d2b8b972109106f7, [@joni-jones](https://github.com/joni-jones))
- Add optional cpu limit to spawned action containers (https://github.com/apache/openwhisk/commit/0c27a650ab6073e131e5c74002465e93cf4d8621, [@quintenp01](https://github.com/quintenp01))
- Add ZOOKEEPER_HOSTS as an optional property (https://github.com/apache/openwhisk/commit/6375c96066ca0e24cb81996a877bdd7caecdb72b, [@style95](https://github.com/style95))
- Update the nodejs action kind (https://github.com/apache/openwhisk/commit/20f7d98fdfba275bc3e5c88be0b7cdec956df2aa, [@style95](https://github.com/style95))
- Maximize build spaces of all workflows by manually removing unnecessary resources (https://github.com/apache/openwhisk/commit/951ce58be7f82122734523b338053c49662a6dad, [@style95](https://github.com/style95))
- Compare invocation namespaces when handling a cycle and recovering a queue (https://github.com/apache/openwhisk/commit/9371d6290136b37a24bbb32a9ef50ff816e9211d, [@style95](https://github.com/style95))
- Refresh runtimes list: add new versions; remove old/deprecated versions (https://github.com/apache/openwhisk/commit/54564cbc76771658c14a84dd413856d8b078eeb8, [@dgrove-oss](https://github.com/dgrove-oss))
- Authenticate GitHub Actions builds to ge.apache.org (https://github.com/apache/openwhisk/commit/be3f6d63be9ff513f733f0b64bde7bca78e8c148, [@clayburn](https://github.com/clayburn))
- Remove `fail-fast` matrix strategy from GitHub Actions (https://github.com/apache/openwhisk/commit/f73ec7f006ff278c9ff88a241d58c5c799d16115, [@clayburn](https://github.com/clayburn))
- Finish setup on error (https://github.com/apache/openwhisk/commit/88156c3c382dff013dc9f636ac49f0a39886cbce, [@style95](https://github.com/style95))
- patch groovy 3.0.17 (https://github.com/apache/openwhisk/commit/6c47e6024d9de18c7151e4f04f56a195e98b0cd3, [@bdoyle0182](https://github.com/bdoyle0182))
- Capture build scans on ge.apache.org to benefit from deep build insights (https://github.com/apache/openwhisk/commit/37605b4da431d610660d97ae11e181f2aecff268, [@clayburn](https://github.com/clayburn))
- Apply scalaFmt (https://github.com/apache/openwhisk/commit/ba871e59f7b77f02689a13e4e24e438645d67a47, [@style95](https://github.com/style95))
- User Defined Action Instance Concurrency Limits (https://github.com/apache/openwhisk/commit/72bb2a1fc4783f29cb34d6ad1ffabf2b6676773b, [@bdoyle0182](https://github.com/bdoyle0182))
- use compatibility serializer for future message forma… (https://github.com/apache/openwhisk/commit/be8ac20372fe44ed226c758b71dce510a4227cc8, [@bdoyle0182](https://github.com/bdoyle0182))
- upgrade kafka client library to 2.8.2 (https://github.com/apache/openwhisk/commit/6bc559d41f74525e26c9bd03d01dc4a3e9b5c658, [@bdoyle0182](https://github.com/bdoyle0182))
- update scheduler not processing metric to counter (https://github.com/apache/openwhisk/commit/a22e706b0f93cf4d673a2aa5ab6110918ce149c0, [@bdoyle0182](https://github.com/bdoyle0182))
- add support for multi partition kafka topics (https://github.com/apache/openwhisk/commit/d84e4eefb764b36b63867967b1882d1226481f61, [@bdoyle0182](https://github.com/bdoyle0182))
- fix bug in average ring buffer and add negative protection to scheduling decision maker (https://github.com/apache/openwhisk/commit/de3e0a8fdf4bf6341ccc423727628d554e53edee, [@bdoyle0182](https://github.com/bdoyle0182))
- fix action not processing metric (https://github.com/apache/openwhisk/commit/4e2dea12c7b0cfe14dcb509685cc9097d6007e19, [@bdoyle0182](https://github.com/bdoyle0182))
- Send a queue removed message to the queue manager (https://github.com/apache/openwhisk/commit/cb3b64f84f64305cf680faaa14f2cd13bdb56589, [@style95](https://github.com/style95))
- fix memory queue stuck in removed state edge case (https://github.com/apache/openwhisk/commit/fedf0227803401f7ac6cf3a33d9e14fc6fac74e8, [@bdoyle0182](https://github.com/bdoyle0182))
- fix missed etcd unregister data case for an existing container in container proxy (https://github.com/apache/openwhisk/commit/7c94e9ba05ec9dbd59303672cc81b963d53351ba, [@bdoyle0182](https://github.com/bdoyle0182))
- Add Scheduler Queue Metric for Not Processing Any Activations (https://github.com/apache/openwhisk/commit/60ca6605bb081f99906cff1a21caf75d47e414fa, [@bdoyle0182](https://github.com/bdoyle0182))
- remove action version from scheduler metrics without kamon (https://github.com/apache/openwhisk/commit/96ff327dcce25bdb91b59fd2746d1e3a2979143e, [@bdoyle0182](https://github.com/bdoyle0182))
- add base dependency version to cve remediations for downstream runtime builds (https://github.com/apache/openwhisk/commit/949c513de55c06e8e244a05c57f5d2419eb00466, [@bdoyle0182](https://github.com/bdoyle0182))
- attempt to fix downstream runtime builds (https://github.com/apache/openwhisk/commit/6dd737d628a9e852c2ff2db55ac510d7661b8528, [@bdoyle0182](https://github.com/bdoyle0182))
- dependency updates for cve patches (https://github.com/apache/openwhisk/commit/65a0132e73b41528dcf5b2817a55a579f7900433, [@bdoyle0182](https://github.com/bdoyle0182))
- Bump Newtonsoft.Json (https://github.com/apache/openwhisk/commit/8054f3b4cb53babdbc89911060258f36363afbc0, [@dependabot[bot]](https://github.com/apps/dependabot))
- Docs golang broken markdown link (https://github.com/apache/openwhisk/commit/2358976a5d5f9f42c539a6436b35922c4f8898fa, [@jonasbn](https://github.com/jonasbn))
- update language runtimes to use newer versions (https://github.com/apache/openwhisk/commit/b7c203b8b70f1d5ec39e95287a6cf572fed33f1b, [@dgrove-oss](https://github.com/dgrove-oss))
- dependency updates for cve patches (https://github.com/apache/openwhisk/commit/f0e281e35f90930983fbbbd0da2da3f4b32b4d72, [@bdoyle0182](https://github.com/bdoyle0182))
- fix flaky ActivationClientProxy unit test (https://github.com/apache/openwhisk/commit/ed43b4d1ce0e6ae27c9a4b714be123be5a82fae9, [@bdoyle0182](https://github.com/bdoyle0182))
- rollback logback minor upgrade to latest patch (https://github.com/apache/openwhisk/commit/3ea756f2d9d42463212c192f6a008f7d24e05718, [@bdoyle0182](https://github.com/bdoyle0182))
- upgrade some dependencies for CVE Patches (https://github.com/apache/openwhisk/commit/084c2ad9dbaf1c86b469eb4730b9eb9e7bc6e095, [@bdoyle0182](https://github.com/bdoyle0182))
- make scheduler consider action concurrency >1 (https://github.com/apache/openwhisk/commit/415ae98fd9f1fd44f5ab2dccb8b5cbe2d20932bb, [@bdoyle0182](https://github.com/bdoyle0182))
- remove zookeeper config requirement (https://github.com/apache/openwhisk/commit/9d96c6ded0bcc46076a8be2800fc061d08eb3704, [@bdoyle0182](https://github.com/bdoyle0182))
- add GHA status badges; remove .travis.yml (https://github.com/apache/openwhisk/commit/096dba495dff5eddd95d98159739e155df628040, [@dgrove-oss](https://github.com/dgrove-oss))
- Fix the bug that match does not exhaustive (https://github.com/apache/openwhisk/commit/104c1e8e6cca2194da9a46a721626f4584741f23, [@style95](https://github.com/style95))
- Provide action limit configuration for each namespace (https://github.com/apache/openwhisk/commit/61ca4c8fe39f2b47b84c20a8114f261cd12820d7, [@upgle](https://github.com/upgle))
- Fix typo (https://github.com/apache/openwhisk/commit/4bc4c3b0e1294479dc20fa19389917d0f630a6a6, [@style95](https://github.com/style95))
- schedule actions to run at least 3 times a week (https://github.com/apache/openwhisk/commit/40944e6eef40c39b7e547cd9b7251b72f53fc1ed, [@dgrove-oss](https://github.com/dgrove-oss))
- fixes to use different secrets, show the results in the log (https://github.com/apache/openwhisk/commit/21c9a6363fe14e581ec67da281e1762db02ae557, [@msciabarra](https://github.com/msciabarra))
- GitHub action (https://github.com/apache/openwhisk/commit/f717619c8c25b54294cfa195732732e85c5d9431, [@msciabarra](https://github.com/msciabarra))
- drop travis from required checks to merge a PR (https://github.com/apache/openwhisk/commit/a7ed8b5ef080036b3e7dc18b966f096effd20494, [@dgrove-oss](https://github.com/dgrove-oss))
- Fix missing attachment stuck actions (https://github.com/apache/openwhisk/commit/daeadbf11fb46d0f4471fef8e56c1741e1249ab8, [@bdoyle0182](https://github.com/bdoyle0182))
- Add cors headers to components' server admin routes (https://github.com/apache/openwhisk/commit/85788875d597f4225909479cefbdf403c0d19ff2, [@bdoyle0182](https://github.com/bdoyle0182))
- Handle container cleanup from ActivationClient shutdown gracefully (https://github.com/apache/openwhisk/commit/44791f361d1492e985e9f1bcf3616253c77ed39d, [@style95](https://github.com/style95))
- Add scheduler overprovision for new actions before namespace throttling (https://github.com/apache/openwhisk/commit/077fb6d24f0132e7755ea47d7ee9b35f0966daf3, [@bdoyle0182](https://github.com/bdoyle0182))
- Make the test stable (https://github.com/apache/openwhisk/commit/0f4b0c220e050d408a650a8c5a90fbc54b52768a, [@style95](https://github.com/style95))
- optimize scheduling decision when there are stale activations (https://github.com/apache/openwhisk/commit/07c920249d0a0db5fe3bc603add73e410f40dddd, [@bdoyle0182](https://github.com/bdoyle0182))
- Add zero downtime deployment (https://github.com/apache/openwhisk/commit/651a2e95726f69fb8403c49ce909371521e8986f, [@style95](https://github.com/style95))
- Openwhisk action invocation flow diagram (https://github.com/apache/openwhisk/commit/74ca61c8512f43981b6eaca158edc3749ba2513f, [@Rajiv2605](https://github.com/Rajiv2605))
- Prevent cycle in the QueueManager (https://github.com/apache/openwhisk/commit/ef725a653ab112391f79c274d8e3dcfb915d59a3, [@style95](https://github.com/style95))
- Delete ETCD data first when disabling the invoker (https://github.com/apache/openwhisk/commit/145971b8faedad71a7e07fd398528ff563bbaae5, [@style95](https://github.com/style95))
- Clean Up Etcd Worker Actor (https://github.com/apache/openwhisk/commit/236ca5e4b894e4cc626f685c1d0eba5c3e6077ec, [@bdoyle0182](https://github.com/bdoyle0182))
- Fix minor ansible typos (https://github.com/apache/openwhisk/commit/8d60463db6ee59b77d1f9034755cb1946ed49fdb, [@hunhoffe](https://github.com/hunhoffe))
- change default warmed container keeping count (https://github.com/apache/openwhisk/commit/ff7d578bc6ffe0bb392ca9d741f585ac68a025db, [@bdoyle0182](https://github.com/bdoyle0182))
- Add Function Cache Refresh If Invoker Is Running Container For Function (https://github.com/apache/openwhisk/commit/6effb15ce6f415f8424c0094d67e64078f5c64c1, [@bdoyle0182](https://github.com/bdoyle0182))
- Fix Orphaned Container Edge Case In Paused State of Container Proxy (https://github.com/apache/openwhisk/commit/625c5f2ef64c9cc50da568998199ff623ad01f41, [@bdoyle0182](https://github.com/bdoyle0182))
- add container and creation ids to logs when queue attempts to stop for better debugging (https://github.com/apache/openwhisk/commit/a1639f0e4d7270c9a230190ac26acb61413b6bbb, [@bdoyle0182](https://github.com/bdoyle0182))
- Add note on concurrency limit config (https://github.com/apache/openwhisk/commit/c209a65322e89bdcd85c028192b905a5f2670211, [@davidfrickert](https://github.com/davidfrickert))
- Prepare to integrate new scheduler into apache/openwhisk-deploy-kube (https://github.com/apache/openwhisk/commit/347ff1f3b737d00194ddeda2fb6fefe79c36ec48, [@hunhoffe](https://github.com/hunhoffe))
- add config to fail async scheduler throttles as whisk errors (https://github.com/apache/openwhisk/commit/20a7b1c6ad3c57b583484c1fc12a069da42ad847, [@bdoyle0182](https://github.com/bdoyle0182))
- add error handling to container manager when invoker query fails (https://github.com/apache/openwhisk/commit/138f3d9022610b9d00078db5226e3fd4ec67d64a, [@bdoyle0182](https://github.com/bdoyle0182))
- Revert etcd client version (https://github.com/apache/openwhisk/commit/740c907b5e99b3210a46e936370d703911201862, [@style95](https://github.com/style95))
- Skip scheduling for empty cold creation. (https://github.com/apache/openwhisk/commit/9be427c72680035e852496440a5a8ce4113424c4, [@style95](https://github.com/style95))
- use openwhisk-client-js 3.21.7 (https://github.com/apache/openwhisk/commit/3354314ac8c6b9c6ab2d9f584c8916afc64360a4, [@dgrove-oss](https://github.com/dgrove-oss))
- add config to mask docker run args when logging (https://github.com/apache/openwhisk/commit/6605b5f9187adc84a298a290bfdee914d6c2fe4c, [@bdoyle0182](https://github.com/bdoyle0182))
- bump java etcd client to 0.0.21 (https://github.com/apache/openwhisk/commit/40077664ab3011e7a333b0197fa9a285502a1d81, [@bdoyle0182](https://github.com/bdoyle0182))
- Exclude warmed containers in disabled invokers. (https://github.com/apache/openwhisk/commit/e36b2d8c0cd3ef362ea0f6220d9af0371acd10c2, [@style95](https://github.com/style95))
- Add document for support array result (https://github.com/apache/openwhisk/commit/7de8bad25fbad49b2613c70b12a3abe9b24c857e, [@ningyougang](https://github.com/ningyougang))
- Add fake clock for test code (https://github.com/apache/openwhisk/commit/9005a083cb58735031f36262bb93f580044cad9e, [@upgle](https://github.com/upgle))
- Support backward compatibility for runtime's return type (https://github.com/apache/openwhisk/commit/1a0f1ce74446a30cdb8d06c7526d7405bfe55909, [@upgle](https://github.com/upgle))
- Go to the NamespaceThrottled state rather than Flushing state. (https://github.com/apache/openwhisk/commit/8fd21565a293eb548e6aceddb925cec49bbb6b03, [@style95](https://github.com/style95))
- Adjust the default configurations. (https://github.com/apache/openwhisk/commit/cf127f9cd3fab2102a4797faa6ab044a39d82bd2, [@style95](https://github.com/style95))
- Revert cycle handling. (https://github.com/apache/openwhisk/commit/2683ed1e6f35da5d7f7c586d8f1a14ba11c7d408, [@style95](https://github.com/style95))
- Support array result for common action and sequence action (https://github.com/apache/openwhisk/commit/62b8a50d447c066a4e579ed1d8c85eef02e37e41, [@ningyougang](https://github.com/ningyougang))
- chore: remove duplicate entry from .gitignore (https://github.com/apache/openwhisk/commit/d92485ce7743931cae48ef8fa89da3c10e54fcf4, [@jbampton](https://github.com/jbampton))
- poem for max action container concurrency (https://github.com/apache/openwhisk/commit/a3287924e87cc4cba3cdf878cefbbfbe9c408b50, [@bdoyle0182](https://github.com/bdoyle0182))
- Add missing configurations. (https://github.com/apache/openwhisk/commit/3e5b8b2949bfca87cad417badb2e2a00124d4de8, [@style95](https://github.com/style95))
- This is to make sure activations for a shared action run in an invocation namespace. (https://github.com/apache/openwhisk/commit/44379b87821e8dcec360fc9b465c3977d07b0807, [@style95](https://github.com/style95))
- Bumping to gradle 6 (https://github.com/apache/openwhisk/commit/f29981a2f9961765067340f5ce15a6a616ef9b31, [@upgle](https://github.com/upgle))
- [Proposal] POEM: provide array result for all runtime images (https://github.com/apache/openwhisk/commit/3014b870005a11902fdc70cbe88b10cab8ef67f8, [@ningyougang](https://github.com/ningyougang))
- Do not put data to ETCD when no date is changed. (https://github.com/apache/openwhisk/commit/c507069d1b3983bff20c3d9e306cd3694e6c6a3c, [@style95](https://github.com/style95))
- Adjust error for container creation. (https://github.com/apache/openwhisk/commit/491256530c980fda6457816049db0ec9f2007330, [@style95](https://github.com/style95))
- Change the value of pause-grace for new scheduler (https://github.com/apache/openwhisk/commit/f915acc659b71029f0c74fd848e366d923dbb2d4, [@JesseStutler](https://github.com/JesseStutler))
- Make ElasticSearch ports configurable. (https://github.com/apache/openwhisk/commit/8d0a9b2bb7bdbf01ef5f75c70d64cd2653a793cb, [@style95](https://github.com/style95))
- Update wrong error message "action does not exist". (https://github.com/apache/openwhisk/commit/9bc5e043444d115cec0d79ac47d7002baa522924, [@style95](https://github.com/style95))
- Dedicated Invokers (https://github.com/apache/openwhisk/commit/8c140e0d5baec8e760832ca98d8bcc66664a0146, [@style95](https://github.com/style95))
- Add tags to invokers. (https://github.com/apache/openwhisk/commit/d55d8fe86332c9996ccbb421233f60da2c70192f, [@style95](https://github.com/style95))
- Support graceful shutdown. (https://github.com/apache/openwhisk/commit/a03507ceeb2c4648c875ed68273de1448ec0d074, [@style95](https://github.com/style95))
- Add a documentation for warmed containers configurations. (https://github.com/apache/openwhisk/commit/1fbfd6bcb3d65845a328382641c1db7182763ced, [@style95](https://github.com/style95))
- Retry on any errors. (https://github.com/apache/openwhisk/commit/4a69be20cda806680d181666c8126333b31c90ca, [@style95](https://github.com/style95))
- Increase the payload limit. (https://github.com/apache/openwhisk/commit/53b23524e7b8d6c44a2cf103cda1d577d8d2144a, [@style95](https://github.com/style95))
- Add retry to store activations. (https://github.com/apache/openwhisk/commit/814b7fabafa21d5580271149407f91af432953aa, [@style95](https://github.com/style95))
- Upgrade the Kubernetes client version. (https://github.com/apache/openwhisk/commit/1a8364dcb7e1b24cb79e463a9f54d82cefad832f, [@style95](https://github.com/style95))
- Forward header from a trigger to actions. (https://github.com/apache/openwhisk/commit/7c5a5d6964a62deb931445684bab0b0524a9ad64, [@style95](https://github.com/style95))
- Fail all activations when it fails to pull a blackbox image. (https://github.com/apache/openwhisk/commit/f03cbcc4ab6ff2d041b5e83b243b48afa4c81381, [@style95](https://github.com/style95))
- Fix scheduler inProgressDuration parsing (https://github.com/apache/openwhisk/commit/4016aa803ee84b849db8a907cbd17a41cc374e7a, [@hunhoffe](https://github.com/hunhoffe))
- [Scheduler Enhancement] Increase the retention timeout for the blackbox action. (https://github.com/apache/openwhisk/commit/8d31e96e1a321987f9f5c3b7289ba83bf4eebff6, [@style95](https://github.com/style95))
- Make proxy timeouts configurable. (https://github.com/apache/openwhisk/commit/a7fecfb6939b1b32fec84ccac7291a838b2d61c7, [@style95](https://github.com/style95))
- Add test cases to make sure an invoker properly boots up in terms of ETCD keys. (https://github.com/apache/openwhisk/commit/2363295909de5c872e61a6c9a721d80653d1f2df, [@style95](https://github.com/style95))
- Consider binding action when creating or recovering queue. (https://github.com/apache/openwhisk/commit/c66486e7038e1d334b9b50aff31ff9d00d50b566, [@style95](https://github.com/style95))
- add support for etcd client authentication (https://github.com/apache/openwhisk/commit/639c4a914bd0b7f31509349c3c8b3566e027dab3, [@bdoyle0182](https://github.com/bdoyle0182))
- [Scheduler Enhancement] Remove deleted containers. (https://github.com/apache/openwhisk/commit/88435790cbed79db3f887c1918599cb9dead2590, [@style95](https://github.com/style95))
- Update npm version for ow-utils docker (https://github.com/apache/openwhisk/commit/c5970a657a3070e9964cb14715b9df31819d3b75, [@hugy718](https://github.com/hugy718))
- rework scheduler wait time metric (https://github.com/apache/openwhisk/commit/052d4d21889b38808f96958f553eeaa73947a553, [@bdoyle0182](https://github.com/bdoyle0182))
- Remove containers gradually when disable invoker (https://github.com/apache/openwhisk/commit/80de54e1fce7c900d694ec4427ec8730a0432697, [@jiangpengcheng](https://github.com/jiangpengcheng))
- fix scheduling config loading wrong config (https://github.com/apache/openwhisk/commit/21b03a57019d9cc3ba80917534edbd4bb19b607a, [@bdoyle0182](https://github.com/bdoyle0182))
- Prevent cycle sending (https://github.com/apache/openwhisk/commit/a75950a543b83ffbd7753f128855556198ee155d, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Introduce scheduling configurations. (https://github.com/apache/openwhisk/commit/4ef94d727cdc90a772946330de3837649936a5db, [@style95](https://github.com/style95))
- Use pureconfig for invoker/scheduler's basic http auth (https://github.com/apache/openwhisk/commit/0c4aab1bd57bc4b8eb1e0e968b714e6447aeabea, [@jiangpengcheng](https://github.com/jiangpengcheng))
- refresh runtime versions for nodejs and golang (https://github.com/apache/openwhisk/commit/1e09049aaf32e595d13a67ead2cec583a3b1809d, [@dgrove-oss](https://github.com/dgrove-oss))
- Fix missing keystroke in requirements (https://github.com/apache/openwhisk/commit/f71c41c04e240fdfb47e9534f367ad6c7b2c434c, [@Blucknote](https://github.com/Blucknote))
- Add containerPool container histogram metric (https://github.com/apache/openwhisk/commit/1a6c99df42dd190d897b6806c008d5b2cdd5a4e5, [@ningyougang](https://github.com/ningyougang))
- Add missing configuration for scheduler (https://github.com/apache/openwhisk/commit/6731f1c996b8ea5e913d8bc81ceb7de87e4e8c02, [@upgle](https://github.com/upgle))
- fix perMin throttle config for fpc (https://github.com/apache/openwhisk/commit/4b595e00960200516023592e0135dac7550c3d7e, [@bdoyle0182](https://github.com/bdoyle0182))
- update action container metrics subactions to action instead of namespace (https://github.com/apache/openwhisk/commit/57be429ed28d93167472ac3b1bc0f670498cddfb, [@bdoyle0182](https://github.com/bdoyle0182))
- Add some testcases and missing ASF headers for new scheduler (https://github.com/apache/openwhisk/commit/c90e8ccbc6e49bebc4bf9d641bd8aee0085cc805, [@jiangpengcheng](https://github.com/jiangpengcheng))
- [Proposal] POEM: Providing action limits for each namespace (https://github.com/apache/openwhisk/commit/edc484b373f0c18a6555f50cbcff095cda09d3ca, [@upgle](https://github.com/upgle))
- add per min throttling support to fpc (https://github.com/apache/openwhisk/commit/0912c73a4bf00caa448d6aea726fbf255b7a187e, [@bdoyle0182](https://github.com/bdoyle0182))
- add fpc load balancer metrics (https://github.com/apache/openwhisk/commit/426aef484d31f863c3345e321f7f39ee4c23b88a, [@bdoyle0182](https://github.com/bdoyle0182))
- Take revision into consideration when choose warm container (https://github.com/apache/openwhisk/commit/7fdc246137162e937e54435e1f27d8d95e8e89d5, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Fix wrong returned type when reschedule activation msg (https://github.com/apache/openwhisk/commit/23be3351d3db6d62d14ed69b85afdc71e7ffb4a4, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Use a template for swagger code generating (https://github.com/apache/openwhisk/commit/d88a7d2be8399bea7e55910ed225777d90d8fb9f, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Use testcontainers to test MongoDB stuff (https://github.com/apache/openwhisk/commit/674704eab8aa56d86b13b452e627511f22c3ca06, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Replace kafka.RecordMetadata with a common ResultMetadata (https://github.com/apache/openwhisk/commit/cbdcfe574984b6509335da64da86f80d592aaa1e, [@jiangpengcheng](https://github.com/jiangpengcheng))
- send old version memoryQueue's stale activation to queueManager when update action (https://github.com/apache/openwhisk/commit/37f1f9918906ee938ec30e4442f1b9910d5c5c5d, [@ningyougang](https://github.com/ningyougang))
- Update Ansible scheduler instructions (https://github.com/apache/openwhisk/commit/33cfb36a326f4cdc621cdd33d4b4265e3cb090cb, [@hunhoffe](https://github.com/hunhoffe))
- Fix path error (https://github.com/apache/openwhisk/commit/9a39c10cbf820265b99c3135193ee5709248bbfa, [@hunhoffe](https://github.com/hunhoffe))
- Adjust the keeping duration. (https://github.com/apache/openwhisk/commit/3e3414ced7fb6e6d85b95f0f9cdd43a0a68da4fd, [@style95](https://github.com/style95))
- Fix new scheduler error (https://github.com/apache/openwhisk/commit/b0a88b5b523b1867038b0d2615fc2cf7b4951972, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Update ansible with new scheduler instructions (https://github.com/apache/openwhisk/commit/829e734c759e8cf188e30c22d7f96f69ebfb1a97, [@hunhoffe](https://github.com/hunhoffe))
- add enable/disable invoker support to old scheduler (https://github.com/apache/openwhisk/commit/3b6d07a18cec3e92ceb5c54558464d1bfdbc0f82, [@bdoyle0182](https://github.com/bdoyle0182))
- [New Scheduler] Run scheduler (https://github.com/apache/openwhisk/commit/5332e6de625c4df9b717e067a5369ee446e2fda1, [@style95](https://github.com/style95))
- add system config options for success / failure levels to write blocking / non-blocking activations to db (https://github.com/apache/openwhisk/commit/8be150577a12c54867d99f0dd82a74e9647863c0, [@bdoyle0182](https://github.com/bdoyle0182))
- [New Scheduler] Implement FPCInvokerReactive (https://github.com/apache/openwhisk/commit/e172168fc5a55ba0c8443adbc91629291a1ca321, [@ningyougang](https://github.com/ningyougang))
- Update main method of the scheduler. (https://github.com/apache/openwhisk/commit/d9394f4e04f68359985df5654f7e0f11686b6741, [@style95](https://github.com/style95))
- Add FPC Load Balancer (https://github.com/apache/openwhisk/commit/b1ccbec1fd0b88d5277c8ca601f2b257b26c19da, [@style95](https://github.com/style95))
- Fix links in Issue and PR Template (https://github.com/apache/openwhisk/commit/96330437d63b5291a020d8a2ba1b401f2cc84ab5, [@klcodanr](https://github.com/klcodanr))
- docker creds in build-specific directory (https://github.com/apache/openwhisk/commit/af11418df942e8d2cdc4c4ce933645fa723e9e45, [@dgrove-oss](https://github.com/dgrove-oss))
- Update README.md (https://github.com/apache/openwhisk/commit/285f9d4afcc429d63baa1943a69bb64097b059dd, [@dgrove-oss](https://github.com/dgrove-oss))
- Reflect decision to drop support for runtime-ballerina (https://github.com/apache/openwhisk/commit/ac332ea7ce756fdb95284bc48b2b335c5ee92684, [@dgrove-oss](https://github.com/dgrove-oss))
- finish/failed uncompleted transaction (https://github.com/apache/openwhisk/commit/3753daf0e0c3d237c05ff4668e2f4c5f45d7dcb9, [@jiangpengcheng](https://github.com/jiangpengcheng))
- remove swift:4.2 (https://github.com/apache/openwhisk/commit/eacbe1a3d63539bcc9aa3a6c57cdcabc302b92cd, [@dgrove-oss](https://github.com/dgrove-oss))
- [New Scheduler] Add memory queue for the new scheduler (https://github.com/apache/openwhisk/commit/cf36299d5ee45aa014ec84326d3a69f5b2df446c, [@style95](https://github.com/style95))
- Accept non-standard status codes. (https://github.com/apache/openwhisk/commit/7e1caaa42fb485cefea799ed6835adada1461d7f, [@rabbah](https://github.com/rabbah))
- upgrade to nginx 1.21.1 (https://github.com/apache/openwhisk/commit/cbe53b199a36c5c2a288e249aa84690e2066abdc, [@dgrove-oss](https://github.com/dgrove-oss))
- minor version bump of azure-storage-blob to fix builds (https://github.com/apache/openwhisk/commit/3e6138d088fbd502a69c31314ad7c0089c5f5283, [@dgrove-oss](https://github.com/dgrove-oss))
- update name for Python 3 image (https://github.com/apache/openwhisk/commit/209dc44cc8d8fd46e5ac56a869ca7dd58ad9f616, [@dgrove-oss](https://github.com/dgrove-oss))
- remove previously deprecated nodejs:10 and go:1.11 kinds (https://github.com/apache/openwhisk/commit/91e3f28cd010d5410a78e6514d630cb1f6b63cee, [@dgrove-oss](https://github.com/dgrove-oss))
- cleanup: remove obsolete mesos configuration (https://github.com/apache/openwhisk/commit/a99b0a8acaeb03a7e65965549bbdd12a9c13e78f, [@dgrove-oss](https://github.com/dgrove-oss))
- don't log a uuid of the username portion of basic auth info (https://github.com/apache/openwhisk/commit/4e25ada99c00875564c4e5aa51677b20d67afd66, [@dgrove-oss](https://github.com/dgrove-oss))
- modules.md: travis-ci.org -> travis-ci.com migration (https://github.com/apache/openwhisk/commit/bf62f740057f5210ff05582d119fd692fb6c6341, [@dgrove-oss](https://github.com/dgrove-oss))
- Disable StandaloneKCFTests (https://github.com/apache/openwhisk/commit/67a80c3378e53d9bf967e3f0c3dcf10d55aa6ee7, [@dgrove-oss](https://github.com/dgrove-oss))
- [New Scheduler] Manage memory queues in scheduler (https://github.com/apache/openwhisk/commit/0cdfdb3ecb20fbff11e401c34143fe0e8ff61f83, [@KeonHee](https://github.com/KeonHee))
- Remove Mesos container factory. (https://github.com/apache/openwhisk/commit/dc7c66678308f72d219464ca723a7a997c66568a, [@rabbah](https://github.com/rabbah))
- Fix ansible README (https://github.com/apache/openwhisk/commit/11a1f33c4e5f2bc7c97584fc889c8dcaaf5e1a43, [@ryutoyasugi](https://github.com/ryutoyasugi))
- Docs update for local dev (https://github.com/apache/openwhisk/commit/afe39860eb456b8d32bdd68ed724967aefca72c5, [@ddragosd](https://github.com/ddragosd))
- update to openwhisk-client-js 3.21.4 (https://github.com/apache/openwhisk/commit/58b218340b1070e153ba6ed8cf7a51c2a1a9b1de, [@dgrove-oss](https://github.com/dgrove-oss))
- update modules.md to move deploy-mesos and external-resources to inactive (https://github.com/apache/openwhisk/commit/184a926a93c340688558eb86c9c49d4edb1dbfdf, [@dgrove-oss](https://github.com/dgrove-oss))
- Fix deprecated error (https://github.com/apache/openwhisk/commit/20417de0e73b8c15f162c20efb66d2df027dcfa4, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Implement MongoDBArtifactStore (https://github.com/apache/openwhisk/commit/927962692e45fc7276ccb7902fd3a111daa54885, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Fix build error (https://github.com/apache/openwhisk/commit/e65f899ca5ce95d1aadd8f1b244a2cb80bbd35f4, [@ningyougang](https://github.com/ningyougang))
- Implement ActivationClientProxy (https://github.com/apache/openwhisk/commit/99fb2c59e264d820d6b95a6319b7882f19aead4d, [@ningyougang](https://github.com/ningyougang))
- [New Scheduler]Add CreationJobManager (https://github.com/apache/openwhisk/commit/71585f130df31b74733ef6c4652a6779aaa679ab, [@jiangpengcheng](https://github.com/jiangpengcheng))
- #5060: Upgrade to Akka 2.6.12 (https://github.com/apache/openwhisk/commit/7791e4b97c0918205bc957f59f859af5ad51edcd, [@vrann](https://github.com/vrann))
- Update the notice year (https://github.com/apache/openwhisk/commit/ecb2a980659f28d0adbd9ef837afaf4cb2b695bf, [@style95](https://github.com/style95))
- [New Scheduler] Implement FunctionPullingContainerProxy (https://github.com/apache/openwhisk/commit/0b2d2ab0103b92b57bda64a37277788fa89171f0, [@ningyougang](https://github.com/ningyougang))
- #5120: Unit Tests failing due to testcontainers (https://github.com/apache/openwhisk/commit/4ec5d966e5b80babdce35effe0ca13729fa056a8, [@vrann](https://github.com/vrann))
- Document for prewarmed container (https://github.com/apache/openwhisk/commit/661ddc5e3657fe9b9be21f18e5ef9bafe7ba7aec, [@ningyougang](https://github.com/ningyougang))
- [New Scheduler] Add container message consumer (https://github.com/apache/openwhisk/commit/b818c3b3e8bd3fa9ac7742d1b8c051ec09b76ae2, [@upgle](https://github.com/upgle))
- [New Scheduler] Manage container creation (https://github.com/apache/openwhisk/commit/f1829e1160d0aca51fc3ff93a77621c488b148ad, [@KeonHee](https://github.com/KeonHee))
- refresh module list (https://github.com/apache/openwhisk/commit/9c445f372f4e504acdd97fa20d046692fe61294d, [@dgrove-oss](https://github.com/dgrove-oss))
- increase default totalWait when getting an activation (https://github.com/apache/openwhisk/commit/1a0bf9fe027665b839d11f81b9ee7afe11a67ad3, [@dgrove-oss](https://github.com/dgrove-oss))
- prefetch openwhisk/example to avoid timeout during test execution (https://github.com/apache/openwhisk/commit/bb7192e90a046c5aaad9785fdd4ec6591ab78909, [@dgrove-oss](https://github.com/dgrove-oss))
- deprecate nodejs:10 kind (https://github.com/apache/openwhisk/commit/64cd96438374a5ad0e71582aeaae26490f8cdd22, [@dgrove-oss](https://github.com/dgrove-oss))
- [New Scheduler] Implement FunctionPullingContainerPool (https://github.com/apache/openwhisk/commit/3802374d58d87fc6a95477929fc67269d6dcfe2c, [@ningyougang](https://github.com/ningyougang))
- Add prefix for topics (https://github.com/apache/openwhisk/commit/aa7e6e2af196ac017ae4b9ea36656bec868a9931, [@ningyougang](https://github.com/ningyougang))
- [New Scheduler]Implement PFCInvokerServer (https://github.com/apache/openwhisk/commit/e036fc9823b8e015a88e1a44d3f282698ae62fe7, [@ningyougang](https://github.com/ningyougang))
- attempt to hack around docker rate limiting during tests (https://github.com/apache/openwhisk/commit/87c8a98869399fb0842eb81638ed0e04d12c3e6b, [@dgrove-oss](https://github.com/dgrove-oss))
- change default nodejs kind from nodejs:10 to nodejs:14 (https://github.com/apache/openwhisk/commit/8bbcd517aac827d073b40b6c55a1e1645272ad68, [@dgrove-oss](https://github.com/dgrove-oss))
- Make kafka version configurable (https://github.com/apache/openwhisk/commit/df1970b92d8422af29676d81f0d0e59a96bb55a3, [@ningyougang](https://github.com/ningyougang))
- update default python3 image name (https://github.com/apache/openwhisk/commit/f7ec9e30d2de3f0c3252e32b300d4aa7412b15bf, [@dgrove-oss](https://github.com/dgrove-oss))
- Updated Kamon bundle dependencies to 2.1.12 version (https://github.com/apache/openwhisk/commit/a201e02bfd0949f40fd12cf0b8c94b9c17956def, [@joni-jones](https://github.com/joni-jones))
- [New Scheduler] Add ActivationService (https://github.com/apache/openwhisk/commit/cd6fded8a6836756cbfbe4159064c85683b64cd7, [@upgle](https://github.com/upgle))
- Quote ansible default value. (https://github.com/apache/openwhisk/commit/6e5850f52dd965e6fafaccb39d28c37854571463, [@rabbah](https://github.com/rabbah))
- Fixed link for Ansible (https://github.com/apache/openwhisk/commit/d741c8767dac386a4cf9efd64a37591e554b02f5, [@ishaanthakur](https://github.com/ishaanthakur))
- Implement InvokerHealthyManager (https://github.com/apache/openwhisk/commit/59b67fe96f44e573f3348afed966a1cdaf80ddf2, [@ningyougang](https://github.com/ningyougang))
- [New Scheduler] Add DataManagementService (https://github.com/apache/openwhisk/commit/ecb15098caded058ddb6976c630f5b6dcd656177, [@style95](https://github.com/style95))
- fix: update Homebrew commands (https://github.com/apache/openwhisk/commit/625fc5b7593360bc01e74147c02ce5f1461b5cd3, [@jbampton](https://github.com/jbampton))
- Change up travis URL. (https://github.com/apache/openwhisk/commit/659b76207e99b842874a83b2abf1bd18fc208715, [@rabbah](https://github.com/rabbah))
- configure more github properties via asf.yaml (https://github.com/apache/openwhisk/commit/2ce44b394d01627f93c1d6efcbfeec77340bcd72, [@dgrove-oss](https://github.com/dgrove-oss))
- fix: Python 3 urlencode (https://github.com/apache/openwhisk/commit/aa023d839f509e0557e7e1394830dd4377221bbc, [@jbampton](https://github.com/jbampton))
- [New Scheduler] Add container counter (https://github.com/apache/openwhisk/commit/f9e469e50aac5a345a010e2bf1f71596f1b101fc, [@jiangpengcheng](https://github.com/jiangpengcheng))
- [New Scheduler] Implement KeepAliveService (https://github.com/apache/openwhisk/commit/e05aa44b0cab519c82cf84a8171671a21d779562, [@KeonHee](https://github.com/KeonHee))
- chore: fix spelling (https://github.com/apache/openwhisk/commit/cc9bc49b75b5bed0e906cbf68d3c17ce84958a4b, [@jbampton](https://github.com/jbampton))
- Make cache expiration time configurable (https://github.com/apache/openwhisk/commit/00642f737708cdbb82bd88cb74c4bdb109f4b6b0, [@fe-lix-](https://github.com/fe-lix-))
- Add php:8.0 kind (https://github.com/apache/openwhisk/commit/d8cf17247bbcd8c1250873254d0c213fa28116ce, [@akrabat](https://github.com/akrabat))
- [New Scheduler] Add a centralized watcher for etcd data (https://github.com/apache/openwhisk/commit/ed58b233d2848cad2d452a4d71b704764fb001b6, [@jiangpengcheng](https://github.com/jiangpengcheng))
- [New Scheduler] CI for testing related new scheduler (https://github.com/apache/openwhisk/commit/4a13303fae4d9750da6662bb39b3ec92d6ccf56c, [@KeonHee](https://github.com/KeonHee))
- update unicode test dat files for runtime language levels (https://github.com/apache/openwhisk/commit/4d88ca782795b995591b4f3c0e44d61b76005232, [@dgrove-oss](https://github.com/dgrove-oss))
- remove deprecated python:2 kind (https://github.com/apache/openwhisk/commit/3c80842d09409d0c16b8fe3e732fd9de4980ab42, [@dgrove-oss](https://github.com/dgrove-oss))
- [New Scheduler] Etcd installation & Implements EtcdClient (https://github.com/apache/openwhisk/commit/5eda22171a238e933121b3918c5940e37fb009c5, [@KeonHee](https://github.com/KeonHee))
- Implement FCPSchedulerServer (https://github.com/apache/openwhisk/commit/1753946ac16b91b2d2a3fc55ab215b14e71c2b39, [@ningyougang](https://github.com/ningyougang))
- format: format the invoker's Dockerfile (https://github.com/apache/openwhisk/commit/faae555e583fb8a1b83e2b30840bf0610cbde00b, [@ZinuoCai](https://github.com/ZinuoCai))
- Don't create prewarm container when used memory reaches the limit (https://github.com/apache/openwhisk/commit/c6e32b12ba2269e2aa4612ccb549764b9ffc3766, [@ningyougang](https://github.com/ningyougang))
- [New Scheduler]Implement FPCEntitlementProvider (https://github.com/apache/openwhisk/commit/efdbd6049a849eb432e1c3fffc56bdb3fd344eaf, [@jiangpengcheng](https://github.com/jiangpengcheng))
- Fix wsk action create command in Rust example (https://github.com/apache/openwhisk/commit/212d809303c984d55839090299f98cf58aed7378, [@kingledion](https://github.com/kingledion))
- Fixes bug in invoker supervision on startup. (https://github.com/apache/openwhisk/commit/66868205b52ee65f28756038c44d8df5b96d2bcc, [@rabbah](https://github.com/rabbah))
- Python 3 fixes. (https://github.com/apache/openwhisk/commit/9d08977cc6bc831e5e9ea9a8d869d2f9c37d3efa, [@rabbah](https://github.com/rabbah))
- Use focal release for travis ci (https://github.com/apache/openwhisk/commit/5a847e3c71c27707776e6d9d135bbb78e8275e5a, [@jiangpengcheng](https://github.com/jiangpengcheng))
- [New Scheduler] Add duration checker (https://github.com/apache/openwhisk/commit/a6ad9e418e605894c5e96e5601c3e1b8ded4166a, [@style95](https://github.com/style95))
- take prewarmed container's memory as used memory (https://github.com/apache/openwhisk/commit/b0baa7b3c2aeff56fda0b826749e25df7067242a, [@ningyougang](https://github.com/ningyougang))
- Fix heisenbug (https://github.com/apache/openwhisk/commit/2d0c8a72711cf20da4aedb8ada68d62774c0eca9, [@style95](https://github.com/style95))
- Migrate the Travis configuration to travis-ci.com (https://github.com/apache/openwhisk/commit/a2025382fa4dbd8ce448b037b14a54d818a224ca, [@style95](https://github.com/style95))
- Copy jmx files instead of moving to support k8s (https://github.com/apache/openwhisk/commit/6254477d5f95ee8d693e16daf52e9b1938f87b59, [@upgle](https://github.com/upgle))
- Make runtime delete timeout configurable (https://github.com/apache/openwhisk/commit/4babe39fd2dbcc900ccedb5a5e9561d301361205, [@ningyougang](https://github.com/ningyougang))
- Reset / Overwrite invokerId for unique name in zookeeper manually (https://github.com/apache/openwhisk/commit/526f0119ef9e89336b76c483e32c8dad75bfcdb4, [@bdoyle0182](https://github.com/bdoyle0182))
- Hide version in fallback activation's path (https://github.com/apache/openwhisk/commit/12ca4e307e3b095a266352b7b12cf5ddaeb44577, [@upgle](https://github.com/upgle))
- [New Scheduler] Initial commit for the scheduler component (https://github.com/apache/openwhisk/commit/7b99af975eb77fa00ac71ecf3f0c27e74a3ca8b4, [@style95](https://github.com/style95))
- bump openwhisk-client-js to 3.21.3 (https://github.com/apache/openwhisk/commit/cb1645052dab33d18e5d0c059df6d1ef7ce3a6de, [@dgrove-oss](https://github.com/dgrove-oss))
- re-fix: fix: add new Windows docker.exe location (https://github.com/apache/openwhisk/commit/6feda87956c0043339f59063b341d5afdeff632a, [@shazron](https://github.com/shazron))
- add swift:5.3 kind and change default from swift:4.2 to swift:5.3 (https://github.com/apache/openwhisk/commit/f18e9d5647360eb8401fdb7f9c2605a27369c776, [@dgrove-oss](https://github.com/dgrove-oss))

## Apache 1.0.0
### Branch: [1.0.0](https://github.com/apache/openwhisk/tree/1.0.0)
### Notable changes
- Improvements to parameter encryption to support per-namespace keys. ([#4855](https://github.com/apache/openwhisk/pull/4855), [@rabbah](https://github.com/rabbah))
- Use latest code if action's revision is mismatched. ([#4954](https://github.com/apache/openwhisk/pull/4954), [@upgle](https://github.com/upgle))
- Do not delete previous annotation and support delete annotation via CLI. ([#4940](https://github.com/apache/openwhisk/pull/4940), [@ningyougang](https://github.com/ningyougang))
- Prewarm eviction variance. ([#4916](https://github.com/apache/openwhisk/pull/4916), [@tysonnorris](https://github.com/tysonnorris))
- Allow to get activation list by a binding package name. ([#4919](https://github.com/apache/openwhisk/pull/4919), [@upgle](https://github.com/upgle))
- Allow parent/child transaction ids. ([#4819](https://github.com/apache/openwhisk/pull/4819), [@upgle](https://github.com/upgle))
- Adjust prewarm container dynamically. ([#4871](https://github.com/apache/openwhisk/pull/4871), [@ningyougang](https://github.com/ningyougang))
- Add NodeJS 14 runtime. ([#4902](https://github.com/apache/openwhisk/pull/4902), [@rabbah](https://github.com/rabbah))
- Create AES128 and AES256 encryption for parameters. ([#4756](https://github.com/apache/openwhisk/pull/4756), [@mcdan](https://github.com/mcdan))
- Implement an ElasticSearchActivationStore. ([#4724](https://github.com/apache/openwhisk/pull/4724), [@jiangpengcheng](https://github.com/jiangpengcheng))
- Add Swift 5.1 runtime to runtimes.json. ([#4803](https://github.com/apache/openwhisk/pull/4803), [@dgrove-oss](https://github.com/dgrove-oss))
- Add volume mapping for Docker credentials. ([#4791](https://github.com/apache/openwhisk/pull/4791), [@style95](https://github.com/style95))
- add .NET Core 3.1 runtime kind. ([#4792](https://github.com/apache/openwhisk/pull/4792), [@dgrove-oss](https://github.com/dgrove-oss))
- Add PHP 7.4 runtime. ([#4767](https://github.com/apache/openwhisk/pull/4767), [@akrabat](https://github.com/akrabat))
- Serialize `updated` value of entity document in response. ([#4646](https://github.com/apache/openwhisk/pull/4646), [@upgle](https://github.com/upgle))
- Provide environment at init time. ([#4722](https://github.com/apache/openwhisk/pull/4722), [@upgle](https://github.com/upgle))
- OpenWhisk User Events. ([#4584](https://github.com/apache/openwhisk/pull/4584), [@selfxp](https://github.com/selfxp))
- Openwhisk in a standalone runnable jar. ([#4516](https://github.com/apache/openwhisk/pull/4516), [@chetanmeh](https://github.com/chetanmeh))
- Update Docker client version to 18.06.3. ([#4430](https://github.com/apache/openwhisk/pull/4430), [@style95](https://github.com/style95))
- Add `binding` annotation to record an action path not resolved. ([#4211](https://github.com/apache/openwhisk/pull/4211), [@upgle](https://github.com/upgle))
- Add SPI for invoker. ([#4453](https://github.com/apache/openwhisk/pull/4453), [@style95](https://github.com/style95))
- Enable CouchDB persist_path in a distributed environment as well. ([#4290](https://github.com/apache/openwhisk/pull/4290), [@style95](https://github.com/style95))
- Feature flag to turn on/off support for provide-api-key annotation. ([#4334](https://github.com/apache/openwhisk/pull/4334), [@chetanmeh](https://github.com/chetanmeh))
- Add annotations to inject the API key into the action context. ([#4284](https://github.com/apache/openwhisk/pull/4284), [@rabbah](https://github.com/rabbah))
- Update CosmosDB to 2.4.2. ([#4321](https://github.com/apache/openwhisk/pull/4321), [@chetanmeh](https://github.com/chetanmeh))
- Adding YARNContainerFactory. ([#4129](https://github.com/apache/openwhisk/pull/4129), [@SamHjelmfelt](https://github.com/SamHjelmfelt))
- Allow persisted CouchDB directory mount. ([#4250](https://github.com/apache/openwhisk/pull/4250), [@rabbah](https://github.com/rabbah))
- Bump ephemeral CouchDB to v2.3. ([#4202](https://github.com/apache/openwhisk/pull/4202), [@jonpspri](https://github.com/jonpspri))
- Add Ballerina 0.990.2 runtime. ([#4239](https://github.com/apache/openwhisk/pull/4239), [@rabbah](https://github.com/rabbah))
- Add Swift 4.2 runtime in default deployment. ([#4210](https://github.com/apache/openwhisk/pull/4210), [@csantanapr](https://github.com/csantanapr))
- Add PHP 7.3 runtime. ([#4182](https://github.com/apache/openwhisk/pull/4182), [@akrabat](https://github.com/akrabat))
- Add .NET Core 2.2 runtime. ([#4172](https://github.com/apache/openwhisk/pull/4172), [@shawnallen85](https://github.com/shawnallen85))
- Updated Intellij script to start controller and invoker locally. ([#4142](https://github.com/apache/openwhisk/pull/4142), [@ddragosd](https://github.com/ddragosd))
- Ensure ResultMessage is processed. ([#4135](https://github.com/apache/openwhisk/pull/4135), [@jiangpengcheng](https://github.com/jiangpengcheng))
- Protect Package Bindings from containing circular references. ([#4122](https://github.com/apache/openwhisk/pull/4122), [@asteed](https://github.com/asteed))
- Ensure, that Result-ack is sent before Completion-ack. ([#4115](https://github.com/apache/openwhisk/pull/4115), [@cbickel](https://github.com/cbickel))
- Add NodeJS 10 runtime to default set of runtimes for ansible/vagrant. ([#4124](https://github.com/apache/openwhisk/pull/4124), [@csantanapr](https://github.com/csantanapr))
- Enable concurrent activation processing. ([#2795](https://github.com/apache/openwhisk/pull/2795), [@tysonnorris](https://github.com/tysonnorris))
- Rename the package from whisk to org.apache.openwhisk. ([#4073](https://github.com/apache/openwhisk/pull/4073), [@houshengbo](https://github.com/houshengbo))
- Allow web actions from package bindings. ([#3880](https://github.com/apache/openwhisk/pull/3880), [@upgle](https://github.com/upgle))
- Switch to Scala 2.12.7 ([#4062](https://github.com/apache/openwhisk/pull/4062), [@chetanmeh](https://github.com/chetanmeh))
- Always return activation without logs on blocking invoke. ([#4100](https://github.com/apache/openwhisk/pull/4100), [@cbickel](https://github.com/cbickel))
- Changes to include Go runtime. ([#4093](https://github.com/apache/openwhisk/pull/4093), [@sciabarracom](https://github.com/sciabarracom))
- Send active-ack after log collection for non-blocking activations. ([#4041](https://github.com/apache/openwhisk/pull/4041), [@cbickel](https://github.com/cbickel))
- Increase max-content-length to 50 MB. ([#4059](https://github.com/apache/openwhisk/pull/4059), [@chetanmeh](https://github.com/chetanmeh))
- Using non-root user in controller. ([#3579](https://github.com/apache/openwhisk/pull/3579), [@Himavanth](https://github.com/Himavanth))
- Customize invoker user memory for memory based load-balancing. ([#4011](https://github.com/apache/openwhisk/pull/4011), [@ningyougang](https://github.com/ningyougang))
- Secure the invoker with SSL. ([#3968](https://github.com/apache/openwhisk/pull/3968), [@cbickel](https://github.com/cbickel))
- Reuse a container on `applicationError`. ([#3941](https://github.com/apache/openwhisk/pull/3941), [@tysonnorris](https://github.com/tysonnorris))
- Memory based load-balancing ([#3747](https://github.com/apache/openwhisk/pull/3747), [@cbickel](https://github.com/cbickel))
- Activation ID in header. ([#3671](https://github.com/apache/openwhisk/pull/3671), [@style95](https://github.com/style95))
- Treat action code as attachments. ([#3945](https://github.com/apache/openwhisk/pull/3945), [@chetanmeh](https://github.com/chetanmeh))
- K8S: Implement invoker-node affinity and eliminate usage of kubectl. ([#3963](https://github.com/apache/openwhisk/pull/3963), [@dgrove-oss](https://github.com/dgrove-oss))
- Add Ruby 2.5 runtime support. ([#3725](https://github.com/apache/openwhisk/pull/3725), [@remore](https://github.com/remore))
- S3AttachmentStore. ([#3779](https://github.com/apache/openwhisk/pull/3779), [@chetanmeh](https://github.com/chetanmeh))
- ContainerClient + Akka HTTP alternative to HttpUtils. ([#3812](https://github.com/apache/openwhisk/pull/3812), [@tysonnorris](https://github.com/tysonnorris))
- Throttle the system based on active-ack timeouts. ([#3875](https://github.com/apache/openwhisk/pull/3875), [@markusthoemmes](https://github.com/markusthoemmes))
- Recover image pulls by trying to run the container anyways. ([#3813](https://github.com/apache/openwhisk/pull/3813), [@markusthoemmes](https://github.com/markusthoemmes))
- Use separate DB users for deployed components. ([#3876](https://github.com/apache/openwhisk/pull/3876), [@cbickel](https://github.com/cbickel))
- Introduce SPI to swap authentication directives. ([#3829](https://github.com/apache/openwhisk/pull/3829), [@mhenke1](https://github.com/mhenke1))
- ArtifactStore implementation for CosmosDB. ([#3562](https://github.com/apache/openwhisk/pull/3562), [@chetanmeh](https://github.com/chetanmeh))
- Add support for PHP 7.2 runtime. ([#3736](https://github.com/apache/openwhisk/pull/3736), [@akrabat](https://github.com/akrabat))

## Incubating 0.9.0
### Branch: [0.9.0-incubating](https://github.com/apache/openwhisk/tree/0.9.0-incubating)
### Notable changes
- Initial release.
