<!--
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
-->
<!--
DO NOT EDIT.
This page is generated via script `./gradlew :tools:dev:renderModuleDetails`. See tools/dev/README.md for details.
-->

# Modules


## Main

| Module | Description | Module Status |
|---	|---	|---    |
| [openwhisk](https://github.com/apache/openwhisk) | Apache OpenWhisk is an open source serverless cloud platform | [![Build Status](https://travis-ci.com/apache/openwhisk.svg?branch=master)](https://travis-ci.com/apache/openwhisk) |
| [openwhisk-apigateway](https://github.com/apache/openwhisk-apigateway) | Apache OpenWhisk API Gateway service for exposing actions as REST interfaces. | [![Build Status](https://travis-ci.com/apache/openwhisk-apigateway.svg?branch=master)](https://travis-ci.com/apache/openwhisk-apigateway) |
| [openwhisk-catalog](https://github.com/apache/openwhisk-catalog) | Curated catalog of Apache OpenWhisk packages to interface with event producers and consumers | [![Build Status](https://travis-ci.com/apache/openwhisk-catalog.svg?branch=master)](https://travis-ci.com/apache/openwhisk-catalog) |
| [openwhisk-cli](https://github.com/apache/openwhisk-cli) | Apache OpenWhisk Command Line Interface (CLI) | [![Build Status](https://travis-ci.com/apache/openwhisk-cli.svg?branch=master)](https://travis-ci.com/apache/openwhisk-cli) |
| [openwhisk-composer](https://github.com/apache/openwhisk-composer) | Apache OpenWhisk Composer provides a high-level programming model in JavaScript for composing serverless functions | [![Build Status](https://travis-ci.com/apache/openwhisk-composer.svg?branch=master)](https://travis-ci.com/apache/openwhisk-composer) |
| [openwhisk-composer-python](https://github.com/apache/openwhisk-composer-python) | Apache OpenWhisk Composer Python provides a high-level programming model in Python for composing serverless functions | [![Build Status](https://travis-ci.com/apache/openwhisk-composer-python.svg?branch=master)](https://travis-ci.com/apache/openwhisk-composer-python) |
| [openwhisk-wskdeploy](https://github.com/apache/openwhisk-wskdeploy) | Apache OpenWhisk utility for deploying and managing OpenWhisk projects and packages | [![Build Status](https://travis-ci.com/apache/openwhisk-wskdeploy.svg?branch=master)](https://travis-ci.com/apache/openwhisk-wskdeploy) |


## Clients

| Module | Description | Module Status |
|---	|---	|---    |
| [openwhisk-client-go](https://github.com/apache/openwhisk-client-go) | Go client library for the Apache OpenWhisk platform | [![Build Status](https://travis-ci.com/apache/openwhisk-client-go.svg?branch=master)](https://travis-ci.com/apache/openwhisk-client-go) |
| [openwhisk-client-js](https://github.com/apache/openwhisk-client-js) | JavaScript client library for the Apache OpenWhisk platform | [![Build Status](https://travis-ci.com/apache/openwhisk-client-js.svg?branch=master)](https://travis-ci.com/apache/openwhisk-client-js) |


## Runtimes

| Module | Description | Module Status |
|---	|---	|---    |
| [openwhisk-runtime-deno](https://github.com/apache/openwhisk-runtime-deno) | Apache OpenWhisk Runtime Deno supports Apache OpenWhisk functions written in Deno | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-deno.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-deno) |
| [openwhisk-runtime-docker](https://github.com/apache/openwhisk-runtime-docker) | Apache OpenWhisk SDK for building Docker "blackbox" runtimes | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-docker.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-docker) |
| [openwhisk-runtime-dotnet](https://github.com/apache/openwhisk-runtime-dotnet) | Apache OpenWhisk Runtime .Net supports Apache OpenWhisk functions written in .Net languages | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-dotnet.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-dotnet) |
| [openwhisk-runtime-go](https://github.com/apache/openwhisk-runtime-go) | Apache OpenWhisk Runtime Go supports Apache OpenWhisk functions written in Go | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-go.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-go) |
| [openwhisk-runtime-java](https://github.com/apache/openwhisk-runtime-java) | Apache OpenWhisk Runtime Java supports Apache OpenWhisk functions written in Java and other JVM-hosted languages | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-java.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-java) |
| [openwhisk-runtime-nodejs](https://github.com/apache/openwhisk-runtime-nodejs) | Apache OpenWhisk Runtime NodeJS supports Apache OpenWhisk functions written in JavaScript for NodeJS | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-nodejs.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-nodejs) |
| [openwhisk-runtime-php](https://github.com/apache/openwhisk-runtime-php) | Apache OpenWhisk Runtime PHP supports Apache OpenWhisk functions written in PHP | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-php.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-php) |
| [openwhisk-runtime-python](https://github.com/apache/openwhisk-runtime-python) | Apache OpenWhisk Runtime Python supports Apache OpenWhisk functions written in Python | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-python.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-python) |
| [openwhisk-runtime-ruby](https://github.com/apache/openwhisk-runtime-ruby) | Apache OpenWhisk Runtime Ruby supports Apache OpenWhisk functions written in Ruby | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-ruby.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-ruby) |
| [openwhisk-runtime-rust](https://github.com/apache/openwhisk-runtime-rust) | Apache OpenWhisk Runtime Rust supports Apache OpenWhisk functions written in Rust | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-rust.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-rust) |
| [openwhisk-runtime-swift](https://github.com/apache/openwhisk-runtime-swift) | Apache OpenWhisk Runtime Swift supports Apache OpenWhisk functions written in Swift | [![Build Status](https://travis-ci.com/apache/openwhisk-runtime-swift.svg?branch=master)](https://travis-ci.com/apache/openwhisk-runtime-swift) |


## Deployments

| Module | Description | Module Status |
|---	|---	|---    |
| [openwhisk-deploy-kube](https://github.com/apache/openwhisk-deploy-kube) | The Apache OpenWhisk Kubernetes Deployment repository supports deploying the Apache OpenWhisk system on Kubernetes and OpenShift clusters. | [![Build Status](https://travis-ci.com/apache/openwhisk-deploy-kube.svg?branch=master)](https://travis-ci.com/apache/openwhisk-deploy-kube) |


## Packages

| Module | Description | Module Status |
|---	|---	|---    |
| [openwhisk-package-alarms](https://github.com/apache/openwhisk-package-alarms) | Apache OpenWhisk package that can be used to create periodic, time-based alarms. | [![Build Status](https://travis-ci.com/apache/openwhisk-package-alarms.svg?branch=master)](https://travis-ci.com/apache/openwhisk-package-alarms) |
| [openwhisk-package-cloudant](https://github.com/apache/openwhisk-package-cloudant) | The Apache OpenWhisk cloudant package enables you to work with a Cloudant/CouchDB database | [![Build Status](https://travis-ci.com/apache/openwhisk-package-cloudant.svg?branch=master)](https://travis-ci.com/apache/openwhisk-package-cloudant) |
| [openwhisk-package-deploy](https://github.com/apache/openwhisk-package-deploy) | Apache openwhisk | [![Build Status](https://travis-ci.com/apache/openwhisk-package-deploy.svg?branch=master)](https://travis-ci.com/apache/openwhisk-package-deploy) |
| [openwhisk-package-kafka](https://github.com/apache/openwhisk-package-kafka) | Apache OpenWhisk package for communicating with Kafka or Message Hub | [![Build Status](https://travis-ci.com/apache/openwhisk-package-kafka.svg?branch=master)](https://travis-ci.com/apache/openwhisk-package-kafka) |
| [openwhisk-package-pushnotifications](https://github.com/apache/openwhisk-package-pushnotifications) | OpenWhisk Package for Bluemix Push Notifications Service | [![Build Status](https://travis-ci.com/apache/openwhisk-package-pushnotifications.svg?branch=master)](https://travis-ci.com/apache/openwhisk-package-pushnotifications) |
| [openwhisk-pluggable-provider](https://github.com/apache/openwhisk-pluggable-provider) | Apache OpenWhisk pluggable trigger feed event provider  | [![Build Status](https://travis-ci.com/apache/openwhisk-pluggable-provider.svg?branch=master)](https://travis-ci.com/apache/openwhisk-pluggable-provider) |


## Samples and Examples

| Module | Description |
|---	|---	|
| [openwhisk-slackinvite](https://github.com/apache/openwhisk-slackinvite) | Invite for Apache OpenWhisk Team on Slack |


## Development Tools

| Module | Description |
|---	|---	|
| [openwhisk-devtools](https://github.com/apache/openwhisk-devtools) | Development tools for building and deploying Apache OpenWhisk |
| [openwhisk-intellij-plugin](https://github.com/apache/openwhisk-intellij-plugin) | Intellij plugin for Apache OpenWhisk |
| [openwhisk-vscode-extension](https://github.com/apache/openwhisk-vscode-extension) | VSCode extension for Apache OpenWhisk |
| [openwhisk-wskdebug](https://github.com/apache/openwhisk-wskdebug) | Debugging and live development tool for Apache OpenWhisk |


## Utilities

| Module | Description |
|---	|---	|
| [openwhisk-release](https://github.com/apache/openwhisk-release) | Tools and documentation for Apache OpenWhisk Release Managers |
| [openwhisk-utilities](https://github.com/apache/openwhisk-utilities) | Shared utilities used across Apache OpenWhisk project repositories. |


## Others

| Module | Description |
|---	|---	|
| [openwhisk-test](https://github.com/apache/openwhisk-test) | Test repo. for Apache OpenWhisk client-side tooling. |
| [openwhisk-website](https://github.com/apache/openwhisk-website) | Apache OpenWhisk website (openwhisk.apache.org) content; built using Jekyll |


## Archived

| Module | Description |
|---	|---	|
| [openwhisk-GitHubSlackBot](https://github.com/apache/openwhisk-GitHubSlackBot) | [DEPRECATED] - Demonstration of integration of GitHub Pull Request management with Slack and using Alarms |
| [openwhisk-client-python](https://github.com/apache/openwhisk-client-python) | [DEPRECATED] - REST API of OpenWhisk can be used directly from Python |
| [openwhisk-client-swift](https://github.com/apache/openwhisk-client-swift) | [DEPRECATED] - openwhisk-client-swift is a Swift client SDK for OpenWhisk with support for iOS, WatchOS2, and Darwin CLI apps |
| [openwhisk-debugger](https://github.com/apache/openwhisk-debugger) | [DEPRECATED] - The OpenWhisk debugger project |
| [openwhisk-deploy-mesos](https://github.com/apache/openwhisk-deploy-mesos) | Apache OpenWhisk deployment scripts and configuration files for running under Apache Mesos. |
| [openwhisk-deploy-openshift](https://github.com/apache/openwhisk-deploy-openshift) | [DEPRECATED] - This project can be used to deploy Apache OpenWhisk to the OpenShift platform |
| [openwhisk-external-resources](https://github.com/apache/openwhisk-external-resources) | ✨ Curated list of awesome OpenWhisk things ✨ |
| [openwhisk-package-jira](https://github.com/apache/openwhisk-package-jira) | [DEPRECATED] - Interact with JIRA software software development tool used for issue tracking, and project management functions |
| [openwhisk-package-rss](https://github.com/apache/openwhisk-package-rss) | [DEPRECATED] - RSS feed package |
| [openwhisk-package-template](https://github.com/apache/openwhisk-package-template) | [DEPRECATED] - This is a template to be use when creating new packages for OpenWhisk |
| [openwhisk-playground](https://github.com/apache/openwhisk-playground) | [DEPRECATED] - This library provides functionality of executing a snippet of source code as OpenWhisk action for OpenWhisk Xcode Source Editor Extension |
| [openwhisk-podspecs](https://github.com/apache/openwhisk-podspecs) | [DEPRECATED] - CocoaPods Podspecs repo for openwhisk-client-swift |
| [openwhisk-runtime-ballerina](https://github.com/apache/openwhisk-runtime-ballerina) | Apache OpenWhisk Runtime Ballerina supports Apache OpenWhisk functions written in Ballerina |
| [openwhisk-sample-matos](https://github.com/apache/openwhisk-sample-matos) | [DEPRECATED] - sample application with Message Hub and Object Store |
| [openwhisk-sample-slackbot](https://github.com/apache/openwhisk-sample-slackbot) | [DEPRECATED] - A proof-of-concept Slackbot to invoke OpenWhisk actions. |
| [openwhisk-selfserve-test](https://github.com/apache/openwhisk-selfserve-test) | [DEPRECATED] - Apache openwhisk |
| [openwhisk-tutorial](https://github.com/apache/openwhisk-tutorial) | [DEPRECATED] - An interactive learning environment for the Apache OpenWhisk command line |
| [openwhisk-vscode](https://github.com/apache/openwhisk-vscode) | [DEPRECATED] - Visual Studio Code extension (prototype) for authoring OpenWhisk actions inside the editor. |
| [openwhisk-workshop](https://github.com/apache/openwhisk-workshop) | [DEPRECATED] - OpenWhisk workshop to help developers learn how to build serverless applications using the platform. |
| [openwhisk-xcode](https://github.com/apache/openwhisk-xcode) | [DEPRECATED] - Collection of OpenWhisk tools for OS X implemented in Swift 3. |


