/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskRunner
implements TaskRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTaskRunner.class);
    protected ListeningExecutorService writerPool;
    private boolean stopped;

    public BaseTaskRunner(ExecutorService service) {
        this.writerPool = MoreExecutors.listeningDecorator((ExecutorService)service);
    }

    @Override
    public <R> Pair<List<R>, List<Future<R>>> submit(TaskBatch<R> tasks) throws CancellationException, ExecutionException, InterruptedException {
        ArrayList<ListenableFuture<R>> futures = new ArrayList<ListenableFuture<R>>(tasks.size());
        for (Task<R> task : tasks.getTasks()) {
            futures.add(this.writerPool.submit(task));
        }
        try {
            return Pair.newPair((Object)this.submitTasks(futures).get(), Collections.unmodifiableList(futures));
        }
        catch (CancellationException e) {
            this.logAndNotifyAbort(e, tasks);
            throw e;
        }
        catch (ExecutionException e) {
            this.logAndNotifyAbort(e, tasks);
            throw e;
        }
    }

    private void logAndNotifyAbort(Exception e, Abortable abort) {
        String msg = "Found a failed task because: " + e.getMessage();
        LOGGER.error(msg, (Throwable)e);
        abort.abort(msg, e.getCause());
    }

    protected abstract <R> ListenableFuture<List<R>> submitTasks(List<ListenableFuture<R>> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> Pair<List<R>, List<Future<R>>> submitUninterruptible(TaskBatch<R> tasks) throws EarlyExitFailure, ExecutionException {
        block8: {
            boolean interrupted = false;
            while (true) {
                if (this.isStopped()) break block8;
                try {
                    Pair<List<R>, List<Future<R>>> pair = this.submit(tasks);
                    return pair;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new EarlyExitFailure("Interrupted and stopped before computation was complete!");
    }

    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        LOGGER.info("Shutting down task runner because " + why);
        this.writerPool.shutdownNow();
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

