/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import org.apache.hadoop.hbase.Cell;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.GroupedAggregatingResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.KeyValueUtil;

public class UngroupedAggregatingResultIterator
extends GroupedAggregatingResultIterator {
    private boolean hasRows = false;

    public UngroupedAggregatingResultIterator(PeekingResultIterator resultIterator, Aggregators aggregators) {
        super(resultIterator, aggregators);
    }

    @Override
    public Tuple next() throws SQLException {
        Tuple result = this.resultIterator.next();
        if (result == null) {
            if (!this.hasRows) {
                this.aggregators.reset(this.aggregators.getAggregators());
                byte[] value = this.aggregators.toBytes(this.aggregators.getAggregators());
                result = new SingleKeyValueTuple((Cell)KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value));
            }
        } else {
            Tuple tuple;
            Aggregator[] rowAggregators = this.aggregators.getAggregators();
            this.aggregators.reset(rowAggregators);
            while (true) {
                this.aggregators.aggregate(rowAggregators, result);
                Tuple nextResult = this.resultIterator.peek();
                if (nextResult == null) break;
                result = this.resultIterator.next();
            }
            byte[] value = this.aggregators.toBytes(rowAggregators);
            result = tuple = this.wrapKeyValueAsResult(KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length));
        }
        this.hasRows = true;
        return result;
    }

    @Override
    public String toString() {
        return "UngroupedAggregatingResultIterator [hasRows=" + this.hasRows + ", aggregators=" + this.aggregators + "]";
    }
}

