/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.JodaTimezoneCache;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.joda.time.DateTimeZone;

@FunctionParseNode.BuiltInFunction(name="TIMEZONE_OFFSET", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PDate.class})})
public class TimezoneOffsetFunction
extends ScalarFunction {
    public static final String NAME = "TIMEZONE_OFFSET";
    private static final int MILLIS_TO_MINUTES = 60000;

    public TimezoneOffsetFunction() {
    }

    public TimezoneOffsetFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        DateTimeZone timezoneInstance = JodaTimezoneCache.getInstance(ptr);
        if (!((Expression)this.children.get(1)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long date = PDate.INSTANCE.getCodec().decodeLong(ptr, ((Expression)this.children.get(1)).getSortOrder());
        int offset = timezoneInstance.getOffset(date);
        ptr.set(PInteger.INSTANCE.toBytes(offset / 60000));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return ((Expression)this.children.get(0)).isNullable() || ((Expression)this.children.get(1)).isNullable();
    }
}

