/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PrefixFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.StringUtil;

@FunctionParseNode.BuiltInFunction(name="SUBSTR", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PLong.class}), @FunctionParseNode.Argument(allowedTypes={PLong.class}, defaultValue="null")})
public class SubstrFunction
extends PrefixFunction {
    public static final String NAME = "SUBSTR";
    private boolean hasLengthExpression;
    private boolean isOffsetConstant;
    private boolean isLengthConstant;
    private boolean isFixedWidth;
    private Integer maxLength;

    public SubstrFunction() {
    }

    public SubstrFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        Number offsetNumber;
        this.isOffsetConstant = this.getOffsetExpression() instanceof LiteralExpression;
        this.isLengthConstant = this.getLengthExpression() instanceof LiteralExpression;
        this.hasLengthExpression = !this.isLengthConstant || ((LiteralExpression)this.getLengthExpression()).getValue() != null;
        boolean bl = this.isFixedWidth = this.getStrExpression().getDataType().isFixedWidth() && (this.hasLengthExpression && this.isLengthConstant || !this.hasLengthExpression && this.isOffsetConstant);
        if (this.hasLengthExpression && this.isLengthConstant) {
            Integer maxLength = ((Number)((LiteralExpression)this.getLengthExpression()).getValue()).intValue();
            this.maxLength = maxLength >= 0 ? maxLength : 0;
        } else if (this.isOffsetConstant && (offsetNumber = (Number)((LiteralExpression)this.getOffsetExpression()).getValue()) != null) {
            int offset = offsetNumber.intValue();
            PDataType type = this.getStrExpression().getDataType();
            if (type.isFixedWidth()) {
                if (offset >= 0) {
                    Integer maxLength = this.getStrExpression().getMaxLength();
                    this.maxLength = maxLength - offset + (offset == 0 ? 0 : 1);
                } else {
                    this.maxLength = -offset;
                }
            }
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression offsetExpression = this.getOffsetExpression();
        if (!offsetExpression.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int offset = offsetExpression.getDataType().getCodec().decodeInt(ptr, offsetExpression.getSortOrder());
        int length = -1;
        if (this.hasLengthExpression) {
            Expression lengthExpression = this.getLengthExpression();
            if (!lengthExpression.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            length = lengthExpression.getDataType().getCodec().decodeInt(ptr, lengthExpression.getSortOrder());
            if (length <= 0) {
                return false;
            }
        }
        if (!this.getStrExpression().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        boolean isCharType = this.getStrExpression().getDataType() == PChar.INSTANCE;
        SortOrder sortOrder = this.getStrExpression().getSortOrder();
        int strlen = isCharType ? ptr.getLength() : StringUtil.calculateUTF8Length(ptr.get(), ptr.getOffset(), ptr.getLength(), sortOrder);
        if ((offset -= offset <= 0 ? 0 : 1) < 0) {
            offset = strlen + offset;
        }
        if (offset < 0 || offset >= strlen) {
            return false;
        }
        int maxLength = strlen - offset;
        length = length == -1 ? maxLength : Math.min(length, maxLength);
        int byteOffset = isCharType ? offset : StringUtil.getByteLengthForUtf8SubStr(ptr.get(), ptr.getOffset(), offset, sortOrder);
        int byteLength = isCharType ? length : StringUtil.getByteLengthForUtf8SubStr(ptr.get(), ptr.getOffset() + byteOffset, length, sortOrder);
        ptr.set(ptr.get(), ptr.getOffset() + byteOffset, byteLength);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return this.isFixedWidth ? this.getStrExpression().getDataType() : PVarchar.INSTANCE;
    }

    @Override
    public boolean isNullable() {
        return this.getStrExpression().isNullable() || !this.isFixedWidth || this.getOffsetExpression().isNullable();
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getStrExpression().getSortOrder();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    private Expression getStrExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getOffsetExpression() {
        return (Expression)this.children.get(1);
    }

    private Expression getLengthExpression() {
        return (Expression)this.children.get(2);
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        int offset;
        LiteralExpression literal;
        Number offsetNumber;
        if (!(!this.isOffsetConstant || (offsetNumber = (Number)(literal = (LiteralExpression)this.getOffsetExpression()).getValue()) == null || (offset = offsetNumber.intValue()) != 0 && offset != 1 || this.hasLengthExpression && !this.isLengthConstant)) {
            return FunctionExpression.OrderPreserving.YES_IF_LAST;
        }
        return FunctionExpression.OrderPreserving.NO;
    }

    @Override
    protected boolean extractNode() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.getName() + "(");
        if (this.children.size() == 0) {
            return buf.append(")").toString();
        }
        if (this.hasLengthExpression) {
            buf.append(this.getStrExpression());
            buf.append(", ");
            buf.append(this.getOffsetExpression());
            buf.append(", ");
            buf.append(this.getLengthExpression());
        } else {
            buf.append(this.getStrExpression());
            buf.append(", ");
            buf.append(this.getOffsetExpression());
        }
        buf.append(")");
        return buf.toString();
    }
}

