/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.filter.ApplyAndFilterDeletesFilter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.scanner.ScannerBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class LazyValueGetter
implements ValueGetter {
    private ScannerBuilder.CoveredDeleteScanner scan;
    private volatile Map<ColumnReference, ImmutableBytesWritable> values;
    private byte[] row;

    public LazyValueGetter(ScannerBuilder.CoveredDeleteScanner scan, byte[] currentRow) {
        this.scan = scan;
        this.row = currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) throws IOException {
        ImmutableBytesWritable value;
        Map<ColumnReference, Object> v = this.values;
        if (v == null) {
            LazyValueGetter lazyValueGetter = this;
            synchronized (lazyValueGetter) {
                v = this.values;
                if (v == null) {
                    this.values = Collections.synchronizedMap(new HashMap());
                    v = this.values;
                }
            }
        }
        if ((value = v.get(ref)) == null) {
            value = this.get(ref);
            ApplyAndFilterDeletesFilter.DeleteTracker deleteTracker = this.scan.getDeleteTracker();
            if (value == null && deleteTracker.deleteFamily != null && deleteTracker.deleteFamily.getTimestamp() == ts) {
                value = HIDDEN_BY_DELETE;
            }
            v.put(ref, value);
        }
        return value;
    }

    private ImmutableBytesPtr get(ColumnReference ref) throws IOException {
        KeyValue first = ref.getFirstKeyValueForRow(this.row);
        if (!this.scan.seek((Cell)first)) {
            return null;
        }
        Cell next = this.scan.next();
        if (ref.matches(next)) {
            return new ImmutableBytesPtr(next.getValueArray(), next.getValueOffset(), next.getValueLength());
        }
        return null;
    }

    @Override
    public byte[] getRowKey() {
        return this.row;
    }
}

