/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AddParseNode;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArrayAllComparisonNode;
import org.apache.phoenix.parse.ArrayAnyComparisonNode;
import org.apache.phoenix.parse.ArrayConstructorNode;
import org.apache.phoenix.parse.ArrayElemRefNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.ExistsParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.InParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ModulusParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.StringConcatParseNode;
import org.apache.phoenix.parse.SubqueryParseNode;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.TraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;

public class ParseNodeRewriter
extends TraverseAllParseNodeVisitor<ParseNode> {
    protected static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private final ColumnResolver resolver;
    private final Map<String, ParseNode> aliasMap;
    private int nodeCount;

    public static ParseNode rewrite(ParseNode where, ParseNodeRewriter rewriter) throws SQLException {
        if (where == null) {
            return null;
        }
        rewriter.reset();
        return where.accept(rewriter);
    }

    public static SelectStatement resolveInternalAlias(SelectStatement selectStament, PhoenixConnection phoenixConnection) throws SQLException {
        ColumnResolver columnResolver = FromCompiler.getResolverForQuery(selectStament, phoenixConnection);
        ParseNodeRewriter parseNodeRewriter = new ParseNodeRewriter(columnResolver, selectStament.getSelect().size());
        return ParseNodeRewriter.rewrite(selectStament, parseNodeRewriter);
    }

    public static SelectStatement rewrite(SelectStatement statement, ParseNodeRewriter rewriter) throws SQLException {
        ArrayList orderByNodes;
        ArrayList groupByNodes;
        ParseNode selectNode;
        AliasedNode aliasedNode;
        int i;
        ArrayList selectNodes;
        ParseNode having;
        ParseNode where;
        Map<String, ParseNode> aliasMap = rewriter.getAliasMap();
        TableNode from = statement.getFrom();
        TableNode normFrom = from == null ? null : from.accept(new TableNodeRewriter(rewriter));
        ParseNode normWhere = where = statement.getWhere();
        if (where != null) {
            rewriter.reset();
            normWhere = where.accept(rewriter);
        }
        OffsetNode offsetNode = statement.getOffset();
        ParseNode offset = null;
        ParseNode normOffset = null;
        if (offsetNode != null) {
            normOffset = offset = statement.getOffset().getOffsetParseNode();
            if (offset != null && !statement.getOffset().isIntegerOffset()) {
                rewriter.reset();
                normOffset = offset.accept(rewriter);
            }
        }
        ParseNode normHaving = having = statement.getHaving();
        if (having != null) {
            rewriter.reset();
            normHaving = having.accept(rewriter);
        }
        ArrayList normSelectNodes = selectNodes = statement.getSelect();
        for (i = 0; i < selectNodes.size(); ++i) {
            aliasedNode = selectNodes.get(i);
            selectNode = aliasedNode.getNode();
            rewriter.reset();
            ParseNode normSelectNode = selectNode.accept(rewriter);
            if (selectNode == normSelectNode) {
                if (selectNodes == normSelectNodes) continue;
                normSelectNodes.add((AliasedNode)aliasedNode);
                continue;
            }
            if (selectNodes == normSelectNodes) {
                normSelectNodes = Lists.newArrayList(selectNodes.subList(0, i));
            }
            AliasedNode normAliasedNode = NODE_FACTORY.aliasedNode(aliasedNode.isCaseSensitve() ? '\"' + aliasedNode.getAlias() + '\"' : aliasedNode.getAlias(), normSelectNode);
            normSelectNodes.add(normAliasedNode);
        }
        if (aliasMap != null) {
            for (i = 0; i < normSelectNodes.size(); ++i) {
                aliasedNode = normSelectNodes.get(i);
                selectNode = aliasedNode.getNode();
                String alias = aliasedNode.getAlias();
                if (alias == null) continue;
                aliasMap.put(alias, selectNode);
            }
        }
        ArrayList normGroupByNodes = groupByNodes = statement.getGroupBy();
        for (int i2 = 0; i2 < groupByNodes.size(); ++i2) {
            ParseNode groupByNode = groupByNodes.get(i2);
            rewriter.reset();
            ParseNode normGroupByNode = groupByNode.accept(rewriter);
            if (groupByNode == normGroupByNode) {
                if (groupByNodes == normGroupByNodes) continue;
                normGroupByNodes.add((ParseNode)groupByNode);
                continue;
            }
            if (groupByNodes == normGroupByNodes) {
                normGroupByNodes = Lists.newArrayList(groupByNodes.subList(0, i2));
            }
            normGroupByNodes.add((ParseNode)normGroupByNode);
        }
        ArrayList normOrderByNodes = orderByNodes = statement.getOrderBy();
        for (int i3 = 0; i3 < orderByNodes.size(); ++i3) {
            OrderByNode orderByNode = orderByNodes.get(i3);
            ParseNode node = orderByNode.getNode();
            rewriter.reset();
            ParseNode normNode = node.accept(rewriter);
            if (node == normNode) {
                if (orderByNodes == normOrderByNodes) continue;
                normOrderByNodes.add((OrderByNode)orderByNode);
                continue;
            }
            if (orderByNodes == normOrderByNodes) {
                normOrderByNodes = Lists.newArrayList(orderByNodes.subList(0, i3));
            }
            normOrderByNodes.add(NODE_FACTORY.orderBy(normNode, orderByNode.isNullsLast(), orderByNode.isAscending()));
        }
        if (normFrom == from && normWhere == where && normHaving == having && selectNodes == normSelectNodes && groupByNodes == normGroupByNodes && orderByNodes == normOrderByNodes && normOffset == offset) {
            return statement;
        }
        return NODE_FACTORY.select(normFrom, statement.getHint(), statement.isDistinct(), normSelectNodes, normWhere, normGroupByNodes, normHaving, normOrderByNodes, statement.getLimit(), normOffset == null ? null : new OffsetNode(normOffset), statement.getBindCount(), statement.isAggregate(), statement.hasSequence(), statement.getSelects(), statement.getUdfParseNodes());
    }

    private Map<String, ParseNode> getAliasMap() {
        return this.aliasMap;
    }

    public boolean isTopLevel() {
        return this.nodeCount == 0;
    }

    protected ParseNodeRewriter() {
        this.resolver = null;
        this.aliasMap = null;
    }

    protected ParseNodeRewriter(ColumnResolver resolver) {
        this.resolver = resolver;
        this.aliasMap = null;
    }

    protected ParseNodeRewriter(ColumnResolver resolver, int maxAliasCount) {
        this.resolver = resolver;
        this.aliasMap = Maps.newHashMapWithExpectedSize((int)maxAliasCount);
    }

    protected ColumnResolver getResolver() {
        return this.resolver;
    }

    protected void reset() {
        this.nodeCount = 0;
    }

    protected ParseNode leaveCompoundNode(CompoundParseNode node, List<ParseNode> children, CompoundNodeFactory factory) {
        if (children.equals(node.getChildren())) {
            return node;
        }
        return factory.createNode(children);
    }

    @Override
    protected void enterParseNode(ParseNode node) {
    }

    @Override
    public ParseNode visitLeave(AndParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.and(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(OrParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.or(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(SubtractParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.subtract(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(AddParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.add(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(MultiplyParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.multiply(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(DivideParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.divide(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(ModulusParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.modulus(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(final FunctionParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.function(node.getName(), children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(CaseParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.caseWhen(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(final LikeParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.like(children.get(0), children.get(1), node.isNegate(), node.getLikeType());
            }
        });
    }

    @Override
    public ParseNode visitLeave(NotParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.not(children.get(0));
            }
        });
    }

    @Override
    public ParseNode visitLeave(final ExistsParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.exists(children.get(0), node.isNegate());
            }
        });
    }

    @Override
    public ParseNode visitLeave(final CastParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.cast(children.get(0), node.getDataType(), node.getMaxLength(), node.getScale());
            }
        });
    }

    @Override
    public ParseNode visitLeave(final InListParseNode node, List<ParseNode> nodes) throws SQLException {
        ParseNode normNode = this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.inList(children, node.isNegate());
            }
        });
        return normNode;
    }

    @Override
    public ParseNode visitLeave(final InParseNode node, List<ParseNode> nodes) throws SQLException {
        ParseNode normNode = this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.in(children.get(0), children.get(1), node.isNegate(), node.isSubqueryDistinct());
            }
        });
        return normNode;
    }

    @Override
    public ParseNode visitLeave(final IsNullParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.isNull(children.get(0), node.isNegate());
            }
        });
    }

    @Override
    public ParseNode visitLeave(final ComparisonParseNode node, List<ParseNode> nodes) throws SQLException {
        ParseNode normNode = this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.comparison(node.getFilterOp(), children.get(0), children.get(1));
            }
        });
        return normNode;
    }

    @Override
    public ParseNode visitLeave(final BetweenParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                if (node.isNegate()) {
                    return NODE_FACTORY.not(NODE_FACTORY.and(children));
                }
                return NODE_FACTORY.and(children);
            }
        });
    }

    @Override
    public ParseNode visit(ColumnParseNode node) throws SQLException {
        ParseNode aliasedNode;
        if (this.aliasMap != null && node.getTableName() == null && (aliasedNode = this.aliasMap.get(node.getName())) != null && !node.equals(aliasedNode)) {
            ColumnParseNode aliasedColumnNode;
            ColumnRef aliasedRef;
            ColumnRef ref;
            try {
                ref = this.resolver.resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            }
            catch (ColumnNotFoundException e) {
                return aliasedNode;
            }
            if (aliasedNode instanceof ColumnParseNode && (aliasedRef = this.resolver.resolveColumn((aliasedColumnNode = (ColumnParseNode)aliasedNode).getSchemaName(), aliasedColumnNode.getTableName(), aliasedColumnNode.getName())).equals(ref)) {
                return aliasedNode;
            }
            throw new AmbiguousColumnException(node.getName());
        }
        return node;
    }

    @Override
    public ParseNode visit(LiteralParseNode node) throws SQLException {
        return node;
    }

    @Override
    public ParseNode visit(BindParseNode node) throws SQLException {
        return node;
    }

    @Override
    public ParseNode visit(WildcardParseNode node) throws SQLException {
        return node;
    }

    @Override
    public ParseNode visit(TableWildcardParseNode node) throws SQLException {
        return node;
    }

    @Override
    public ParseNode visit(FamilyWildcardParseNode node) throws SQLException {
        return node;
    }

    @Override
    public ParseNode visit(SubqueryParseNode node) throws SQLException {
        return node;
    }

    @Override
    public List<ParseNode> newElementList(int size) {
        this.nodeCount += size;
        return new ArrayList<ParseNode>(size);
    }

    @Override
    public ParseNode visitLeave(StringConcatParseNode node, List<ParseNode> l) throws SQLException {
        return this.leaveCompoundNode(node, l, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.concat(children);
            }
        });
    }

    @Override
    public void addElement(List<ParseNode> l, ParseNode element) {
        --this.nodeCount;
        if (element != null) {
            l.add(element);
        }
    }

    @Override
    public ParseNode visitLeave(RowValueConstructorParseNode node, List<ParseNode> children) throws SQLException {
        if (children.get(children.size() - 1) == null) {
            children = Lists.newArrayList(children);
            do {
                children.remove(children.size() - 1);
            } while (children.size() > 0 && children.get(children.size() - 1) == null);
            if (children.size() == 0) {
                return null;
            }
            if (children.size() == 1) {
                return (ParseNode)children.get(0);
            }
        }
        ArrayList flattenedChildren = children;
        for (int i = 0; i < children.size(); ++i) {
            ParseNode child = (ParseNode)children.get(i);
            if (!(child instanceof RowValueConstructorParseNode)) continue;
            if (flattenedChildren == children) {
                flattenedChildren = Lists.newArrayListWithExpectedSize((int)(children.size() + child.getChildren().size()));
                flattenedChildren.addAll(children.subList(0, i));
            }
            flattenedChildren.addAll(child.getChildren());
        }
        return this.leaveCompoundNode(node, flattenedChildren, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.rowValueConstructor(children);
            }
        });
    }

    @Override
    public ParseNode visit(SequenceValueParseNode node) throws SQLException {
        return node;
    }

    @Override
    public ParseNode visitLeave(ArrayConstructorNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.upsertStmtArrayNode(children);
            }
        });
    }

    @Override
    public ParseNode visitLeave(ArrayAnyComparisonNode node, final List<ParseNode> nodes) throws SQLException {
        ParseNode normNode = this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.arrayAny((ParseNode)nodes.get(0), (ComparisonParseNode)nodes.get(1));
            }
        });
        return normNode;
    }

    @Override
    public ParseNode visitLeave(ArrayAllComparisonNode node, final List<ParseNode> nodes) throws SQLException {
        ParseNode normNode = this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.arrayAll((ParseNode)nodes.get(0), (ComparisonParseNode)nodes.get(1));
            }
        });
        return normNode;
    }

    @Override
    public ParseNode visitLeave(ArrayElemRefNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.elementRef(children);
            }
        });
    }

    private static class TableNodeRewriter
    implements TableNodeVisitor<TableNode> {
        private final ParseNodeRewriter parseNodeRewriter;

        public TableNodeRewriter(ParseNodeRewriter parseNodeRewriter) {
            this.parseNodeRewriter = parseNodeRewriter;
        }

        @Override
        public TableNode visit(BindTableNode boundTableNode) throws SQLException {
            return boundTableNode;
        }

        @Override
        public TableNode visit(JoinTableNode joinNode) throws SQLException {
            ParseNode normOnNode;
            TableNode lhsNode = joinNode.getLHS();
            TableNode rhsNode = joinNode.getRHS();
            ParseNode onNode = joinNode.getOnNode();
            TableNode normLhsNode = lhsNode.accept(this);
            TableNode normRhsNode = rhsNode.accept(this);
            this.parseNodeRewriter.reset();
            ParseNode parseNode = normOnNode = onNode == null ? null : onNode.accept(this.parseNodeRewriter);
            if (lhsNode == normLhsNode && rhsNode == normRhsNode && onNode == normOnNode) {
                return joinNode;
            }
            return NODE_FACTORY.join(joinNode.getType(), normLhsNode, normRhsNode, normOnNode, joinNode.isSingleValueOnly());
        }

        @Override
        public TableNode visit(NamedTableNode namedTableNode) throws SQLException {
            return namedTableNode;
        }

        @Override
        public TableNode visit(DerivedTableNode subselectNode) throws SQLException {
            return subselectNode;
        }
    }

    protected static interface CompoundNodeFactory {
        public ParseNode createNode(List<ParseNode> var1);
    }
}

