/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.persist;

import com.google.common.base.Supplier;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.tephra.persist.HDFSTransactionLogReaderV1;
import org.apache.tephra.persist.HDFSTransactionLogReaderV2;
import org.apache.tephra.persist.HDFSTransactionLogReaderV3;
import org.apache.tephra.persist.TransactionLogReader;

public class HDFSTransactionLogReaderSupplier
implements Supplier<TransactionLogReader> {
    private final SequenceFile.Reader reader;
    private final byte version;
    private TransactionLogReader logReader;

    public HDFSTransactionLogReaderSupplier(SequenceFile.Reader reader) {
        this.reader = reader;
        Text versionInfo = reader.getMetadata().get(new Text("version"));
        this.version = versionInfo == null ? (byte)1 : Byte.parseByte(versionInfo.toString());
    }

    public TransactionLogReader get() {
        if (this.logReader != null) {
            return this.logReader;
        }
        switch (this.version) {
            case 3: {
                this.logReader = new HDFSTransactionLogReaderV3(this.reader);
                return this.logReader;
            }
            case 2: {
                this.logReader = new HDFSTransactionLogReaderV2(this.reader);
                return this.logReader;
            }
            case 1: {
                this.logReader = new HDFSTransactionLogReaderV1(this.reader);
                return this.logReader;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid version %s found in the Transaction Log", this.version));
    }
}

