/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

public class Upsert {
    private String id;
    private String upsertGroup;
    private String statement;
    private List<Column> column;
    private boolean useGlobalConnection;
    private Pattern pattern;
    private long timeoutDuration = Long.MAX_VALUE;

    public Upsert() {
        this.pattern = Pattern.compile("\\[.*?\\]");
    }

    public String getDynamicStatement(RulesApplier ruleApplier, Scenario scenario) throws Exception {
        String ret = this.statement;
        String needQuotes = "";
        Matcher m = this.pattern.matcher(ret);
        while (m.find()) {
            String dynamicField = m.group(0).replace("[", "").replace("]", "");
            Column dynamicColumn = ruleApplier.getRule(dynamicField, scenario);
            needQuotes = dynamicColumn.getType() == DataTypeMapping.CHAR || dynamicColumn.getType() == DataTypeMapping.VARCHAR ? "'" : "";
            ret = ret.replace("[" + dynamicField + "]", needQuotes + ruleApplier.getDataValue(dynamicColumn).getValue() + needQuotes);
        }
        return ret;
    }

    @XmlAttribute
    public String getUpsertGroup() {
        return this.upsertGroup;
    }

    public void setUpsertGroup(String upsertGroup) {
        this.upsertGroup = upsertGroup;
    }

    @XmlAttribute
    public String getId() {
        if (null == this.id) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Column> getColumn() {
        if (this.column == null) {
            return Lists.newArrayList();
        }
        return this.column;
    }

    public void setColumn(List<Column> column) {
        this.column = column;
    }

    @XmlAttribute
    public boolean isUseGlobalConnection() {
        return this.useGlobalConnection;
    }

    public void setUseGlobalConnection(boolean useGlobalConnection) {
        this.useGlobalConnection = useGlobalConnection;
    }

    @XmlAttribute
    public long getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public void setTimeoutDuration(long timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement.replaceAll("\\s+", " ");
    }
}

