/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RuleBasedDataGenerator;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SequentialDateDataGenerator
implements RuleBasedDataGenerator {
    private static DateTimeFormatter FMT = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final Column columnRule;
    private final AtomicInteger counter;
    private final LocalDateTime startDateTime = new LocalDateTime();

    public SequentialDateDataGenerator(Column columnRule) {
        Preconditions.checkArgument(columnRule.getDataSequence() == DataSequence.SEQUENTIAL);
        Preconditions.checkArgument(this.isDateType(columnRule.getType()));
        this.columnRule = columnRule;
        this.counter = new AtomicInteger(0);
    }

    @Override
    public DataValue getDataValue() {
        LocalDateTime newDateTime = this.startDateTime.plusSeconds(this.counter.getAndIncrement());
        String formattedDateTime = newDateTime.toString(FMT);
        return new DataValue(this.columnRule.getType(), formattedDateTime);
    }

    boolean isDateType(DataTypeMapping mapping) {
        switch (mapping) {
            case DATE: 
            case TIMESTAMP: {
                return true;
            }
        }
        return false;
    }
}

